/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.io;

import com.kingdee.bos.ctrl.common.KDToolkit;
import com.kingdee.bos.ctrl.helper.ExportContext;
import com.kingdee.bos.ctrl.kdf.util.style.StyleUtil;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.control.ControlPrint;
import com.kingdee.bos.ctrl.print.io.AbstractExport;
import com.kingdee.bos.ctrl.print.io.KDWatermarkPageEvent;
import com.kingdee.bos.ctrl.print.io.PrintFontMapper;
import com.kingdee.bos.ctrl.print.ui.component.PainterInfo;
import com.kingdee.bos.ctrl.print.ui.component.Paper;
import com.kingdee.bos.ctrl.print.ui.view.BasicPainterView;
import com.kingdee.bos.ctrl.print.ui.view.ImagePainter;
import com.kingdee.bos.ctrl.swing.KDFont;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Font;
import java.awt.Graphics2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.svc.util.print.PrintFileUtil;
import kd.bos.svc.util.print.PrtTaskResult;
import kd.bos.svc.util.print.PrtTaskResultServiceHelper;

public class KDPdfExport
extends AbstractExport {
    private ByteArrayOutputStream os;
    private Document document;
    private PdfContentByte pdfContentByte;
    private int pdfIndex = 1;
    private int onePdfCount = 1;
    private PrtTaskResult taskResult;
    public FontMapper DEFAULT_FONTMAPPER = PrintFontMapper.createInstance();
    private static final Log log = LogFactory.getLog(KDPdfExport.class);
    private KDPrinter printer;

    public KDPdfExport() {
        this.taskResult = new PrtTaskResult();
        String taskId = ExportContext.get().getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            taskId = String.valueOf(DB.genLongId((String)"t_svc_printresult"));
            ExportContext.get().setTaskId(taskId);
        }
        this.taskResult.setTaskId(taskId);
        this.taskResult.setOrgId(RequestContext.get().getOrgId() + "");
        this.taskResult.setAppId(ExportContext.get().getAppId());
        this.taskResult.setUserId(RequestContext.get().getUserId());
        this.taskResult.setFormId(ExportContext.get().getFormId());
        this.taskResult.setTemp(ExportContext.get().isPreview());
        this.taskResult.setExtType("pdf");
    }

    public KDPdfExport(OutputStream os) {
        this();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(String fileNamePre, KDPrinter printer) {
        try {
            Paper paper;
            this.begin(fileNamePre, printer);
            ControlPrint cPrint = printer.getControlPrint();
            int index = 0;
            while ((paper = cPrint.getPaper(index)) != null) {
                if (this.onePdfCount > ExportContext.get().getMaxOnePdfSize()) {
                    this.endOne();
                    this.onePdfCount = 1;
                    this.begin(fileNamePre, printer);
                }
                this.exportPaper(paper, fileNamePre, index);
                ++index;
                ++this.onePdfCount;
            }
            this.end();
        }
        finally {
            this.clearTempFile(printer);
        }
    }

    @Override
    public void begin(String fileNamePre, KDPrinter printer) {
        this.os = new ByteArrayOutputStream();
        PrtTaskResult.Attach attach = new PrtTaskResult.Attach();
        String fileName = this.pdfIndex == 1 ? fileNamePre + ".pdf" : fileNamePre + "-" + (this.pdfIndex - 1) + ".pdf";
        attach.setFileName(fileName);
        attach.setSource("A");
        this.taskResult.addAttach(attach);
        this.printer = printer;
        ControlPrint cPrint = printer.getControlPrint();
        Paper paper = cPrint.getPaper(0);
        float width = paper.getWidth();
        float height = paper.getHeight();
        Rectangle rc = new Rectangle((float)StyleUtil.pixelToPt((long)width), (float)StyleUtil.pixelToPt((long)height));
        float topM = paper.getPainterInfo().getAttributeManager().getBodyTopMargin(1000);
        float bottomM = paper.getPainterInfo().getAttributeManager().getBodyBottomMargin(1000);
        float leftM = paper.getPainterInfo().getAttributeManager().getLeftMargin(1000);
        float rightM = paper.getPainterInfo().getAttributeManager().getRightMargin(1000);
        float topPt = (float)StyleUtil.lomToPt(topM * 10.0f);
        float bottomPt = (float)StyleUtil.lomToPt(bottomM * 10.0f);
        float leftPt = (float)StyleUtil.lomToPt(leftM * 10.0f);
        float rightPt = (float)StyleUtil.lomToPt(rightM * 10.0f);
        try {
            this.document = new Document(rc, leftPt, rightPt, topPt, bottomPt);
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)this.document, (OutputStream)this.os);
            if (printer.getWaterMark() != null) {
                KDWatermarkPageEvent watermarkEvent = new KDWatermarkPageEvent();
                watermarkEvent.setWaterMark(printer.getWaterMark());
                pdfWriter.setPageEvent((PdfPageEvent)watermarkEvent);
            }
            this.document.addTitle(fileName);
            this.document.open();
            this.pdfContentByte = pdfWriter.getDirectContent();
        }
        catch (DocumentException e) {
            throw new RuntimeException("PDF Document error:" + e.getMessage(), e);
        }
    }

    @Override
    protected void exportPaper(Paper paper, String fileNamePre, int index) {
        float widthPt = (float)StyleUtil.pixelToPt((long)paper.getWidth());
        float heightPt = (float)StyleUtil.pixelToPt((long)paper.getHeight());
        Rectangle rc = new Rectangle(widthPt, heightPt);
        this.document.setPageSize(rc);
        this.document.newPage();
        PdfTemplate pdftemplate = this.pdfContentByte.createTemplate(widthPt, heightPt);
        Graphics2D graphics2d = pdftemplate.createGraphics(widthPt, heightPt, this.DEFAULT_FONTMAPPER);
        BasicPainterView imagePainter = ExportContext.get().getImagePainter();
        if (imagePainter instanceof ImagePainter) {
            ((ImagePainter)imagePainter).setPaperHeight(heightPt);
            ((ImagePainter)imagePainter).setPdfTemplate(pdftemplate);
            ExportContext.get().setImagePainter(imagePainter);
        }
        graphics2d.scale(72.0 / (double)KDToolkit.getCurrentDpi(), 72.0 / (double)KDToolkit.getCurrentDpi());
        PainterInfo painterInfo = paper.getPainterInfo();
        paper.painting(graphics2d, painterInfo);
        graphics2d.dispose();
        pdftemplate.setWidth(widthPt);
        pdftemplate.setHeight(heightPt);
        this.pdfContentByte.addTemplate(pdftemplate, 0.0f, 0.0f);
    }

    public void loadFont() {
        Font defaultfont = KDFont.loadFontFromJAR("\u601d\u6e90\u5b8b\u4f53 CN", 0, 12);
        this.DEFAULT_FONTMAPPER.awtToPdf(defaultfont);
    }

    public void endOne() {
        try {
            this.document.close();
            this.os.flush();
            PrtTaskResult.Attach attach = (PrtTaskResult.Attach)this.taskResult.getAttach().get(this.pdfIndex - 1);
            String fileStoargeType = ExportContext.get().getFileStorageType();
            String path = this.taskResult.isTemp() ? PrintFileUtil.byteToTempUrl((String)attach.getFileName(), (String)"", (String)"", (byte[])this.os.toByteArray()) : ("2".equals(fileStoargeType) ? PrintFileUtil.saveInputStream2TempFile((String)attach.getFileName(), (InputStream)new ByteArrayInputStream(this.os.toByteArray()), (int)10800) : PrintFileUtil.saveInputStream2FileServer((String)attach.getFileName(), (InputStream)new ByteArrayInputStream(this.os.toByteArray())));
            attach.setFilePath(path);
            ++this.pdfIndex;
            this.os.close();
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
    }

    @Override
    public void end() {
        try {
            this.endOne();
            this.taskResult.setDiskType(ExportContext.get().getFileStorageType());
            PrtTaskResultServiceHelper.savePrtResult((PrtTaskResult)this.taskResult);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }
}

