/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.io;

import com.kingdee.bos.ctrl.print.io.PrintFontMapper;
import com.kingdee.bos.ctrl.swing.KDFont;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.GrayColor;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.watermark.WaterMark;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.svc.acl.AclAdapter;
import kd.bos.url.UrlService;

public class KDWatermarkPageEvent
extends PdfPageEventHelper {
    private static final Log log = LogFactory.getLog(KDWatermarkPageEvent.class);
    private static final Integer WATERMARK_STYLE_TILED = 20;
    private static final Integer WATERMARK_INTERVAL = 80;
    private Image image;
    private WaterMark watermark;
    private com.lowagie.text.Font textFont;
    private FontMapper fontMapper;
    private static final DistributeSessionlessCache cache = AclAdapter.getCacheService().getDistributeSessionlessCache("userservice");

    public void setWaterMark(WaterMark wm) {
        this.watermark = wm;
    }

    public void onOpenDocument(PdfWriter writer, Document document) {
        String imageUrl;
        byte[] bb;
        String imgUrl;
        BaseFont bfChinese = null;
        try {
            bfChinese = this.createBaseFont();
        }
        catch (Exception ex) {
            log.warn("\u6c34\u5370\u6253\u5370--\u521b\u5efa\u6253\u5370\u5b57\u4f53\u5931\u8d25, \u5c06\u5c1d\u8bd5\u4f7f\u7528\u5b57\u4f53\u5305\u521b\u5efa\u5b57\u4f53\u3002 --- " + ex.getCause());
            try {
                bfChinese = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            }
            catch (DocumentException | IOException e) {
                log.error(e);
            }
        }
        if (bfChinese != null) {
            this.textFont = this.createFont(bfChinese);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(imgUrl = this.watermark.getPicture())) && (bb = this.transferOri2Byte(imageUrl = UrlService.getDomainContextUrl() + imgUrl)) != null && bb.length > 0) {
            try {
                this.image = Image.getInstance((byte[])bb);
                this.image.setRotation(-20);
                this.image.setRotationDegrees(45.0f);
                this.image.scalePercent(100.0f);
            }
            catch (BadElementException | IOException e1) {
                log.error(e1.getCause());
            }
        }
    }

    private BaseFont createBaseFont() {
        Font kf = KDFont.loadFontFromJAR("\u601d\u6e90\u5b8b\u4f53 CN", 0, 12);
        if (this.fontMapper == null) {
            this.fontMapper = PrintFontMapper.createInstance();
        }
        return this.fontMapper.awtToPdf(kf);
    }

    private com.lowagie.text.Font createFont(BaseFont bfChinese) {
        int fontSize = 12;
        String size = this.watermark.getFontSize();
        if (StringUtils.isNotBlank((CharSequence)size)) {
            try {
                size = size.replace("px", "");
                fontSize = Integer.parseInt(size);
            }
            catch (Exception ignore) {
                log.warn("\u6c34\u5370\u5b57\u4f53\u8f6c\u6362\u5f02\u5e38\uff1afontSize=%s", (Object)size);
                fontSize = 12;
            }
            this.textFont = new com.lowagie.text.Font(bfChinese, (float)fontSize, 0);
        } else {
            this.textFont = new com.lowagie.text.Font(bfChinese, (float)fontSize, 0, (Color)new GrayColor(0.85f));
        }
        return this.textFont;
    }

    public void onEndPage(PdfWriter writer, Document document) {
        String type;
        float pageWidth = document.getPageSize().getWidth();
        float pageHeight = document.getPageSize().getHeight();
        String wmText = this.watermark.getText();
        if (wmText == null) {
            wmText = "";
        }
        if ("1".equals(type = this.watermark.getType())) {
            if (org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{wmText})) {
                this.textWatermark(this.setColorAndOpacity(writer.getDirectContentUnder()), wmText, pageWidth, pageHeight);
            }
        } else if ("2".equals(type)) {
            this.imgWatermark(this.setColorAndOpacity(writer.getDirectContentUnder()), pageWidth, pageHeight);
        } else if ("3".equals(type) || "4".equals(type)) {
            this.mixWatermark(this.setColorAndOpacity(writer.getDirectContentUnder()), type, wmText, pageWidth, pageHeight);
        }
    }

    private PdfContentByte setColorAndOpacity(PdfContentByte pdfContent) {
        int i = 819;
        String color = this.watermark.getColor();
        if (StringUtils.isNotBlank((CharSequence)color)) {
            i = Integer.parseInt(color.substring(1), 16);
        }
        pdfContent.setColorFill(new Color(i));
        PdfGState gs = new PdfGState();
        float opacity = 0.85f;
        int globalAlpha = this.watermark.getGlobalAlpha();
        if (globalAlpha > 0 && globalAlpha <= 100) {
            opacity = (float)globalAlpha / 100.0f;
        }
        gs.setFillOpacity(opacity);
        pdfContent.setGState(gs);
        return pdfContent;
    }

    private void textWatermark(PdfContentByte pdfContent, String wmText, float pageWidth, float pageHeight) {
        JLabel label = new JLabel();
        label.setText(wmText);
        FontMetrics metrics = label.getFontMetrics(label.getFont());
        int textH = metrics.getHeight();
        int textW = metrics.stringWidth(label.getText());
        int n = textW = textW < 80 ? 80 : textW;
        if (WATERMARK_STYLE_TILED.equals(20)) {
            for (float heigh = (float)WATERMARK_INTERVAL.intValue(); heigh < pageHeight; heigh += 130.0f) {
                for (float width = (float)WATERMARK_INTERVAL.intValue(); width < pageWidth; width += 130.0f) {
                    ColumnText.showTextAligned((PdfContentByte)pdfContent, (int)0, (Phrase)new Phrase(wmText, this.textFont), (float)width, (float)heigh, (float)30.0f);
                }
            }
        } else {
            float textWidth = (pageWidth - (float)textW) / 2.0f;
            float textHeight = (pageHeight - (float)textH) / 2.0f;
            ColumnText.showTextAligned((PdfContentByte)pdfContent, (int)0, (Phrase)new Phrase(wmText, this.textFont), (float)textWidth, (float)textHeight, (float)30.0f);
        }
    }

    private void imgWatermark(PdfContentByte pdfContent, float pageWidth, float pageHeight) {
        if (this.image == null) {
            return;
        }
        boolean oddEven = true;
        try {
            for (float heigh = (float)WATERMARK_INTERVAL.intValue(); heigh < pageHeight; heigh += 130.0f) {
                for (float width = (float)WATERMARK_INTERVAL.intValue(); width < pageWidth; width += 130.0f) {
                    float x = width;
                    if (oddEven) {
                        x -= 60.0f;
                    }
                    pdfContent.addImage(KDWatermarkPageEvent.getWaterMarkImage(this.image, x, heigh));
                }
                oddEven = !oddEven;
            }
        }
        catch (DocumentException e) {
            log.error((Throwable)e);
        }
        PdfGState gs = new PdfGState();
        gs.setFillOpacity(0.8f);
        gs.setStrokeOpacity(0.8f);
        gs.setOverPrintStroking(true);
        pdfContent.setGState(gs);
    }

    private void mixWatermark(PdfContentByte pdfContent, String type, String wmText, float pageWidth, float pageHeight) {
        boolean oddEven = true;
        try {
            for (float heigh = (float)WATERMARK_INTERVAL.intValue(); heigh < pageHeight; heigh += 130.0f) {
                for (float width = (float)WATERMARK_INTERVAL.intValue(); width < pageWidth; width += 130.0f) {
                    float x = width;
                    if (oddEven) {
                        x -= 60.0f;
                    }
                    float imgH = 0.0f;
                    float imgW = 0.0f;
                    if (this.image != null) {
                        Image newImg = KDWatermarkPageEvent.getWaterMarkImage(this.image, x, heigh);
                        imgH = newImg.getHeight();
                        imgW = newImg.getWidth();
                        pdfContent.addImage(newImg);
                    }
                    if (!org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{wmText})) continue;
                    if (type.equals("3")) {
                        ColumnText.showTextAligned((PdfContentByte)pdfContent, (int)0, (Phrase)new Phrase(wmText, this.textFont), (float)x, (float)(heigh - imgH - 2.0f), (float)15.0f);
                    }
                    if (!type.equals("4")) continue;
                    ColumnText.showTextAligned((PdfContentByte)pdfContent, (int)0, (Phrase)new Phrase(wmText, this.textFont), (float)(x + imgW + 5.0f), (float)(heigh + 10.0f), (float)15.0f);
                }
                oddEven = !oddEven;
            }
        }
        catch (DocumentException e) {
            log.error((Throwable)e);
        }
    }

    private static Image getWaterMarkImage(Image waterMarkImage, float xPosition, float yPosition) {
        waterMarkImage.setAbsolutePosition(xPosition, yPosition);
        waterMarkImage.setRotation(-20);
        waterMarkImage.setRotationDegrees(15.0f);
        waterMarkImage.scalePercent(100.0f);
        return waterMarkImage;
    }

    private byte[] transferOri2Byte(String url) {
        byte[] result = null;
        try (InputStream is = new URL(url).openStream();
             ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            BufferedImage bi = ImageIO.read(is);
            int height = bi.getHeight();
            int width = bi.getWidth();
            if (height > 22) {
                width = bi.getWidth() * 22 / height;
                height = 22;
            }
            BufferedImage bufferedImage = new BufferedImage(width, height, bi.getType());
            Graphics2D g = bufferedImage.createGraphics();
            g.setComposite(AlphaComposite.getInstance(2));
            g.drawImage(bi, 0, 0, width, height, null);
            g.dispose();
            ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
            result = byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return result;
    }

    private String getCurrentUserPhone() {
        String fieldName = "phone";
        long userId = Long.parseLong(RequestContext.get().getUserId());
        DynamicObject userDynamicObject = null;
        String phoneNumber = "";
        if (cache.get(fieldName + userId) == null) {
            userDynamicObject = ORM.create().queryOne("bos_user", "id,phone", new QFilter[]{new QFilter("id", "=", (Object)userId)});
            if (userDynamicObject != null) {
                phoneNumber = userDynamicObject.getString(fieldName);
            }
            cache.put(fieldName + userId, (Object)phoneNumber, 3600);
        } else {
            phoneNumber = (String)cache.get(fieldName + userId);
        }
        return phoneNumber;
    }
}

