/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.io;

import com.kingdee.bos.ctrl.common.KDToolkit;
import com.kingdee.bos.ctrl.kdf.util.style.StyleUtil;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.control.ControlPrint;
import com.kingdee.bos.ctrl.print.io.AbstractExport;
import com.kingdee.bos.ctrl.print.io.PrintFontMapper;
import com.kingdee.bos.ctrl.print.io.WatermarkPageEvent;
import com.kingdee.bos.ctrl.print.ui.component.PainterInfo;
import com.kingdee.bos.ctrl.print.ui.component.Paper;
import com.kingdee.bos.ctrl.print.util.TempFileUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.browser.R1PrintPageProvider;
import com.kingdee.bos.ctrl.swing.KDFont;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGraphics2D;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Font;
import java.awt.Graphics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

@Deprecated
public class PdfExport
extends AbstractExport {
    private static final Log log = LogFactory.getLog(PdfExport.class);
    private OutputStream os;
    private Document document;
    private PdfContentByte pdfContentByte;
    private FontMapper DEFAULT_FONTMAPPER = PrintFontMapper.createInstance();
    private KDPrinter printer;

    public PdfExport() {
    }

    public PdfExport(OutputStream os) {
        this.os = os;
    }

    @Override
    public void begin(String fileNamePre, KDPrinter printer) {
        if (this.os == null) {
            String des = fileNamePre;
            if (!des.endsWith(".pdf")) {
                des = des + ".pdf";
            }
            File destFile = new File(des);
            try {
                this.os = new FileOutputStream(destFile);
            }
            catch (FileNotFoundException e) {
                log.error((Throwable)e);
            }
        }
        this.printer = printer;
        ControlPrint cPrint = printer.getControlPrint();
        Paper paper = cPrint.getPaper(0);
        float width = paper.getWidth();
        float height = paper.getHeight();
        Rectangle rc = new Rectangle((float)StyleUtil.pixelToPt((long)width), (float)StyleUtil.pixelToPt((long)height));
        float topM = paper.getPainterInfo().getAttributeManager().getBodyTopMargin(1000);
        float bottomM = paper.getPainterInfo().getAttributeManager().getBodyBottomMargin(1000);
        float leftM = paper.getPainterInfo().getAttributeManager().getLeftMargin(1000);
        float rightM = paper.getPainterInfo().getAttributeManager().getRightMargin(1000);
        float topPt = (float)StyleUtil.lomToPt(topM * 10.0f);
        float bottomPt = (float)StyleUtil.lomToPt(bottomM * 10.0f);
        float leftPt = (float)StyleUtil.lomToPt(leftM * 10.0f);
        float rightPt = (float)StyleUtil.lomToPt(rightM * 10.0f);
        try {
            rc.setRotation(rc.getRotation() + 90);
            this.document = new Document(rc, leftPt, rightPt, topPt, bottomPt);
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)this.document, (OutputStream)this.os);
            if (printer.getWaterMark() != null) {
                WatermarkPageEvent watermarkEvent = new WatermarkPageEvent();
                watermarkEvent.setWaterMark(printer.getWaterMark());
                pdfWriter.setPageEvent((PdfPageEvent)watermarkEvent);
            }
            this.document.addTitle(fileNamePre + ".pdf");
            this.document.open();
            this.pdfContentByte = pdfWriter.getDirectContent();
        }
        catch (DocumentException e) {
            log.error((Throwable)e);
        }
    }

    @Override
    protected void exportPaper(Paper paper, String fileNamePre, int index) {
        float widthPt = (float)StyleUtil.pixelToPt((long)paper.getWidth());
        float heightPt = (float)StyleUtil.pixelToPt((long)paper.getHeight());
        Rectangle rc = new Rectangle(widthPt, heightPt);
        this.document.setPageSize(rc);
        this.document.newPage();
        PdfGraphics2D graphics2d = new PdfGraphics2D(this.pdfContentByte, widthPt, heightPt, this.DEFAULT_FONTMAPPER, false, false, 0.0f);
        graphics2d.scale(72.0 / (double)KDToolkit.getCurrentDpi(), 72.0 / (double)KDToolkit.getCurrentDpi());
        PainterInfo painterInfo = paper.getPainterInfo();
        paper.painting((Graphics)graphics2d, painterInfo);
        graphics2d.dispose();
    }

    public void test() {
    }

    public void loadFont() {
        Font defaultfont = KDFont.loadFontFromJAR("\u601d\u6e90\u5b8b\u4f53 CN", 0, 12);
        this.DEFAULT_FONTMAPPER.awtToPdf(defaultfont);
    }

    @Override
    public void end() {
        try {
            this.document.close();
            this.os.flush();
            this.os.close();
            try {
                int jobCount = this.printer.getPrintJob().getTaskCount();
                for (int i = 0; i < jobCount; ++i) {
                    ((R1PrintPageProvider)this.printer.getPrintJob().getPrintJob(i).getPageProvider()).clearTempFile();
                    boolean result = TempFileUtil.clearPrintTempFileDir();
                    log.debug("\u6e05\u7406\u6253\u5370\u521b\u5efa\u7684\u4e34\u65f6\u6587\u4ef6\uff0c\u6e05\u9664\u7ed3\u679c\u4e3a\uff1a" + result);
                }
            }
            catch (Exception ignore) {
                log.error("\u6e05\u7406\u6253\u5370\u521b\u5efa\u7684\u4e34\u65f6\u6587\u4ef6\u5931\u8d25\uff1a", (Throwable)ignore);
            }
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
    }
}

