/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.io;

import com.kingdee.bos.ctrl.common.util.PrintFontUtil;
import com.kingdee.bos.ctrl.common.util.PrtFont;
import com.kingdee.bos.ctrl.swing.KDFont;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.FontMapper;
import java.awt.Font;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang.StringUtils;

public class PrintFontMapper
implements FontMapper {
    public static final String CP_1252 = "Cp1252";
    private static final Log log = LogFactory.getLog(PrintFontMapper.class);
    private static BaseFont defaultFont;
    private Map<String, Object> aliases = new HashMap<String, Object>();
    private Map<String, Object> mapper = new HashMap<String, Object>();
    private static Map<String, BaseFont> fontCache;
    private static Map<String, PrintFontMapper> instanceMap;

    private PrintFontMapper() {
    }

    public static FontMapper createInstance() {
        String tenantId = RequestContext.get().getTenantId();
        if (instanceMap.containsKey(tenantId)) {
            return instanceMap.get(tenantId);
        }
        PrintFontMapper fontMapper = new PrintFontMapper();
        instanceMap.put(tenantId, fontMapper);
        return fontMapper;
    }

    public BaseFont awtToPdf(Font font) {
        try {
            String fontFileName;
            String fontName = font.getFontName(Locale.SIMPLIFIED_CHINESE);
            List<PrtFont> fonts = PrintFontUtil.getFonts();
            Map<String, PrtFont> fontMapping = fonts.stream().collect(Collectors.toMap(item -> item.getFontName(), item -> item));
            PrtFont prtFont = fontMapping.get(fontName);
            if (prtFont == null) {
                if (StringUtils.equals((String)"Dialog.plain", (String)fontName)) {
                    return this.getDefaultFont();
                }
                fontName = font.getFontName(Locale.ENGLISH);
                prtFont = fontMapping.get(fontName);
                if (prtFont == null) {
                    log.debug("Print-\u5b57\u4f53awtToPdf 2\u6b21\u672a\u627e\u5230\uff1a" + fontName);
                    return this.getDefaultFont();
                }
            }
            if ((fontFileName = prtFont.getFontFileName()) == null) {
                return this.getDefaultFont();
            }
            if (fontCache.containsKey(fontFileName)) {
                return fontCache.get(fontFileName);
            }
            BaseFontParameters p = this.getBaseFontParameters(font);
            if (p == null) {
                this.insertDirectory(fontFileName);
                p = this.getBaseFontParameters(font);
            }
            if (p == null) {
                if (this.getDefaultFont() != null) {
                    log.debug("Print-\u5b57\u4f53awtToPdf\uff1ap\u4e3a\u7a7a\uff0c\u53d6\u9ed8\u8ba4\u5b57\u4f53");
                    return this.getDefaultFont();
                }
                log.debug("\u7cfb\u7edf\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5b57\u4f53\uff1a" + font.getName() + " \u4e5f\u6ca1\u6709\u9ed8\u8ba4\u7684\u5b57\u4f53");
                throw new ExceptionConverter(new Exception(String.valueOf(String.valueOf(new StringBuilder("Can't find any font named [").append(font.getFontName()).append(" ] installed in your system, default font is not Available too.")))));
            }
            BaseFont basefont1 = BaseFont.createFont((String)p.fontName, (String)p.encoding, (boolean)p.embedded, (boolean)p.cached, null, null);
            fontCache.put(fontFileName, basefont1);
            return basefont1;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            if (this.getDefaultFont() != null) {
                return this.getDefaultFont();
            }
            throw new ExceptionConverter(e);
        }
    }

    public Font pdfToAwt(BaseFont font, int size) {
        String finalName;
        String[][] names = font.getFullFontName();
        if (names.length == 1) {
            return new Font(names[0][3], 0, size);
        }
        String name10 = null;
        String name3x = null;
        for (int k = 0; k < names.length; ++k) {
            String[] name = names[k];
            if (name[0].equals("1") && name[1].equals("0")) {
                name10 = name[3];
                continue;
            }
            if (!name[2].equals("1033")) continue;
            name3x = name[3];
            break;
        }
        if ((finalName = name3x) == null) {
            finalName = name10;
        }
        if (finalName == null) {
            finalName = names[0][3];
        }
        return new Font(finalName, 0, size);
    }

    private BaseFont getDefaultFont() {
        if (defaultFont == null) {
            PrtFont defPrtFont = PrintFontUtil.getDefaultFont();
            this.insertFontInJAR(defPrtFont.getFontFileName());
            try {
                BaseFontParameters p = this.getBaseFontParameters(defPrtFont.getFontName());
                if (p == null) {
                    defaultFont = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
                    log.debug(String.format("Print-\u6ca1\u6709\u627e\u5230%s\u5b57\u4f53\uff0c\u4f7f\u7528\u4e86\u9ed8\u8ba4\u5b57\u4f53", defPrtFont.getFontName()));
                } else {
                    log.debug("Print-\u9ed8\u8ba4\u5b57\u4f53\u4e3a\uff1a" + p.fontName);
                    defaultFont = BaseFont.createFont((String)p.fontName, (String)p.encoding, (boolean)p.embedded, (boolean)p.cached, null, null);
                }
            }
            catch (Exception e1) {
                log.error(e1.getMessage());
                throw new KDException((Throwable)e1, BosErrorCode.systemError, new Object[]{ResManager.loadKDString((String)"\u5b57\u4f53mapper \u521d\u59cb\u5316\u9519\u8bef\u3002", (String)"CustomFontMapper_0", (String)"bos-print-core", (Object[])new Object[0])});
            }
        }
        return defaultFont;
    }

    private BaseFontParameters getBaseFontParameters(Font font) {
        int style;
        BaseFontParameters p = this.getBaseFontParameters(font.getFontName());
        if (p == null && (style = font.getStyle()) != 0) {
            String styledName = font.getFontName();
            if ((style & 1) != 0) {
                styledName = String.valueOf(String.valueOf(styledName)).concat(" Bold");
            }
            if ((style & 2) != 0) {
                styledName = String.valueOf(String.valueOf(styledName)).concat(" Italic");
            }
            p = this.getBaseFontParameters(styledName);
        }
        return p;
    }

    private BaseFontParameters getBaseFontParameters(String name) {
        String alias = (String)this.aliases.get(name);
        if (alias == null) {
            return (BaseFontParameters)this.mapper.get(name);
        }
        BaseFontParameters p = (BaseFontParameters)this.mapper.get(alias);
        if (p == null) {
            return (BaseFontParameters)this.mapper.get(name);
        }
        return p;
    }

    private void insertNames(String[][] names, String path) {
        String main = null;
        for (int k = 0; k < names.length; ++k) {
            String[] name = names[k];
            if (!name[2].equals("1033")) continue;
            main = name[3];
            break;
        }
        if (main == null) {
            main = names[0][3];
        }
        BaseFontParameters p = new BaseFontParameters(path);
        this.mapper.put(main, p);
        for (int k = 0; k < names.length; ++k) {
            this.aliases.put(names[k][3], main);
        }
    }

    private boolean insertDirectory(String fileName) {
        String fileFullName = KDFont.getFontFilesDir() + File.separator + fileName;
        File file = new File(fileFullName);
        if (!file.exists() || file.isDirectory()) {
            return false;
        }
        String name = file.getPath().toLowerCase();
        try {
            if (!StringUtils.containsIgnoreCase((String)name, (String)".") || StringUtils.endsWithIgnoreCase((String)name, (String)".ttf") || StringUtils.endsWithIgnoreCase((String)name, (String)".otf") || StringUtils.endsWithIgnoreCase((String)name, (String)".afm")) {
                String[][] names = BaseFont.getFullFontName((String)file.getPath(), (String)CP_1252, null);
                this.insertNames(names, file.getPath());
            } else if (StringUtils.endsWithIgnoreCase((String)name, (String)".ttc")) {
                String[] ttcs = BaseFont.enumerateTTCNames((String)file.getPath());
                for (int j = 0; j < ttcs.length; ++j) {
                    String nt = String.valueOf(String.valueOf(new StringBuilder(file.getPath()).append(",").append(j)));
                    String[][] names = BaseFont.getFullFontName((String)nt, (String)CP_1252, null);
                    this.insertNames(names, nt);
                }
            }
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
            return false;
        }
        return true;
    }

    private boolean insertFontInJAR(String name) {
        try {
            URL fontURL = PrintFontMapper.class.getClassLoader().getResource(name);
            if (!name.contains(".") || name.endsWith(".ttf") || name.endsWith(".otf") || name.endsWith(".afm")) {
                String[][] names = BaseFont.getFullFontName((String)fontURL.toString(), (String)CP_1252, null);
                this.insertNames(names, fontURL.toString());
            } else if (name.endsWith(".ttc")) {
                String[] ttcs = BaseFont.enumerateTTCNames((String)fontURL.toString());
                for (int j = 0; j < ttcs.length; ++j) {
                    String nt = String.valueOf(String.valueOf(new StringBuilder(String.valueOf(String.valueOf(fontURL.toString()))).append(",").append(j)));
                    String[][] names = BaseFont.getFullFontName((String)nt, (String)CP_1252, null);
                    this.insertNames(names, nt);
                }
            }
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
            return false;
        }
        return true;
    }

    static {
        fontCache = new WeakHashMap<String, BaseFont>();
        instanceMap = new HashMap<String, PrintFontMapper>(16);
    }

    static class BaseFontParameters {
        private String fontName;
        private boolean embedded;
        private boolean cached;
        private String encoding;

        public String getFontName() {
            return this.fontName;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public boolean isEmbedded() {
            return this.embedded;
        }

        public BaseFontParameters(String fontName) {
            this.fontName = fontName;
            this.encoding = "Identity-H";
            this.embedded = true;
            this.cached = true;
        }
    }
}

