/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.io;

import com.kingdee.bos.ctrl.print.io.PrintFontMapper;
import com.kingdee.bos.ctrl.swing.KDFont;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.GrayColor;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.watermark.WaterMark;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.svc.acl.AclAdapter;
import kd.bos.url.UrlService;
import org.apache.commons.lang3.StringUtils;

@Deprecated
public class WatermarkPageEvent
extends PdfPageEventHelper {
    private static final Log log = LogFactory.getLog(WatermarkPageEvent.class);
    private static final Integer WATERMARK_STYLE_TILED = 20;
    private static final Integer WATERMARK_INTERVAL = 80;
    private Image image;
    private WaterMark watermark;
    private com.lowagie.text.Font textFont;
    private static final DistributeSessionlessCache cache = AclAdapter.getCacheService().getDistributeSessionlessCache("userservice");

    public void setWaterMark(WaterMark wm) {
        this.watermark = wm;
    }

    public void onOpenDocument(PdfWriter writer, Document document) {
        String imageUrl;
        byte[] bb;
        String imgUrl;
        BaseFont bfChinese = null;
        try {
            bfChinese = this.createBaseFont();
        }
        catch (Exception ex) {
            log.warn("\u6c34\u5370\u6253\u5370--\u521b\u5efa\u6253\u5370\u5b57\u4f53\u5931\u8d25, \u5c06\u5c1d\u8bd5\u4f7f\u7528\u5b57\u4f53\u5305\u521b\u5efa\u5b57\u4f53\u3002 --- " + ex.getCause());
            try {
                bfChinese = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            }
            catch (DocumentException | IOException e) {
                log.error(e);
            }
        }
        if (bfChinese != null) {
            this.textFont = new com.lowagie.text.Font(bfChinese, 12.0f, 0, (Color)new GrayColor(0.85f));
        }
        if (StringUtils.isNotBlank((CharSequence)(imgUrl = this.watermark.getPicture())) && (bb = this.transferOri2Byte(imageUrl = UrlService.getDomainContextUrl() + imgUrl)) != null && bb.length > 0) {
            try {
                this.image = Image.getInstance((byte[])bb);
                this.image.setRotation(-20);
                this.image.setRotationDegrees(45.0f);
                this.image.scalePercent(100.0f);
            }
            catch (BadElementException | IOException e1) {
                log.error(e1.getCause());
            }
        }
    }

    private BaseFont createBaseFont() {
        Font kf = KDFont.loadFontFromJAR("\u601d\u6e90\u5b8b\u4f53 CN", 0, 12);
        return PrintFontMapper.createInstance().awtToPdf(kf);
    }

    public void onEndPage(PdfWriter writer, Document document) {
        float pageWidth = document.getPageSize().getWidth();
        float pageHeight = document.getPageSize().getHeight();
        String wmText = "";
        if (this.watermark.getTextType().equals("1")) {
            wmText = this.watermark.getText();
        } else if (this.watermark.getTextType().equals("2")) {
            wmText = RequestContext.get().getUserName();
        } else if (this.watermark.getTextType().equals("3")) {
            String phone = this.getCurrentUserPhone();
            String userName = RequestContext.get().getUserName();
            if (StringUtils.isNotEmpty((CharSequence)phone) && phone.length() > 4) {
                phone = phone.substring(phone.length() - 4);
            }
            wmText = userName + phone;
        }
        String type = this.watermark.getType();
        if (type.equals("1")) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{wmText})) {
                this.textWatermark(writer.getDirectContentUnder(), wmText, pageWidth, pageHeight);
            }
        } else if (type.equals("2")) {
            this.imgWatermark(writer.getDirectContentUnder(), pageWidth, pageHeight);
        } else if (type.equals("3") || type.equals("4")) {
            this.mixWatermark(writer.getDirectContentUnder(), type, wmText, pageWidth, pageHeight);
        }
    }

    private void textWatermark(PdfContentByte pdfContent, String wmText, float pageWidth, float pageHeight) {
        JLabel label = new JLabel();
        label.setText(wmText);
        FontMetrics metrics = label.getFontMetrics(label.getFont());
        int textH = metrics.getHeight();
        int textW = metrics.stringWidth(label.getText());
        int n = textW = textW < 80 ? 80 : textW;
        if (WATERMARK_STYLE_TILED.equals(20)) {
            for (float heigh = (float)WATERMARK_INTERVAL.intValue(); heigh < pageHeight; heigh += 130.0f) {
                for (float width = (float)WATERMARK_INTERVAL.intValue(); width < pageWidth; width += 130.0f) {
                    ColumnText.showTextAligned((PdfContentByte)pdfContent, (int)0, (Phrase)new Phrase(wmText, this.textFont), (float)width, (float)heigh, (float)30.0f);
                }
            }
        } else {
            float textWidth = (pageWidth - (float)textW) / 2.0f;
            float textHeight = (pageHeight - (float)textH) / 2.0f;
            ColumnText.showTextAligned((PdfContentByte)pdfContent, (int)0, (Phrase)new Phrase(wmText, this.textFont), (float)textWidth, (float)textHeight, (float)30.0f);
        }
    }

    private void imgWatermark(PdfContentByte pdfContent, float pageWidth, float pageHeight) {
        if (this.image == null) {
            return;
        }
        boolean oddEven = true;
        try {
            for (float heigh = (float)WATERMARK_INTERVAL.intValue(); heigh < pageHeight; heigh += 130.0f) {
                for (float width = (float)WATERMARK_INTERVAL.intValue(); width < pageWidth; width += 130.0f) {
                    float x = width;
                    if (oddEven) {
                        x -= 60.0f;
                    }
                    pdfContent.addImage(WatermarkPageEvent.getWaterMarkImage(this.image, x, heigh));
                }
                oddEven = !oddEven;
            }
        }
        catch (DocumentException e) {
            log.error((Throwable)e);
        }
        PdfGState gs = new PdfGState();
        gs.setFillOpacity(0.8f);
        gs.setStrokeOpacity(0.8f);
        gs.setOverPrintStroking(true);
        pdfContent.setGState(gs);
    }

    private void mixWatermark(PdfContentByte pdfContent, String type, String wmText, float pageWidth, float pageHeight) {
        boolean oddEven = true;
        try {
            for (float heigh = (float)WATERMARK_INTERVAL.intValue(); heigh < pageHeight; heigh += 130.0f) {
                for (float width = (float)WATERMARK_INTERVAL.intValue(); width < pageWidth; width += 130.0f) {
                    float x = width;
                    if (oddEven) {
                        x -= 60.0f;
                    }
                    float imgH = 0.0f;
                    float imgW = 0.0f;
                    if (this.image != null) {
                        Image newImg = WatermarkPageEvent.getWaterMarkImage(this.image, x, heigh);
                        imgH = newImg.getHeight();
                        imgW = newImg.getWidth();
                        pdfContent.addImage(newImg);
                    }
                    if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{wmText})) continue;
                    if (type.equals("3")) {
                        ColumnText.showTextAligned((PdfContentByte)pdfContent, (int)0, (Phrase)new Phrase(wmText, this.textFont), (float)x, (float)(heigh - imgH - 2.0f), (float)15.0f);
                    }
                    if (!type.equals("4")) continue;
                    ColumnText.showTextAligned((PdfContentByte)pdfContent, (int)0, (Phrase)new Phrase(wmText, this.textFont), (float)(x + imgW + 5.0f), (float)heigh, (float)15.0f);
                }
                oddEven = !oddEven;
            }
        }
        catch (DocumentException e) {
            log.error((Throwable)e);
        }
    }

    private static Image getWaterMarkImage(Image waterMarkImage, float xPosition, float yPosition) {
        waterMarkImage.setAbsolutePosition(xPosition, yPosition);
        waterMarkImage.setRotation(-20);
        waterMarkImage.setRotationDegrees(15.0f);
        waterMarkImage.scalePercent(100.0f);
        return waterMarkImage;
    }

    private byte[] transferOri2Byte(String url) {
        byte[] result = null;
        try (InputStream is = new URL(url).openStream();
             ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            BufferedImage bi = ImageIO.read(is);
            int height = bi.getHeight();
            int width = bi.getWidth();
            if (height > 22) {
                width = bi.getWidth() * 22 / height;
                height = 22;
            }
            BufferedImage bufferedImage = new BufferedImage(width, height, bi.getType());
            Graphics2D g = bufferedImage.createGraphics();
            g.setComposite(AlphaComposite.getInstance(2, 0.2f));
            g.drawImage(bi, 0, 0, width, height, null);
            g.dispose();
            ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
            result = byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return result;
    }

    private String getCurrentUserPhone() {
        String fieldName = "phone";
        long userId = Long.parseLong(RequestContext.get().getUserId());
        DynamicObject userDynamicObject = null;
        String phoneNumber = "";
        if (cache.get(fieldName + userId) == null) {
            userDynamicObject = ORM.create().queryOne("bos_user", "id,phone", new QFilter[]{new QFilter("id", "=", (Object)userId)});
            if (userDynamicObject != null) {
                phoneNumber = userDynamicObject.getString(fieldName);
            }
            cache.put(fieldName + userId, (Object)phoneNumber, 3600);
        } else {
            phoneNumber = (String)cache.get(fieldName + userId);
        }
        return phoneNumber;
    }
}

