/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.io;

import com.kingdee.bos.ctrl.helper.ExportContext;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.io.AbstractExport;
import com.kingdee.bos.ctrl.print.ui.component.Paper;
import com.kingdee.bos.ctrl.print.xls.R1PrintV2XExporter;
import com.kingdee.bos.ctrl.print.xls.output.OutputHelper;
import com.kingdee.bos.ctrl.print.xls.widget.XlsPaper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.server.ExportException;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.svc.util.print.PrintFileUtil;
import kd.bos.svc.util.print.PrtTaskResult;
import kd.bos.svc.util.print.PrtTaskResultServiceHelper;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class XlsExport
extends AbstractExport {
    private int horIndetion;
    private int verIndetion;
    private ByteArrayOutputStream os;
    private R1PrintV2XExporter exporter = null;
    private OutputHelper helper;
    private Workbook wb;
    private Logger log = Logger.getLogger(this.getClass());
    private static final String XLS_SUFFIX = ".xlsx";
    private PrtTaskResult taskResult;

    public XlsExport(int horIndetion, int verIndetion) {
        this.horIndetion = horIndetion;
        this.verIndetion = verIndetion;
        this.wb = new SXSSFWorkbook(5000);
        this.helper = new OutputHelper(this.wb);
        this.taskResult = new PrtTaskResult();
        String taskId = ExportContext.get().getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            taskId = String.valueOf(DB.genLongId((String)"t_svc_printresult"));
            ExportContext.get().setTaskId(taskId);
        }
        this.taskResult.setTaskId(taskId);
        this.taskResult.setOrgId(RequestContext.get().getOrgId() + "");
        this.taskResult.setAppId(ExportContext.get().getAppId());
        this.taskResult.setUserId(RequestContext.get().getUserId());
        this.taskResult.setFormId(ExportContext.get().getFormId());
        this.taskResult.setTemp(ExportContext.get().isPreview());
        this.taskResult.setExtType("xls");
    }

    public XlsExport(OutputStream os) {
        this(10, 5);
    }

    public XlsExport(OutputStream os, Map<String, Object> para) {
        this(10, 5);
        this.helper = new OutputHelper(this.wb, para);
    }

    @Override
    public void begin(String fileNamePre, KDPrinter printer) {
        this.os = new ByteArrayOutputStream();
        PrtTaskResult.Attach attach = new PrtTaskResult.Attach();
        attach.setFileName(fileNamePre + XLS_SUFFIX);
        attach.setSource("A");
        this.taskResult.addAttach(attach);
        try {
            this.exporter = new R1PrintV2XExporter();
        }
        catch (ExportException e) {
            this.log.error((Object)"\u521d\u59cb\u5316\u6587\u4ef6\u4e22\u5931", (Throwable)e);
        }
    }

    @Override
    protected void exportPaper(Paper paper, String fileNamePre, int index) {
        XlsPaper node = (XlsPaper)this.exporter.translate(paper, null);
        this.helper.handPaper(node, this.horIndetion, this.verIndetion);
    }

    @Override
    public void end() {
        try {
            this.helper.endOutput(this.horIndetion, this.verIndetion);
            this.wb.write((OutputStream)this.os);
            this.os.flush();
            PrtTaskResult.Attach attach = (PrtTaskResult.Attach)this.taskResult.getAttach().get(0);
            this.taskResult.setDiskType(ExportContext.get().getFileStorageType());
            String path = PrintFileUtil.saveInputStream2TempFile((String)attach.getFileName(), (InputStream)new ByteArrayInputStream(this.os.toByteArray()), (int)10800);
            attach.setFilePath(path);
            PrtTaskResultServiceHelper.savePrtResult((PrtTaskResult)this.taskResult);
            this.os.close();
            this.release();
            this.wb = null;
            this.helper.clearStyleMap();
            this.log.debug((Object)("\u5bfc\u51fa\u7ed3\u675f\u65f6\u95f4\uff1a" + System.currentTimeMillis() + "ms"));
        }
        catch (IOException e) {
            this.log.error((Object)"IO \u5f02\u5e38", (Throwable)e);
        }
    }

    @Override
    public void release() {
        if (this.wb instanceof SXSSFWorkbook) {
            try {
                ((SXSSFWorkbook)this.wb).dispose();
            }
            catch (Exception e) {
                this.log.error((Object)e);
            }
        }
    }
}

