/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.printjob;

import com.kingdee.bos.ctrl.common.util.list.exception.OutOfCapacityException;
import com.kingdee.bos.ctrl.print.control.PaperInfo;
import com.kingdee.bos.ctrl.print.printjob.AbstractPrintJob;
import com.kingdee.bos.ctrl.print.ui.component.Page;
import com.kingdee.bos.ctrl.print.ui.component.Paper;
import com.kingdee.bos.ctrl.print.util.PrintPageFileBuffer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BufferPrintJob
extends AbstractPrintJob {
    protected boolean isBuffered = false;
    private PrintPageFileBuffer printFileBuffer;
    private int memoryBufferCount = 50;
    private Map pagesHeightBuffer;
    private static final Log log = LogFactory.getLog(BufferPrintJob.class);

    public BufferPrintJob() {
    }

    public BufferPrintJob(String id) {
        super(id);
    }

    @Override
    public Paper getPaper(int index) {
        return this.createPaper(index);
    }

    @Override
    public Page getPage(int index) {
        Page page = super.getPage(index);
        if (page == null) {
            if (this.isBuffered) {
                page = this.getPageFromBuffer(index);
            } else {
                page = this.getPageFromProvider(index);
                if (page != null) {
                    this.bufferPageHeight(index, page);
                }
            }
            if (page != null) {
                page.setPainterInfo(this.getPrintPainterInfo());
            }
        }
        if (page != null) {
            page.setIndex(index);
        }
        return page;
    }

    public Page getBoundsPage(int index) {
        if (!this.isBuffered) {
            return null;
        }
        if (this.pagesHeightBuffer == null) {
            return null;
        }
        if (index >= this.pagesHeightBuffer.size()) {
            return null;
        }
        Float height = (Float)this.pagesHeightBuffer.get(index);
        Page page = new Page();
        page.setPainterSize(1.0f, height.floatValue());
        return page;
    }

    private Page getPageFromBuffer(int index) {
        PrintPageFileBuffer fileBuffer = this.getFileBuffer();
        if (fileBuffer == null || index >= this.getPageCount()) {
            return null;
        }
        return (Page)fileBuffer.get(index);
    }

    @Override
    public int getPageCount() {
        return this.pageCount;
    }

    private Page getPageFromProvider(int index) {
        Page page = null;
        PaperInfo paperInfo = this.getPaperInfo();
        page = this.getPageProvider().get(index, paperInfo);
        if (page != null) {
            paperInfo.addLastPageHeight((float)page.getPainterSize().getHeight(), false);
        }
        if (paperInfo.isUseFrugalPaintable() && page != null) {
            Page nextPage = this.getPageProvider().get(index + 1, paperInfo);
            paperInfo.addLastPageHeight(-paperInfo.getBlockSpace(), nextPage == null);
        }
        return page;
    }

    @Override
    public void bufferPrint() {
        if (this.isBuffered) {
            return;
        }
        PrintPageFileBuffer fileBuffer = this.getFileBuffer();
        int i = 0;
        Page page = null;
        if (this.pagesHeightBuffer != null) {
            this.pagesHeightBuffer.clear();
        }
        while ((page = this.getPageFromProvider(i)) != null) {
            if (this.printer.isStopPagination()) {
                this.pageCount = -1;
                return;
            }
            try {
                fileBuffer.add(i, page);
                this.bufferPageHeight(i, page);
                ++i;
            }
            catch (OutOfCapacityException e1) {
                log.error((Throwable)e1);
                this.printer.prompt("Disk no space");
                this.isBuffered = true;
                return;
            }
        }
        this.pageCount = i;
        this.isBuffered = true;
    }

    private void bufferPageHeight(int i, Page page) {
        if (this.pagesHeightBuffer == null) {
            this.pagesHeightBuffer = new HashMap();
        }
        if (page == null) {
            return;
        }
        this.pagesHeightBuffer.put(i, new Float(page.getPainterSize().getHeight()));
    }

    private PrintPageFileBuffer getFileBuffer() {
        if (this.printFileBuffer == null) {
            try {
                this.printFileBuffer = new PrintPageFileBuffer(this.memoryBufferCount);
            }
            catch (IOException e) {
                this.printer.prompt("Create buffer temp file fail.");
            }
        }
        return this.printFileBuffer;
    }

    public boolean isBuffered() {
        return this.isBuffered;
    }

    public void clearBuffer() {
        this.isBuffered = false;
        if (this.printFileBuffer != null) {
            this.printFileBuffer.clear();
        }
    }

    @Override
    public void rePagination() {
        super.rePagination();
        this.isBuffered = false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public void clear() {
        super.clear();
        this.clearBuffer();
        if (this.pagesHeightBuffer != null) {
            this.pagesHeightBuffer.clear();
        }
    }

    public int getMemoryBufferCount() {
        return this.memoryBufferCount;
    }

    public void setMemoryBufferCount(int memoryBufferCount) {
        this.memoryBufferCount = memoryBufferCount;
    }

    public PrintPageFileBuffer getPrintFileBuffer() {
        return this.printFileBuffer;
    }

    public void setPrintFileBuffer(PrintPageFileBuffer printFileBuffer) {
        this.printFileBuffer = printFileBuffer;
    }
}

