/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.printjob;

import com.kingdee.bos.ctrl.print.printjob.IDividePolicy;
import com.kingdee.bos.ctrl.print.ui.component.Canvas;
import com.kingdee.bos.ctrl.print.ui.component.IPainter;
import com.kingdee.bos.ctrl.print.ui.component.Page;
import com.kingdee.bos.ctrl.print.ui.io.Painter2Xml;
import com.kingdee.bos.ctrl.print.ui.io.Xml2Painter;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class DefaultDividePolicy
implements IDividePolicy {
    public static final int DIVIDE_FORCE = 0;
    public static final int DIVIDE_KEEPWHOLE = 2;
    public static final int LANDSCAPE = 0;
    public static final int PORTRAIT = 1;
    private int type = 0;
    private int orientation = 0;
    private Painter2Xml painter2Xml = new Painter2Xml();
    private Xml2Painter xml2Painter = new Xml2Painter(null);

    @Override
    public void setPolicyType(int type) {
        this.type = type;
    }

    public int getPolicyType() {
        return this.type;
    }

    @Override
    public List dividePage(Rectangle2D.Float rectBounds, Canvas page) {
        List<Canvas> resulPages = null;
        Rectangle2D.Float pageBounds = page.getPainterBounds();
        if (this.isRectangleContainingRectangle(rectBounds, pageBounds)) {
            resulPages = new ArrayList<Canvas>();
            resulPages.add(page);
        } else {
            resulPages = this.divideByOriention(rectBounds, page, this.orientation);
        }
        return resulPages;
    }

    private boolean isRectangleContainingRectangle(Rectangle2D.Float a, Rectangle2D.Float b) {
        return (double)a.width + 3.5 >= (double)b.width && (double)a.height + 3.5 >= (double)b.height;
    }

    private List divideByOriention(Rectangle2D.Float rectBounds, Canvas page, int orien) {
        ArrayList<Page> resultPageList = new ArrayList<Page>();
        float width = rectBounds.width;
        float height = rectBounds.height;
        Rectangle2D.Float pageBounds = page.getPainterBounds();
        float srcWidth = pageBounds.width;
        float srcHeight = pageBounds.height;
        float x = 0.0f;
        float y = 0.0f;
        float theWidth = width;
        float theHeight = height;
        if (this.type == 2) {
            float resultWidth = this.getKeepWholePosition(page, 0.0f, width, true);
            theWidth = resultWidth == -1.0f ? width : resultWidth;
            theHeight = this.getKeepWholePosition(page, 0.0f, height, false);
        }
        Rectangle2D.Float clipRect = new Rectangle2D.Float(x, y, theWidth, height);
        do {
            if (orien == 0) {
                x = 0.0f;
                clipRect.width = theWidth;
            } else {
                y = 0.0f;
                clipRect.height = theHeight;
            }
            do {
                clipRect.x = x;
                clipRect.y = y;
                Page newpage = this.divideByRect(clipRect, page);
                if (newpage != null) {
                    resultPageList.add(newpage);
                }
                if (orien == 0) {
                    if (this.type == 2) {
                        float nextX = this.getKeepWholePosition(page, x, x + theWidth, true);
                        theWidth = nextX - x;
                        x = nextX;
                        continue;
                    }
                    x += theWidth;
                    continue;
                }
                if (this.type == 2) {
                    float nextY = this.getKeepWholePosition(page, y, y + theHeight, false);
                    theHeight = nextY - y;
                    y = nextY;
                    continue;
                }
                y += theHeight;
            } while (!((double)x + 1.5 >= (double)srcWidth) && !((double)y + 1.5 >= (double)srcHeight));
            if (orien == 0) {
                if (this.type == 2) {
                    float nextY = this.getKeepWholePosition(page, y, y + theHeight, false);
                    theHeight = nextY - y;
                    y = nextY;
                    continue;
                }
                y += theHeight;
                continue;
            }
            if (this.type == 2) {
                float nextX = this.getKeepWholePosition(page, 0.0f, x + theWidth, true);
                theWidth = nextX - x;
                x = nextX;
                continue;
            }
            x += theWidth;
        } while (!(orien == 0 && (double)y + 1.5 >= (double)srcHeight) && (orien != 1 || !((double)x + 1.5 >= (double)srcWidth)));
        return resultPageList;
    }

    protected float getKeepWholePosition(Canvas page, float startX, float toX, boolean orien) {
        float resultX = toX;
        List childList = page.getAllPainter();
        int size = childList.size();
        boolean isFind = true;
        block0: do {
            isFind = true;
            for (int i = 0; i < size; ++i) {
                IPainter one = (IPainter)childList.get(i);
                Rectangle2D.Float oneRect = one.getPainterBounds();
                float rX = 0.0f;
                float width = 0.0f;
                if (orien) {
                    rX = (float)((RectangularShape)oneRect).getX();
                    width = (float)((RectangularShape)oneRect).getWidth();
                } else {
                    rX = (float)((RectangularShape)oneRect).getY();
                    width = (float)((RectangularShape)oneRect).getHeight();
                }
                if (!(resultX > rX) || !(resultX < rX + width - 1.0f)) continue;
                isFind = false;
                if (one instanceof Canvas) {
                    float newStartX = startX - rX;
                    float myX = this.getKeepWholePosition((Canvas)one, newStartX, resultX - rX, orien);
                    if (myX == -1.0f) {
                        return -1.0f;
                    }
                    if (rX + myX < resultX) {
                        resultX = rX + myX;
                        continue block0;
                    }
                    isFind = true;
                    continue;
                }
                if (rX == 0.0f && startX == 0.0f) {
                    return -1.0f;
                }
                resultX = rX;
                continue block0;
            }
        } while (!isFind);
        return resultX;
    }

    private Page divideByRect(Rectangle2D.Float rect, Canvas srcPage) {
        Page page = new Page();
        Rectangle2D.Float srcBounds = srcPage.getPainterBounds();
        if (rect.width > srcBounds.width) {
            rect.width = srcBounds.width;
        }
        if (rect.height > srcBounds.height) {
            rect.height = srcBounds.height;
        }
        if (rect.x + rect.width > srcBounds.x + srcBounds.width) {
            rect.width = srcBounds.width - rect.x;
        }
        if (rect.y + rect.height > srcBounds.y + srcBounds.height) {
            rect.height = srcBounds.height - rect.y;
        }
        page.setPainterBounds(0.0f, 0.0f, rect.width, rect.height);
        page.setStyle(srcPage.getStyle());
        this.divideCanvas(page, new Point2D.Float(0.0f, 0.0f), rect, srcPage);
        if (this.isEmpty(page)) {
            page = null;
        }
        return page;
    }

    private boolean isEmpty(Page page) {
        return page.getAllPainter().size() == 0;
    }

    private void divideCanvas(Canvas page, Point2D.Float offset, Rectangle2D.Float rect, IPainter srcPage) {
        List childList = srcPage.getAllPainter();
        int size = childList.size();
        for (int i = 0; i < size; ++i) {
            IPainter one = (IPainter)childList.get(i);
            Rectangle2D.Float oneRect = one.getPainterBounds();
            Rectangle2D.Float oneRect2 = one.getPainterBounds();
            if (!rect.intersects(oneRect)) continue;
            DefaultDividePolicy.computeIntersection(rect.x, rect.y, rect.width, rect.height, oneRect2);
            oneRect2.x -= oneRect.x;
            oneRect2.y -= oneRect.y;
            IPainter newPainter = one;
            if (one instanceof Canvas) {
                newPainter = this.divideCanvas4(oneRect2, (Canvas)one);
            }
            newPainter.setPainterBounds(oneRect);
            newPainter.setStyle(one.getStyle());
            newPainter.setDecorate(one.getDecorate());
            newPainter.setPainterLocation(oneRect.x - rect.x, oneRect.y - rect.y);
            page.addPainter(newPainter);
        }
    }

    private IPainter divideCanvas4(Rectangle2D.Float rect, Canvas canvas) {
        Canvas newCanvas = new Canvas();
        newCanvas.setPainterBounds(canvas.getPainterBounds());
        newCanvas.setStyle(canvas.getStyle());
        newCanvas.setLayer(canvas.getLayer());
        newCanvas.setDecorate(canvas.getDecorate());
        List childList = canvas.getAllPainter();
        int size = childList.size();
        for (int i = 0; i < size; ++i) {
            IPainter one = (IPainter)childList.get(i);
            Rectangle2D.Float oneRect = one.getPainterBounds();
            if (!rect.intersects(oneRect)) continue;
            if (one instanceof Canvas) {
                Rectangle2D.Float oneRect2 = one.getPainterBounds();
                DefaultDividePolicy.computeIntersection(rect.x, rect.y, rect.width, rect.height, oneRect2);
                oneRect2.x -= oneRect.x;
                oneRect2.y -= oneRect.y;
                IPainter newPainter = this.divideCanvas4(oneRect2, (Canvas)one);
                newCanvas.addPainter(newPainter);
                continue;
            }
            Element e = this.painter2Xml.makePainter(one);
            IPainter painter = this.xml2Painter.parsePainter(e);
            painter.setStyle(one.getStyle());
            newCanvas.addPainter(painter);
        }
        return newCanvas;
    }

    public static Rectangle2D.Float computeIntersection(float x, float y, float width, float height, Rectangle2D.Float dest) {
        float x1 = x > dest.x ? x : dest.x;
        float x2 = x + width < dest.x + dest.width ? x + width : dest.x + dest.width;
        float y1 = y > dest.y ? y : dest.y;
        float y2 = y + height < dest.y + dest.height ? y + height : dest.y + dest.height;
        dest.x = x1;
        dest.y = y1;
        dest.width = x2 - x1;
        dest.height = y2 - y1;
        if (dest.width < 0.0f || dest.height < 0.0f) {
            dest.height = 0.0f;
            dest.width = 0.0f;
            dest.y = 0.0f;
            dest.x = 0.0f;
        }
        return dest;
    }
}

