/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.ui.component;

import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.config.IXmlTranslate;
import com.kingdee.bos.ctrl.print.config.IXmlTranslate2;
import com.kingdee.bos.ctrl.print.ui.component.PainterCell;
import com.kingdee.bos.ctrl.print.ui.io.Painter2Xml;
import com.kingdee.bos.ctrl.print.ui.io.Xml2Painter;
import com.kingdee.bos.ctrl.print.ui.view.BarcodeCellView;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;

public class BarCodeCell
extends PainterCell {
    private Map config;

    public Map getConfig() {
        return this.config;
    }

    public void setConfig(Map config) {
        this.config = config;
    }

    @Override
    public void updateView() {
        this.setPainterView(BarcodeCellView.createPainterView());
    }

    @Override
    public IXmlTranslate createXmlTrans() {
        XmlTranslate xmlTranslate = new XmlTranslate();
        if (KDPrinter.getPainterXmlTranslate(xmlTranslate.getName()) == null) {
            KDPrinter.registerPainterXmlTranslate(xmlTranslate.getName(), new XmlTranslate());
        }
        xmlTranslate.setExportCell(this);
        return xmlTranslate;
    }

    private static class XmlTranslate
    implements IXmlTranslate2 {
        private Painter2Xml painter2Xml;
        private Xml2Painter xml2Painter;
        BarCodeCell exportCell = null;
        private static final String BARCODE = "barcode";
        private static final String BARCODE_TYPE = "barcodeType";
        private static final String FONT_SIZE = "fontSize";
        private static final String HEIGHT = "height";
        private static final String WIDTH = "width";
        private static final String DPI = "dpi";
        private static final String MODEL_WIDTH = "modelWidth";
        private static final String BAR_HEIGHT = "barHeight";
        private static final String SHAPE = "shape";
        private static final String AUTO_MATCH = "autoMatch";
        private static final String SHOW_TEXT = "showText";
        private static final String BARCODE_HEIGHT = "barcodeHeight";
        private static final String BARCODE_WIDTH = "barcodeWidth";

        private XmlTranslate() {
        }

        public BarCodeCell getExportCell() {
            return this.exportCell;
        }

        public void setExportCell(BarCodeCell exportCell) {
            this.exportCell = exportCell;
        }

        @Override
        public Element toXmlElement() {
            DefaultElement xml = new DefaultElement("BarCodeCell");
            this.painter2Xml.makeCommon(this.exportCell, (Element)xml);
            Map config = this.exportCell.getConfig();
            if (config == null) {
                return xml;
            }
            String barcode = (String)config.get(BARCODE);
            String barcodeType = (String)config.get(BARCODE_TYPE);
            Integer fontSize = (Integer)config.get(FONT_SIZE);
            Double height = (Double)config.get(HEIGHT);
            Double width = (Double)config.get(WIDTH);
            Integer dpi = (Integer)config.get(DPI);
            Double modelWidth = (Double)config.get(MODEL_WIDTH);
            Double barHeight = (Double)config.get(BAR_HEIGHT);
            String shape = (String)config.get(SHAPE);
            Boolean autoMatch = (Boolean)config.get(AUTO_MATCH);
            Boolean showText = (Boolean)config.get(SHOW_TEXT);
            xml.addAttribute(BARCODE, this.convertToString(barcode));
            xml.addAttribute(BARCODE_TYPE, this.convertToString(barcodeType));
            xml.addAttribute(FONT_SIZE, this.convertToString(fontSize));
            xml.addAttribute(BARCODE_HEIGHT, this.convertToString(height));
            xml.addAttribute(BARCODE_WIDTH, this.convertToString(width));
            xml.addAttribute(DPI, this.convertToString(dpi));
            xml.addAttribute(MODEL_WIDTH, this.convertToString(modelWidth));
            xml.addAttribute(BAR_HEIGHT, this.convertToString(barHeight));
            xml.addAttribute(SHAPE, this.convertToString(shape));
            xml.addAttribute(AUTO_MATCH, this.convertToString(autoMatch));
            xml.addAttribute(SHOW_TEXT, this.convertToString(showText));
            return xml;
        }

        private String convertToString(Object obj) {
            if (obj == null) {
                return "";
            }
            return obj.toString();
        }

        @Override
        public Object fromXmlElement(Element xml) {
            BarCodeCell barcodeCell = new BarCodeCell();
            this.xml2Painter.parseCommon(barcodeCell, xml);
            String barcode = xml.attributeValue(BARCODE);
            String barcodeType = xml.attributeValue(BARCODE_TYPE);
            String fontSize = xml.attributeValue(FONT_SIZE);
            String height = xml.attributeValue(BARCODE_HEIGHT);
            String width = xml.attributeValue(BARCODE_WIDTH);
            String dpi = xml.attributeValue(DPI);
            String modelWidth = xml.attributeValue(MODEL_WIDTH);
            String barHeight = xml.attributeValue(BAR_HEIGHT);
            String shape = xml.attributeValue(SHAPE);
            String autoMatch = xml.attributeValue(AUTO_MATCH);
            String showText = xml.attributeValue(SHOW_TEXT);
            HashMap<String, Object> config = new HashMap<String, Object>();
            if (!this.isNullOrEmpty(barcode)) {
                config.put(BARCODE, barcode);
            }
            if (!this.isNullOrEmpty(barcodeType)) {
                config.put(BARCODE_TYPE, barcodeType);
            }
            if (!this.isNullOrEmpty(fontSize)) {
                config.put(FONT_SIZE, Integer.parseInt(fontSize));
            }
            if (!this.isNullOrEmpty(height)) {
                config.put(HEIGHT, Double.parseDouble(height));
            }
            if (!this.isNullOrEmpty(width)) {
                config.put(WIDTH, Double.parseDouble(width));
            }
            if (!this.isNullOrEmpty(dpi)) {
                config.put(DPI, Integer.parseInt(dpi));
            }
            if (!this.isNullOrEmpty(modelWidth)) {
                config.put(MODEL_WIDTH, Double.parseDouble(modelWidth));
            }
            if (!this.isNullOrEmpty(barHeight)) {
                config.put(BAR_HEIGHT, Double.parseDouble(barHeight));
            }
            if (!this.isNullOrEmpty(shape)) {
                config.put(SHAPE, shape);
            }
            if (!this.isNullOrEmpty(autoMatch)) {
                config.put(AUTO_MATCH, Boolean.parseBoolean(autoMatch));
            }
            if (!this.isNullOrEmpty(showText)) {
                config.put(SHOW_TEXT, Boolean.parseBoolean(showText));
            }
            barcodeCell.setConfig(config);
            return barcodeCell;
        }

        private boolean isNullOrEmpty(String str) {
            return str == null || str.isEmpty();
        }

        @Override
        public String getName() {
            return "BarCodeCell";
        }

        @Override
        public void setPainter2Xml(Painter2Xml handle) {
            this.painter2Xml = handle;
        }

        @Override
        public void setXml2Painter(Xml2Painter handle) {
            this.xml2Painter = handle;
        }
    }
}

