/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.ui.component;

import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.print.control.CtrlGraphics;
import com.kingdee.bos.ctrl.print.ui.IPaintFilter;
import com.kingdee.bos.ctrl.print.ui.component.DimensionFloat;
import com.kingdee.bos.ctrl.print.ui.component.IDecorate;
import com.kingdee.bos.ctrl.print.ui.component.IPainter;
import com.kingdee.bos.ctrl.print.ui.component.IRender;
import com.kingdee.bos.ctrl.print.ui.component.PainterInfo;
import com.kingdee.bos.ctrl.print.ui.view.BasicPainterView;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public abstract class BasicPainter
implements IPainter {
    public static final int DEFAULT_EXTEND = 1;
    protected int layer = 50;
    protected Style style;
    protected IDecorate decorate;
    protected IRender render;
    protected BasicPainterView painterView;
    protected Map<Integer, Object> childrenMap;
    protected float x;
    protected float y;
    protected float width;
    protected float height;
    private float extend = 1.0f;
    protected String painterKey;
    protected Color backGround;
    protected PainterInfo painterInfo;
    protected IPainter parent;
    protected boolean editable = true;
    protected Object userObject;
    private static final Log log = LogFactory.getLog(BasicPainter.class);
    Dimension2D papinterSize = null;
    protected boolean blackWhite = false;

    @Override
    public int getLayer() {
        return this.layer;
    }

    @Override
    public void setLayer(int layer) {
        this.layer = layer;
    }

    @Override
    public void setRender(IRender render) {
        this.render = render;
    }

    @Override
    public IRender getRender() {
        return this.render;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void painting(Graphics g, PainterInfo info) {
        if (this.width <= 0.0f || this.height <= 0.0f) {
            return;
        }
        Graphics realGra = null;
        try {
            Rectangle2D.Float clip = new Rectangle2D.Float(0.0f, 0.0f, this.width, this.height);
            realGra = this.createGraphicsByRect(g, clip, this.extend);
            this.paintSelf(realGra, info);
            this.paintChildren(realGra, info);
            this.paintDecorate(realGra, info);
        }
        catch (Exception ex) {
            log.info("\u6253\u5370-\u7ed8\u5236\u51fa\u73b0\u5f02\u5e38\uff1a", (Object)ex.getCause());
        }
        finally {
            if (realGra != null) {
                realGra.dispose();
            }
        }
    }

    protected void paintSelf(Graphics g, PainterInfo info) {
        if (this.getPainterView() == null) {
            return;
        }
        this.getPainterView().update(g, this, info);
    }

    protected void paintDecorate(Graphics g, PainterInfo info) {
        if (this.getDecorate() == null) {
            return;
        }
        this.getDecorate().painting(g, this);
    }

    protected void paintChildren(Graphics g, PainterInfo info) {
        if (this.childrenMap == null) {
            return;
        }
        for (Map.Entry<Integer, Object> entry : this.childrenMap.entrySet()) {
            Integer key = entry.getKey();
            IPaintFilter filter = info.getPaintFilter();
            if (filter != null && filter.isApply() && !filter.accept(key, info.isPreviewing())) continue;
            List children = (List)entry.getValue();
            int len = children.size();
            for (int i = 0; i < len; ++i) {
                IPainter child = (IPainter)children.get(i);
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.translate(child.getX(), child.getY());
                this.paintChild(g2d, child, info);
                g2d.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintChild(Graphics g, IPainter child, PainterInfo info) {
        try {
            child.painting(g, info);
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
        }
        finally {
            if (g != null) {
                g.dispose();
            }
        }
    }

    protected Graphics createGraphicsByRect(Graphics g, Rectangle2D.Float rect, float extend) {
        float childX = rect.x;
        float childY = rect.y;
        float childW = rect.width;
        float childH = rect.height;
        Graphics realGra = CtrlGraphics.createGraphics(g, childX, childY, childW, childH, extend);
        return realGra;
    }

    @Override
    public void setPainterView(BasicPainterView view) {
        if (this.painterView != null) {
            this.painterView.unInstallView(this);
        }
        this.painterView = view;
        if (this.painterView != null) {
            this.painterView.installView(this);
        }
    }

    @Override
    public BasicPainterView getPainterView() {
        return this.painterView;
    }

    @Override
    public Style getStyle() {
        return this.style;
    }

    @Override
    public void removePainter(IPainter painter) {
    }

    @Override
    public void addPainter(IPainter painter) {
    }

    @Override
    public void addPainter(IPainter painter, int layer) {
    }

    @Override
    public List getAllPainter() {
        return null;
    }

    @Override
    public void setStyle(Style newValue) {
        this.style = newValue;
    }

    @Override
    public IDecorate getDecorate() {
        return this.decorate;
    }

    @Override
    public void setDecorate(IDecorate newValue) {
        this.decorate = newValue;
    }

    @Override
    public void setPainterLocation(float x, float y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public Point2D.Float getPainterLocation() {
        return new Point2D.Float(this.x, this.y);
    }

    @Override
    public void setPainterSize(float width, float height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public Dimension2D getPainterSize() {
        if (this.papinterSize == null) {
            this.papinterSize = new DimensionFloat(this.width, this.height);
        }
        this.papinterSize.setSize(this.width, this.height);
        return this.papinterSize;
    }

    @Override
    public Rectangle2D.Float getPainterBounds() {
        return new Rectangle2D.Float(this.x, this.y, this.width, this.height);
    }

    @Override
    public void setPainterBounds(float x, float y, float width, float height) {
        this.setPainterLocation(x, y);
        this.setPainterSize(width, height);
    }

    @Override
    public void setPainterBounds(Rectangle2D.Float rect) {
        if (rect != null) {
            this.setPainterLocation(rect.x, rect.y);
            this.setPainterSize(rect.width, rect.height);
        }
    }

    @Override
    public void setPainterKey(String key) {
        this.painterKey = key;
    }

    @Override
    public String getPainterKey() {
        return this.painterKey;
    }

    @Override
    public void setBackGround(Color color) {
        this.backGround = color;
    }

    @Override
    public Color getBackGround() {
        return this.backGround;
    }

    @Override
    public float getPainterExtend() {
        return this.extend;
    }

    @Override
    public void setPainterExtend(float extend) {
        this.extend = extend;
    }

    @Override
    public PainterInfo getPainterInfo() {
        return this.painterInfo;
    }

    @Override
    public void setPainterInfo(PainterInfo printPainterInfo) {
        this.painterInfo = printPainterInfo;
    }

    @Override
    public IPainter getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IPainter parent) {
        this.parent = parent;
    }

    public abstract void updateView();

    @Override
    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    @Override
    public void setUserObject(Object o) {
        this.userObject = o;
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setBlackWhite(boolean isBlackwhite) {
        this.blackWhite = isBlackwhite;
    }

    @Override
    public boolean isBlackWhite() {
        return this.blackWhite;
    }
}

