/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.ui.component;

import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootRow;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.DefaultVariantParser;
import com.kingdee.bos.ctrl.print.ui.component.PainterInfo;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.ListIterator;

public class HeadFootCell {
    String text;
    Style style;
    Dimension size;

    public HeadFootCell() {
    }

    public HeadFootCell(String text, Style style) {
        this.text = text;
        this.style = style;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Dimension getSize(Graphics g, PainterInfo info) {
        Graphics2D g2d = (Graphics2D)g;
        Font oldFont = g2d.getFont();
        Font font = this.style.getFont();
        g2d.setFont(font);
        int fontWidth = 0;
        int fontHeight = 0;
        ArrayList strList = KDPrinterUtils.parseVariantText(this.text);
        int count = strList.size();
        for (int i = 0; i < count; ++i) {
            String str = (String)strList.get(i);
            if (str == null) continue;
            int len = str.length();
            String mark = str;
            if (len > 2 && str.charAt(0) == '&' && str.charAt(1) == '[') {
                mark = DefaultVariantParser.getVariantMark(str.substring(2));
                if (mark == null && info != null) {
                    mark = KDPrinterUtils.parseVariant(info, str.substring(2));
                }
                if (mark == null) {
                    mark = str.substring(2);
                }
            }
            Rectangle2D fontRect = font.getStringBounds(mark, g2d.getFontRenderContext());
            int strwidth = (int)fontRect.getWidth();
            fontHeight = (int)fontRect.getHeight();
            fontWidth += strwidth;
            int strHeight = g2d.getFontMetrics().getHeight();
            if (strHeight <= fontHeight) continue;
            fontHeight = strHeight;
        }
        this.size = new Dimension(fontWidth + 1, fontHeight);
        g2d.setFont(oldFont);
        return this.size;
    }

    public static HeadFootCell[][] parseModel(HeadFootModel model) {
        if (model != null) {
            int count = model.getRowsCount();
            if (count == 0) {
                return null;
            }
            HeadFootCell[][] cellss = new HeadFootCell[count][];
            ListIterator mo = model.getRows();
            int i = 0;
            while (mo.hasNext()) {
                Object item = mo.next();
                if (!(item instanceof HeadFootRow)) continue;
                HeadFootRow aRow = (HeadFootRow)item;
                cellss[i++] = HeadFootCell.parseCell(aRow);
            }
            return cellss;
        }
        return null;
    }

    public static HeadFootCell[] parseCell(HeadFootRow row) {
        String[] segments = row.getText().split("&\\|");
        Style thestyle = Styles.getStyle(row.getSA() == null ? Styles.getDefaultSA() : row.getSA());
        HeadFootCell[] cells = new HeadFootCell[segments.length];
        int count = cells.length;
        for (int i = 0; i < count; ++i) {
            cells[i] = new HeadFootCell();
            cells[i].setText(segments[i]);
            cells[i].setStyle(thestyle);
        }
        return cells;
    }
}

