/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.ui.component;

import com.kingdee.bos.ctrl.print.control.ControlPrint;
import com.kingdee.bos.ctrl.print.ui.component.Canvas;
import com.kingdee.bos.ctrl.print.ui.component.PainterInfo;
import com.kingdee.bos.ctrl.print.ui.component.Paper;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class MultiPaper
extends Canvas {
    boolean isEmpty = false;
    Paper[] papers;
    float scale = 1.0f;

    private MultiPaper() {
    }

    public MultiPaper(int scaleType, int pageIndex, ControlPrint controlPrint) {
        int[] indexs = this.getThePaperIndexs(scaleType, pageIndex);
        this.papers = this.getPapers(indexs, controlPrint);
        if (this.papers[0] == null) {
            this.isEmpty = true;
            return;
        }
        int rowCount = 1;
        if (scaleType == 2) {
            rowCount = 1;
        } else if (scaleType == 4 || scaleType == 6 || scaleType == 8) {
            rowCount = 2;
        } else if (scaleType == 16) {
            rowCount = 4;
        }
        this.init(this.papers, rowCount);
    }

    private void init(Paper[] papers, int rowCount) {
        Paper firstPaper = papers[0];
        Rectangle2D.Float rect = firstPaper.getPainterBounds();
        float width = rect.width;
        float height = rect.height;
        this.setPainterBounds(rect);
        int colCount = papers.length / rowCount;
        float scaleWidth = width / (float)colCount / width;
        float scaleHeight = height / (float)rowCount / height;
        this.scale = scaleWidth < scaleHeight ? scaleWidth : scaleHeight;
        float perWidth = width * this.scale;
        float perHeight = height * this.scale;
        float x = 0.0f;
        float y = 0.0f;
        int index = 0;
        for (int i = 0; i < rowCount; ++i) {
            Paper paper;
            x = 0.0f;
            for (int j = 0; j < colCount && (paper = papers[index]) != null; ++j) {
                paper.setPainterBounds(x, y, perWidth, perHeight);
                x += perWidth;
                ++index;
            }
            y += perHeight;
        }
    }

    private Paper[] getPapers(int[] indexs, ControlPrint controlPrint) {
        Paper[] thepapers = new Paper[indexs.length];
        for (int i = 0; i < indexs.length; ++i) {
            thepapers[i] = controlPrint.getPaper(indexs[i]);
        }
        return thepapers;
    }

    public Paper[] getPapers() {
        return this.papers;
    }

    @Override
    public void painting(Graphics g, PainterInfo info) {
        if (this.papers == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        for (int i = 0; i < this.papers.length; ++i) {
            Paper paper = this.papers[i];
            if (paper == null) continue;
            Point2D.Float location = paper.getPainterLocation();
            g2d.translate(location.x, location.y);
            g2d.scale(this.scale, this.scale);
            paper.painting(g2d, info);
            g2d.scale(1.0f / this.scale, 1.0f / this.scale);
            g2d.translate(-location.x, -location.y);
        }
    }

    private int[] getThePaperIndexs(int scaleType, int pageIndex) {
        int[] indexs = new int[scaleType];
        int index = -1;
        for (int i = 0; i <= pageIndex; ++i) {
            for (int j = 0; j < indexs.length; ++j) {
                ++index;
                if (i != pageIndex) continue;
                indexs[j] = index;
            }
        }
        return indexs;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }
}

