/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.ui.io;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.render.splitrectangle.AbstractTableSplitRectInfo;
import com.kingdee.bos.ctrl.kdf.util.render.splitrectangle.TableSplitRectInfoXml;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.config.IXmlTranslate;
import com.kingdee.bos.ctrl.print.config.IXmlTranslate2;
import com.kingdee.bos.ctrl.print.ui.component.Canvas;
import com.kingdee.bos.ctrl.print.ui.component.IDecorate;
import com.kingdee.bos.ctrl.print.ui.component.IPainter;
import com.kingdee.bos.ctrl.print.ui.component.ImageCell;
import com.kingdee.bos.ctrl.print.ui.component.LabelCell;
import com.kingdee.bos.ctrl.print.ui.component.LineBorder;
import com.kingdee.bos.ctrl.print.ui.component.LineCell;
import com.kingdee.bos.ctrl.print.ui.component.Page;
import com.kingdee.bos.ctrl.print.ui.component.Paper;
import com.kingdee.bos.ctrl.print.ui.component.StyleCell;
import com.kingdee.bos.ctrl.print.ui.component.TableCell;
import com.kingdee.bos.ctrl.print.ui.component.VariantLabelCell;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.dom4j.Element;
import org.dom4j.tree.DefaultCDATA;
import org.dom4j.tree.DefaultElement;

public class Painter2Xml {
    public static final String T_PAPER = "Paper";
    public static final String T_TABLE = "Table";
    public static final String T_CELL = "cell";
    public static final String T_MERGEBLOCK = "mergeblock";
    public static final String T_HEADER = "Header";
    public static final String T_FOOTER = "Footer";
    public static final String T_PAGE = "Page";
    public static final String T_CANVAS = "Canvas";
    public static final String T_LABEL = "Label";
    public static final String T_VARIANT_LABEL = "VariantLabel";
    public static final String T_StyleCell = "StyleCell";
    public static final String T_LINE = "Line";
    public static final String T_POINT = "Point";
    public static final String T_IMAGE = "ImageCell";
    public static final String T_STYLES = "Styles";
    public static final String T_STYLE = "Style";
    public static final String A_STYLES = "styles";
    public static final String A_STYLE = "style";
    public static final String A_X = "x";
    public static final String A_Y = "y";
    public static final String A_WIDTH = "width";
    public static final String A_HEIGHT = "height";
    public static final String A_LAYER = "layer";
    public static final String A_ALIGN = "horiAlign";
    public static final String A_ID = "id";
    public static final String A_BACKGROUND = "background";
    public static final String A_FORCEGROUND = "color";
    public static final String A_BLACKWHITE = "isBlackWhite";
    public static final String A_BORDERSPACE = "borderspace";
    public static final String A_BORDERMODE = "bordermode";
    public static final String A_AROUNDSTYLE = "aroundstyle";
    public static final String A_DECORATE = "decorate";
    public static final String A_EXTEND = "extend";
    public static final String A_SCALE = "scale";
    public static final String A_X1 = "x1";
    public static final String A_Y1 = "y1";
    public static final String A_X2 = "x2";
    public static final String A_Y2 = "y2";
    public static final String A_GRID = "grid";
    public static final String A_ROWS = "rows";
    public static final String A_COLUMNS = "columns";
    public static final String A_ROW = "row";
    public static final String A_COLUMN = "column";
    static final String DH_COL = "Col";
    static final String DH_ROW2 = "Row2";
    static final String DH_COL2 = "Col2";
    static final String ROWOFFERS = "RowOffers";
    static final String COLOFFERS = "ColOffers";
    static final String XOFFERS = "xOffers";
    static final String YOFFERS = "yOffers";
    static final String TRIANGLE = "Triangle";
    static final String LEAN = "Lean";
    static final String ZOOM = "Zoom";
    static final String DRAWBACK = "DrawBack";
    static final String POSITION = "Position";
    static final String LINESTYLE = "LineStyle";
    static final String WEIGHT = "Weight";
    static final String ROW = "Row";
    static final String STYLEID = "StyleID";
    static final String INDEX = "Index";
    static final String DATA_STRING = "String";
    static final String TRUEVALUE = "True";
    static final String FALSEVALUE = "False";
    private String workDir;
    private static final Log log = LogFactory.getLog(Painter2Xml.class);
    private Map styles;
    private StringBuilder pageStyleIds = new StringBuilder();
    private Map<String, String> imageKeyMap = new HashMap<String, String>(4);
    private boolean reInFlag = false;

    public Painter2Xml() {
        this(new HashMap());
    }

    public Painter2Xml(Map styles) {
        this.styles = styles;
        this.workDir = File.separator + "temp" + File.separator + Thread.currentThread().getId();
    }

    public Element makePainter(IPainter pnt) {
        Class<?> cls = pnt.getClass();
        if (Canvas.class.equals(cls)) {
            return this.makeCanvas((Canvas)pnt);
        }
        if (LabelCell.class.equals(cls)) {
            return this.makeLabel((LabelCell)pnt);
        }
        if (VariantLabelCell.class.equals(cls)) {
            return this.makeVariantLabel((VariantLabelCell)pnt);
        }
        if (StyleCell.class.equals(cls)) {
            return this.makeStyleCell((StyleCell)pnt);
        }
        if (ImageCell.class.equals(cls)) {
            return this.makeImage((ImageCell)pnt);
        }
        if (LineCell.class.equals(cls)) {
            return this.makeLine((LineCell)pnt);
        }
        if (Page.class.equals(cls)) {
            return this.makePage((Page)pnt);
        }
        if (Paper.class.equals(cls)) {
            return this.makePaper((Paper)pnt);
        }
        if (TableCell.class.equals(cls)) {
            return this.makeTable((TableCell)pnt);
        }
        Element e = null;
        IXmlTranslate xmlTrans = pnt.createXmlTrans();
        if (xmlTrans instanceof IXmlTranslate2) {
            ((IXmlTranslate2)xmlTrans).setPainter2Xml(this);
            e = xmlTrans.toXmlElement();
        } else if (xmlTrans instanceof IXmlTranslate) {
            e = xmlTrans.toXmlElement();
        }
        return e;
    }

    private void makeChildren(Canvas cv, Element xml) {
        List children = cv.getAllPainter();
        int len = children.size();
        for (int i = 0; i < len; ++i) {
            Element xmlPnt = this.makePainter((IPainter)children.get(i));
            if (xmlPnt == null) continue;
            xml.add(xmlPnt);
        }
    }

    public void makeCommon(IPainter pnt, Element xml) {
        IDecorate decorate;
        Color backColor;
        float extend;
        Rectangle2D.Float rc = pnt.getPainterBounds();
        xml.addAttribute(A_X, this.Float2String(rc.x));
        xml.addAttribute(A_Y, this.Float2String(rc.y));
        xml.addAttribute(A_WIDTH, this.Float2String(rc.width));
        xml.addAttribute(A_HEIGHT, this.Float2String(rc.height));
        if (pnt.getLayer() != 50) {
            xml.addAttribute(A_LAYER, "" + pnt.getLayer());
        }
        if ((extend = pnt.getPainterExtend()) != 1.0f) {
            xml.addAttribute(A_EXTEND, this.Float2String(extend));
        }
        if ((backColor = pnt.getBackGround()) != null) {
            String colorStr = KDPrinterUtils.colorToHex(backColor);
            xml.addAttribute(A_BACKGROUND, colorStr);
        }
        Style style = pnt.getStyle();
        Style dStyle = Styles.getDefaultStyle();
        if (style != null && style != dStyle) {
            xml.addAttribute(A_STYLE, String.valueOf(style.getUID()));
            this.addStyle(style);
        }
        if ((decorate = pnt.getDecorate()) instanceof LineBorder) {
            xml.addAttribute(A_DECORATE, LineBorder.getName() + ":" + ((LineBorder)decorate).getType());
        }
    }

    private Element makeStyleCell(StyleCell cell) {
        DefaultElement xml = new DefaultElement(T_StyleCell);
        this.makeCommon(cell, (Element)xml);
        Style[] aroundStyles = cell.getAroundStyles();
        if (aroundStyles != null) {
            for (int i = 0; i < aroundStyles.length; ++i) {
                Style style = aroundStyles[i];
                if (style == null) continue;
                this.addStyle(style);
                String id = String.valueOf(style.getUID());
                xml.addAttribute(A_AROUNDSTYLE + i, id);
            }
        }
        xml.addAttribute(A_BLACKWHITE, String.valueOf(cell.isBlackWhite()));
        if (cell.getBorderSpace() != 1) {
            xml.addAttribute(A_BORDERSPACE, String.valueOf(cell.getBorderSpace()));
        }
        xml.addAttribute(A_BORDERMODE, String.valueOf(cell.getBorderMode()));
        if (cell.getDiagonalInfo() != null) {
            AbstractTableSplitRectInfo info = cell.getDiagonalInfo();
            ArrayList styles = new ArrayList();
            Element splitInfoElement = TableSplitRectInfoXml.toXml(info, styles);
            xml.add(splitInfoElement);
            int size = styles.size();
            for (int i = 0; i < size; ++i) {
                this.addStyle((Style)styles.get(i));
            }
        } else {
            xml.addElement(cell.getText());
        }
        return xml;
    }

    public Element makeLabel(LabelCell lbl) {
        DefaultElement xml = new DefaultElement(T_LABEL);
        this.makeCommon(lbl, (Element)xml);
        xml.addAttribute(A_BLACKWHITE, String.valueOf(lbl.isBlackWhite()));
        String text = lbl.getText();
        if (text == null) {
            text = "";
        }
        xml.setContent(Stream.of(new DefaultCDATA(text)).collect(Collectors.toList()));
        return xml;
    }

    public Element makeVariantLabel(VariantLabelCell lbl) {
        DefaultElement xml = new DefaultElement(T_VARIANT_LABEL);
        this.makeCommon(lbl, (Element)xml);
        String text = lbl.getText();
        if (text == null) {
            text = "";
        }
        xml.setContent(Stream.of(new DefaultCDATA(text)).collect(Collectors.toList()));
        return xml;
    }

    public Element makeLine(LineCell ln) {
        DefaultElement xml = new DefaultElement(T_LINE);
        this.makeCommon(ln, (Element)xml);
        Color color = ln.getColor();
        if (color != null) {
            xml.addAttribute(A_FORCEGROUND, KDPrinterUtils.colorToHex(color));
        }
        float x1 = ln.getX1();
        float y1 = ln.getY1();
        float x2 = ln.getX2();
        float y2 = ln.getY2();
        xml.addAttribute(A_X1, this.Float2String(x1));
        xml.addAttribute(A_Y1, this.Float2String(y1));
        xml.addAttribute(A_X2, this.Float2String(x2));
        xml.addAttribute(A_Y2, this.Float2String(y2));
        xml.remove(xml.attribute(A_X));
        xml.remove(xml.attribute(A_Y));
        xml.remove(xml.attribute(A_WIDTH));
        xml.remove(xml.attribute(A_HEIGHT));
        return xml;
    }

    public Element makeImage(ImageCell img) {
        DefaultElement xml = new DefaultElement(T_IMAGE);
        this.makeCommon(img, (Element)xml);
        Image image = img.getImage();
        String imageKey = img.getImageKey();
        if (StringUtils.isNotBlank((CharSequence)imageKey)) {
            xml.addAttribute("imageKey", imageKey);
        }
        if (image != null) {
            String imageName;
            if (StringUtils.isNotBlank((CharSequence)imageKey)) {
                xml.addAttribute("imageKey", imageKey);
                imageName = this.imageKeyMap.get(imageKey);
                if (StringUtils.isBlank((CharSequence)imageName)) {
                    imageName = "PImageBuf-" + System.currentTimeMillis();
                    this.imageKeyMap.put(imageKey, imageName);
                }
            } else {
                imageName = "PImageBuf-" + System.currentTimeMillis();
            }
            String filePath = this.workDir + "/" + imageName + ".png";
            File workFile = new File(this.workDir);
            workFile.mkdirs();
            File file = new File(filePath);
            if (!file.exists()) {
                try (FileOutputStream os = new FileOutputStream(filePath);){
                    int width = image.getWidth(null);
                    int height = image.getHeight(null);
                    ColorModel cm = ColorModel.getRGBdefault();
                    WritableRaster wr = cm.createCompatibleWritableRaster(width, height);
                    BufferedImage bufferedImage = new BufferedImage(cm, wr, cm.isAlphaPremultiplied(), null);
                    Graphics2D g = bufferedImage.createGraphics();
                    g.drawImage(image, 0, 0, null);
                    g.dispose();
                    ImageIO.write((RenderedImage)bufferedImage, "png", os);
                    os.flush();
                    xml.setText(filePath);
                }
                catch (Exception e) {
                    log.error("\u56fe\u7247\u7f13\u5b58\u78c1\u76d8\u5931\u8d25\uff1a", (Throwable)e);
                    xml.setText(null);
                }
            } else {
                xml.setText(filePath);
            }
        } else {
            xml.setText("");
        }
        xml.addAttribute(A_SCALE, String.valueOf(img.getScale()));
        return xml;
    }

    public Element makePage(Page pg) {
        boolean need_restore_reInFlag = !this.reInFlag;
        this.reInFlag = true;
        DefaultElement xml = new DefaultElement(T_PAGE);
        this.makeCommon(pg, (Element)xml);
        this.makeChildren(pg, (Element)xml);
        int z = this.pageStyleIds.length();
        if (z > 0) {
            this.pageStyleIds.setLength(z - 1);
        }
        xml.addAttribute(A_STYLES, this.pageStyleIds.toString());
        if (need_restore_reInFlag) {
            this.pageStyleIds.setLength(0);
            this.reInFlag = false;
        }
        return xml;
    }

    public Element makeCanvas(Canvas pg) {
        DefaultElement xml = new DefaultElement(T_CANVAS);
        this.makeCommon(pg, (Element)xml);
        this.makeChildren(pg, (Element)xml);
        return xml;
    }

    public Element makePaper(Paper pp) {
        DefaultElement xml = new DefaultElement(T_PAPER);
        this.makeCommon(pp, (Element)xml);
        this.makeChildren(pp, (Element)xml);
        return xml;
    }

    private Element makeTable(TableCell table) {
        DefaultElement xml = new DefaultElement(T_TABLE);
        this.makeCommon(table, (Element)xml);
        xml.addAttribute(A_GRID, "" + table.isGrid());
        String rows = StringUtil.array2String(table.getRows(), ",");
        xml.addAttribute(A_ROWS, rows);
        String cols = StringUtil.array2String(table.getColumns(), ",");
        xml.addAttribute(A_COLUMNS, cols);
        int rowCount = table.getRowCount();
        int colCount = table.getcolumnCount();
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                StyleCell painter = table.getCell(i, j);
                if (painter == null) continue;
                DefaultElement cell = new DefaultElement(T_CELL);
                cell.addAttribute(A_ROW, "" + i);
                cell.addAttribute(A_COLUMN, "" + j);
                cell.add(this.makePainter(painter));
                xml.add((Element)cell);
            }
        }
        Iterator mergs = table.getMerges().iterator();
        while (mergs.hasNext()) {
            TableCell.MergeBlock block = (TableCell.MergeBlock)mergs.next();
            DefaultElement mBlock = new DefaultElement(T_MERGEBLOCK);
            mBlock.addAttribute(A_ROW, "" + block.getRow());
            mBlock.addAttribute("col", "" + block.getCol());
            mBlock.addAttribute("row2", "" + block.getRow2());
            mBlock.addAttribute("col2", "" + block.getCol2());
            xml.add((Element)mBlock);
        }
        return xml;
    }

    private void addStyle(Style ssa) {
        String id = String.valueOf(ssa.getUID());
        this.styles.put(id, ssa);
        if (this.pageStyleIds != null) {
            this.pageStyleIds.append(id);
            this.pageStyleIds.append(",");
        }
    }

    public Map getStyles() {
        return this.styles;
    }

    private String Float2String(float value) {
        String str = Float.toString(value);
        int length = str.length();
        if (str.endsWith(".0") && length > 2) {
            str = str.substring(0, length - 2);
        }
        return str;
    }
}

