/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.ui.io;

import com.kingdee.bos.ctrl.common.util.StreamUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.render.splitrectangle.AbstractTableSplitRectInfo;
import com.kingdee.bos.ctrl.kdf.util.render.splitrectangle.TableSplitRectInfoXml;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.config.IXmlTranslate;
import com.kingdee.bos.ctrl.print.config.IXmlTranslate2;
import com.kingdee.bos.ctrl.print.ui.component.Canvas;
import com.kingdee.bos.ctrl.print.ui.component.IDecorate;
import com.kingdee.bos.ctrl.print.ui.component.IPainter;
import com.kingdee.bos.ctrl.print.ui.component.ImageCell;
import com.kingdee.bos.ctrl.print.ui.component.LabelCell;
import com.kingdee.bos.ctrl.print.ui.component.LineBorder;
import com.kingdee.bos.ctrl.print.ui.component.LineCell;
import com.kingdee.bos.ctrl.print.ui.component.Page;
import com.kingdee.bos.ctrl.print.ui.component.Paper;
import com.kingdee.bos.ctrl.print.ui.component.StyleCell;
import com.kingdee.bos.ctrl.print.ui.component.TableCell;
import com.kingdee.bos.ctrl.print.ui.component.VariantLabelCell;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import com.kingdee.bos.ctrl.reportone.r1.print.common.ImageUtil;
import java.io.File;
import java.io.FileInputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.dom4j.Element;

public class Xml2Painter {
    private Map styles;
    private Log log = LogFactory.getLog(this.getClass());

    public Xml2Painter(Map styles) {
        this.styles = styles;
    }

    public IPainter parsePainter(Element xml) {
        String tag = xml.getName();
        if ("Label".equals(tag)) {
            return this.parseLabel(xml);
        }
        if ("StyleCell".equals(tag)) {
            return this.parseStyleCell(xml);
        }
        if ("ImageCell".equals(tag)) {
            return this.parseImage(xml);
        }
        if ("Line".equals(tag)) {
            return this.parseLine(xml);
        }
        if ("Page".equals(tag)) {
            return this.parsePage(xml);
        }
        if ("Canvas".equals(tag)) {
            return this.parseCanvas(xml);
        }
        if ("Paper".equals(tag)) {
            return this.parsePaper(xml);
        }
        if ("VariantLabel".equals(tag)) {
            return this.parseVariantLabel(xml);
        }
        if ("Table".equals(tag)) {
            return this.parseTable(xml);
        }
        IPainter painter = null;
        IXmlTranslate xmlTrans = KDPrinter.getPainterXmlTranslate(xml.getName());
        if (!(xmlTrans instanceof IXmlTranslate2)) {
            throw new UnsupportedOperationException("xml:[" + xml.getName() + "]:can't load.");
        }
        ((IXmlTranslate2)xmlTrans).setXml2Painter(this);
        painter = (IPainter)xmlTrans.fromXmlElement(xml);
        return painter;
    }

    private void parseChildren(Canvas cv, Element xml) {
        Iterator itr = xml.elements().iterator();
        while (itr.hasNext()) {
            IPainter pnt = this.parsePainter((Element)itr.next());
            if (pnt == null) continue;
            cv.addPainter(pnt);
        }
    }

    public void parseCommon(IPainter pnt, Element xml) {
        String layer;
        String extend;
        String decorate;
        if (xml.attributeValue("x") != null) {
            float x = Float.parseFloat(xml.attributeValue("x"));
            float y = Float.parseFloat(xml.attributeValue("y"));
            float width = Float.parseFloat(xml.attributeValue("width"));
            float height = Float.parseFloat(xml.attributeValue("height"));
            pnt.setPainterBounds(x, y, width, height);
        }
        if (xml.attributeValue("background") != null) {
            String rgb = xml.attributeValue("background");
            pnt.setBackGround(KDPrinterUtils.hexToColor(rgb));
        }
        if (xml.attributeValue("style") != null) {
            String styleID = xml.attributeValue("style");
            Style style = this.getStyle(styleID);
            pnt.setStyle(style);
        }
        if ((decorate = xml.attributeValue("decorate")) != null) {
            IDecorate lineDecorate = this.parseLineDecorate(decorate);
            pnt.setDecorate(lineDecorate);
        }
        if ((extend = xml.attributeValue("extend")) != null) {
            pnt.setPainterExtend(Float.parseFloat(extend));
        }
        if ((layer = xml.attributeValue("layer")) != null) {
            pnt.setLayer(Integer.parseInt(layer));
        }
    }

    private IDecorate parseLineDecorate(String decorate) {
        LineBorder de = null;
        int index = decorate.indexOf(":");
        String name = null;
        String type = null;
        if (index >= 0) {
            name = decorate.substring(0, index);
            type = decorate.substring(index + 1);
        }
        if (LineBorder.getName().equals(name)) {
            de = new LineBorder();
            de.setType(Integer.parseInt(type));
        }
        return de;
    }

    public Object getObject(String Id) {
        return this.styles != null ? this.styles.get(Id) : null;
    }

    private Style getStyle(String styleID) {
        return this.styles != null ? (Style)this.styles.get(styleID) : null;
    }

    public StyleCell parseStyleCell(Element xml) {
        StyleCell lbl = new StyleCell();
        this.parseCommon(lbl, xml);
        lbl.setText(xml.getText());
        for (int i = 0; i < StyleCell.StylesDir.length; ++i) {
            String id = xml.attributeValue("aroundstyle" + i);
            if (id == null) continue;
            Style style = this.getStyle(id);
            lbl.setAroundStyles(StyleCell.StylesDir[i], style);
        }
        String isBlackWhite = xml.attributeValue("isBlackWhite");
        lbl.setBlackWhite(Boolean.parseBoolean(isBlackWhite));
        int borderSpace = 1;
        if (xml.attributeValue("borderspace") != null) {
            borderSpace = Integer.parseInt(xml.attributeValue("borderspace"));
            lbl.setBorderSpace(borderSpace);
        }
        int borderMode = Integer.parseInt(xml.attributeValue("bordermode"));
        lbl.setBorderMode(borderMode);
        Element diagonal = xml.element("DiagonalHeader");
        if (diagonal != null) {
            AbstractTableSplitRectInfo info = TableSplitRectInfoXml.fromXml(diagonal, this.styles);
            lbl.setDiagonalInfo(info);
        }
        return lbl;
    }

    public LabelCell parseLabel(Element xml) {
        LabelCell lbl = new LabelCell();
        this.parseCommon(lbl, xml);
        String isBlackWhite = xml.attributeValue("isBlackWhite");
        if (isBlackWhite != null) {
            lbl.setBlackWhite(Boolean.parseBoolean(isBlackWhite));
        }
        lbl.setText(xml.getText());
        return lbl;
    }

    public LabelCell parseVariantLabel(Element xml) {
        VariantLabelCell lbl = new VariantLabelCell();
        this.parseCommon(lbl, xml);
        lbl.setText(xml.getText());
        return lbl;
    }

    public LineCell parseLine(Element xml) {
        LineCell ln = new LineCell();
        this.parseCommon(ln, xml);
        if (xml.attributeValue("color") != null) {
            String rgb = xml.attributeValue("color");
            ln.setColor(KDPrinterUtils.hexToColor(rgb));
        }
        if (xml.attributeValue("x1") != null) {
            String x1 = xml.attributeValue("x1");
            String y1 = xml.attributeValue("y1");
            String x2 = xml.attributeValue("x2");
            String y2 = xml.attributeValue("y2");
            ln.setLine(Float.parseFloat(x1), Float.parseFloat(y1), Float.parseFloat(x2), Float.parseFloat(y2));
        }
        return ln;
    }

    public ImageCell parseImage(Element xml) {
        String scale;
        File file;
        ImageCell img = new ImageCell();
        this.parseCommon(img, xml);
        String text = xml.getText();
        String imageKey = xml.attributeValue("imageKey");
        img.setImageKey(imageKey);
        if (!StringUtil.isEmptyString(text) && (file = new File(text)).exists()) {
            try (FileInputStream inputStream = new FileInputStream(text);){
                byte[] bytes = StreamUtil.readInputStream(inputStream);
                img.setImage(ImageUtil.makeImage(bytes));
            }
            catch (Exception e) {
                this.log.error("\u4ece\u78c1\u76d8\u7f13\u5b58\u8bfb\u53d6\u56fe\u7247\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
        if ((scale = xml.attributeValue("scale")) != null && !"".equals(scale)) {
            img.setScale(Integer.parseInt(scale));
        }
        return img;
    }

    public Canvas parseCanvas(Element xml) {
        Canvas pg = new Canvas();
        this.parseCommon(pg, xml);
        this.parseChildren(pg, xml);
        return pg;
    }

    public Page parsePage(Element xml) {
        Page pg = new Page();
        this.parseCommon(pg, xml);
        this.parseChildren(pg, xml);
        return pg;
    }

    private IPainter parseTable(Element xml) {
        String rows = xml.attributeValue("rows");
        String columns = xml.attributeValue("columns");
        float[] rowsHeight = StringUtil.str2FloatArray(rows, ",");
        float[] columnsHeight = StringUtil.str2FloatArray(columns, ",");
        TableCell table = new TableCell(rowsHeight.length, columnsHeight.length);
        this.parseCommon(table, xml);
        table.setRows(rowsHeight);
        table.setColumns(columnsHeight);
        String grid = xml.attributeValue("grid");
        table.setGrid("true".equals(grid));
        List cellChildren = xml.elements("cell");
        int size = cellChildren.size();
        block0: for (int i = 0; i < size; ++i) {
            Element cell = (Element)cellChildren.get(i);
            int rowIndex = Integer.parseInt(cell.attributeValue("row"));
            int colIndex = Integer.parseInt(cell.attributeValue("column"));
            List content = cell.elements();
            int length = content.size();
            for (int j = 0; j < length; ++j) {
                Object pXml = content.get(j);
                if (!(pXml instanceof Element)) continue;
                IPainter painter = this.parsePainter((Element)pXml);
                table.setValue(rowIndex, colIndex, (StyleCell)painter);
                continue block0;
            }
        }
        List mergChildren = xml.elements("mergeblock");
        int size2 = mergChildren.size();
        for (int i = 0; i < size2; ++i) {
            Element block = (Element)mergChildren.get(i);
            int row = Integer.parseInt(block.attributeValue("row"));
            int col = Integer.parseInt(block.attributeValue("col"));
            int row2 = Integer.parseInt(block.attributeValue("row2"));
            int col2 = Integer.parseInt(block.attributeValue("col2"));
            table.addMerge(row, col, row2, col2);
        }
        return table;
    }

    public Paper parsePaper(Element xml) {
        Paper pp = new Paper();
        this.parseCommon(pp, xml);
        this.parseChildren(pp, xml);
        return pp;
    }
}

