/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.ui.view;

import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.config.PrintJobConfig;
import com.kingdee.bos.ctrl.print.ui.component.IPainter;
import com.kingdee.bos.ctrl.print.ui.component.ImageCell;
import com.kingdee.bos.ctrl.print.ui.component.Page;
import com.kingdee.bos.ctrl.print.ui.component.PainterInfo;
import com.kingdee.bos.ctrl.print.ui.view.BasicPainterView;
import com.kingdee.bos.ctrl.print.ui.view.StyleRender;
import com.kingdee.bos.ctrl.reportone.r1.print.common.ImageUtil;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfGraphics2D;
import com.lowagie.text.pdf.PdfTemplate;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import javax.imageio.ImageIO;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ImagePainter
extends BasicPainterView {
    private Log log = LogFactory.getLog(ImagePainter.class);
    private float paperHeight;
    private PdfTemplate pdfTemplate;

    public void setPaperHeight(float paperHeight) {
        this.paperHeight = paperHeight;
    }

    public void setPdfTemplate(PdfTemplate pdfTemplate) {
        this.pdfTemplate = pdfTemplate;
    }

    @Override
    public void paint(Graphics g, IPainter painter, PainterInfo graInfo) {
        double imageHeight;
        double yRate;
        double rate;
        super.paint(g, painter, graInfo);
        ImageCell imageCell = (ImageCell)painter;
        float imageCellX = imageCell.getX();
        float imageCellY = imageCell.getY();
        Rectangle2D.Float floatXy = this.calXy(painter.getParent(), new Rectangle2D.Float());
        if (floatXy != null) {
            imageCellX += floatXy.x;
            imageCellY += floatXy.y;
        }
        float width = imageCell.getWidth() - 1.0f;
        float height = imageCell.getHeight() - 1.0f;
        String imageKey = imageCell.getImageKey();
        com.lowagie.text.Image image = null;
        if (StringUtils.isNotBlank((CharSequence)imageKey)) {
            image = this.loadImage(imageKey);
        } else {
            Image awtImage = imageCell.getImage();
            image = this.toPdfImage(awtImage);
        }
        if (image == null) {
            return;
        }
        double imageWidth = image.getWidth();
        double xRate = imageWidth / (double)width;
        double d = rate = xRate > (yRate = (imageHeight = (double)image.getHeight()) / (double)height) ? xRate : yRate;
        if (rate == xRate) {
            imageWidth = width;
            imageHeight /= rate;
        } else {
            imageWidth /= rate;
            imageHeight = height;
        }
        Rectangle rcContent = StyleRender.getContentBounds((int)imageCell.getWidth(), (int)imageCell.getHeight(), imageCell.getStyle());
        Point point = this.caculatePos(imageWidth, imageHeight, rcContent, imageCell.getStyle());
        PdfTemplate pdfTemplate = this.pdfTemplate;
        if (g instanceof PdfGraphics2D) {
            PdfGraphics2D graphics2D = (PdfGraphics2D)g;
            pdfTemplate = (PdfTemplate)graphics2D.getContent();
        }
        this.addImage(pdfTemplate, image, StyleUtil.pixelToLom((long)imageWidth), StyleUtil.pixelToLom((long)imageHeight), StyleUtil.pixelToLom((long)(imageCellX + (float)point.x)), StyleUtil.pixelToLom((long)(imageCellY + (float)point.y)), graInfo);
    }

    private Rectangle2D.Float calXy(IPainter iPainter, Rectangle2D.Float parXy) {
        IPainter parent;
        if (iPainter == null) {
            return parXy;
        }
        if (!(iPainter instanceof Page)) {
            float x = parXy.x + iPainter.getX();
            float y = parXy.y + iPainter.getY();
            parXy.x = x;
            parXy.y = y;
        }
        if ((parent = iPainter.getParent()) != null && !(parent instanceof Page)) {
            parXy = this.calXy(parent, parXy);
        }
        return parXy;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private com.lowagie.text.Image toPdfImage(Image image) {
        if (image == null) {
            return null;
        }
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            int width = image.getWidth(null);
            int height = image.getHeight(null);
            ColorModel cm = ColorModel.getRGBdefault();
            WritableRaster wr = cm.createCompatibleWritableRaster(width, height);
            BufferedImage bufferedImage = new BufferedImage(cm, wr, cm.isAlphaPremultiplied(), null);
            Graphics2D g = bufferedImage.createGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
            ImageIO.write((RenderedImage)bufferedImage, "png", os);
            os.flush();
            com.lowagie.text.Image image2 = com.lowagie.text.Image.getInstance((byte[])os.toByteArray());
            return image2;
        }
        catch (Exception e) {
            this.log.error("\u56fe\u7247\u7f13\u5b58\u78c1\u76d8\u5931\u8d25\uff1a", (Throwable)e);
            return null;
        }
    }

    private com.lowagie.text.Image loadImage(String imageKey) {
        byte[] imageByte = ImageUtil.getImageByUrl(imageKey);
        try {
            return com.lowagie.text.Image.getInstance((byte[])imageByte);
        }
        catch (Exception e) {
            this.log.error("loadImage error:", (Throwable)e);
            return null;
        }
    }

    private void addImage(PdfTemplate pdfTemplate, com.lowagie.text.Image image, float widthLom, float heightLom, float xLom, float yLom, PainterInfo graInfo) {
        PrintJobConfig attributeManager = graInfo.getAttributeManager();
        float topM = attributeManager.getBodyTopMargin(1000);
        float leftM = attributeManager.getLeftMargin(1000);
        float marginLeft = leftM * 10.0f;
        float marginTop = topM * 10.0f;
        yLom = marginTop + yLom + heightLom;
        float paperHeight = this.paperHeight;
        try {
            pdfTemplate.addImage(image, (float)StyleUtil.lomToPt(widthLom), 0.0f, 0.0f, (float)StyleUtil.lomToPt(heightLom), (float)StyleUtil.lomToPt(marginLeft + xLom), paperHeight - (float)StyleUtil.lomToPt(yLom));
        }
        catch (DocumentException e) {
            this.log.error("\u7ed8\u5236\u56fe\u7247\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    protected void addImage(com.lowagie.text.Image image, float widthLom, float heightLom, float xLom, float yLom, PainterInfo graInfo) {
        this.addImage(this.pdfTemplate, image, widthLom, heightLom, xLom, yLom, graInfo);
    }

    private Point caculatePos(double imageWidth, double imageHeight, Rectangle cellRect, Style cellStyle) {
        Point pos = cellRect.getLocation();
        if (cellStyle.getHorizontalAlign().equals(Styles.HorizontalAlignment.CENTER)) {
            if (imageWidth <= (double)cellRect.width) {
                pos.x = (int)((double)pos.x + ((double)cellRect.width - imageWidth) / 2.0);
            }
        } else if (cellStyle.getHorizontalAlign().equals(Styles.HorizontalAlignment.RIGHT) && imageWidth <= (double)cellRect.width) {
            pos.x = (int)((double)pos.x + ((double)cellRect.width - imageWidth));
        }
        if (cellStyle.getVerticalAlign().equals(Styles.VerticalAlignment.MIDDLE)) {
            if (imageHeight <= (double)cellRect.height) {
                pos.y = (int)((double)pos.y + ((double)cellRect.height - imageHeight) / 2.0);
            }
        } else if (cellStyle.getVerticalAlign().equals(Styles.VerticalAlignment.BOTTOM) && imageHeight <= (double)cellRect.height) {
            pos.y = (int)((double)pos.y + ((double)cellRect.height - imageHeight));
        }
        return pos;
    }
}

