/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.ui.view;

import com.kingdee.bos.ctrl.kdf.util.render.IBorderHolder;
import com.kingdee.bos.ctrl.kdf.util.render.splitrectangle.AbstractTableSplitRectInfo;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.ui.component.IPainter;
import com.kingdee.bos.ctrl.print.ui.component.PainterInfo;
import com.kingdee.bos.ctrl.print.ui.component.StyleCell;
import com.kingdee.bos.ctrl.print.ui.view.BasicPainterView;
import com.kingdee.bos.ctrl.print.ui.view.StyleRender;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class StyleCellView
extends BasicPainterView {
    protected static StyleCellView labelUI = new StyleCellView();
    Rectangle2D.Float cellRect = new Rectangle2D.Float();
    Rectangle2D.Float borderRect = new Rectangle2D.Float();

    public static BasicPainterView createPainterView() {
        return labelUI;
    }

    private Rectangle2D.Float getCellRect(Rectangle2D.Float borderRect, int borderSpace) {
        float spp = 0.9999f;
        this.cellRect.x = borderRect.x + (float)borderSpace + spp;
        this.cellRect.y = borderRect.y + (float)borderSpace + spp;
        this.cellRect.width = borderRect.width - (float)(2 * borderSpace) - spp;
        this.cellRect.height = borderRect.height - (float)(2 * borderSpace) - spp;
        return this.cellRect;
    }

    @Override
    public void paint(Graphics g, IPainter painter, PainterInfo graInfo) {
        StyleCell sheetCell = (StyleCell)painter;
        this.borderRect.setRect(0.0f, 0.0f, (float)sheetCell.getPainterSize().getWidth(), (float)sheetCell.getPainterSize().getHeight());
        Rectangle2D.Float theCellRect = this.getCellRect(this.borderRect, sheetCell.getBorderSpace());
        Color backColor = painter.getBackGround();
        if (backColor != null && backColor.getAlpha() == 255) {
            Color old = g.getColor();
            g.setColor(backColor);
            ((Graphics2D)g).fill(theCellRect);
            g.setColor(old);
        }
        boolean isBlackWhite = sheetCell.isBlackWhite();
        StyleRender.setBlackWhite(isBlackWhite);
        StyleRender.getBorderRender2().setBlackWhite(isBlackWhite);
        Graphics2D g2d = (Graphics2D)g;
        Style style = painter.getStyle();
        if (style == null) {
            style = Styles.getDefaultStyle();
        }
        StyleRender.getCellBackRender().draw(g2d, this.borderRect, null, style);
        int space = sheetCell.getTextSpace();
        theCellRect.setRect(theCellRect.getX() + (double)space, theCellRect.getY(), theCellRect.getWidth() - (double)(2 * space), theCellRect.getHeight());
        ArrayList customRenders = sheetCell.getCustomRenders();
        if (customRenders != null && customRenders.size() > 0) {
            int size = customRenders.size();
            for (int i = 0; i < size; ++i) {
                ((StyleCell.AbstractCustomRenderWrapper)customRenders.get(i)).draw(g2d, theCellRect, sheetCell.getDisplayText(graInfo), style);
            }
        } else {
            StyleRender.drawText(g, theCellRect, sheetCell.getDisplayText(graInfo), style, graInfo.getEncode());
        }
        AbstractTableSplitRectInfo splitInfo = sheetCell.getDiagonalInfo();
        if (splitInfo != null) {
            StyleRender.drawSplitRectText(g2d, this.borderRect, splitInfo);
        }
        StyleRender.getBorderRender2().setHolder((IBorderHolder)((Object)painter));
        StyleRender.getBorderRender2().draw(g2d, this.borderRect, sheetCell.getBorderInfo(), style);
    }
}

