/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.util;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class ImageFillUtil {
    public static final byte DRAW_CENTER = 0;
    public static final byte DRAW_TILE = 1;
    public static final byte DRAW_FILL = 2;

    public static void draw(Graphics2D g, Image image, Rectangle2D.Float rect, byte mode) {
        if (mode == 2) {
            ImageFillUtil.drawFill(g, image, rect);
        } else if (mode == 1) {
            ImageFillUtil.drawTile(g, image, rect);
        } else {
            ImageFillUtil.drawCenter(g, image, rect);
        }
    }

    public static void drawCenter(Graphics2D g, Image image, Rectangle2D.Float rect) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        int x = Math.round((rect.width - (float)width) / 2.0f);
        int y = Math.round((rect.height - (float)height) / 2.0f);
        g.drawImage(image, x, y, null);
    }

    public static void drawFill(Graphics2D g, Image image, Rectangle2D.Float rect) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        float xscale = rect.width / (float)width;
        float yscale = rect.height / (float)height;
        g.scale(xscale, yscale);
        g.drawImage(image, 0, 0, null);
        g.scale(1.0f / xscale, 1.0f / yscale);
    }

    public static void drawTile(Graphics2D g, Image image, Rectangle2D.Float rect) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.drawImage(image, 0, 0, null);
        TexturePaint paint = new TexturePaint(bufferedImage, new Rectangle2D.Float(0.0f, 0.0f, width, height));
        g.setPaint(paint);
        g.fill(rect);
    }

    public static boolean waitForImage(Image image, Component c) {
        MediaTracker tracker = new MediaTracker(c);
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return !tracker.isErrorAny();
    }
}

