/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.util;

import com.kingdee.bos.ctrl.common.PrintProxy;
import com.kingdee.bos.ctrl.print.PropertyConfig;
import com.kingdee.bos.ctrl.print.config.attribute.FreeMediaSize;
import com.kingdee.bos.ctrl.print.config.attribute.MediaSizeNameExtend;
import java.util.ArrayList;
import java.util.HashMap;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class MediaUtil {
    private static final Log logger = LogFactory.getLog(MediaUtil.class);
    public static final Class mdCategory = Media.class;
    protected static final HashMap PRINTSERVICES = new HashMap();
    public static final MediaSizeName[] dmPaperToPrintService = new MediaSizeName[]{MediaSizeName.NA_LETTER, MediaSizeName.NA_LETTER, MediaSizeName.TABLOID, MediaSizeName.LEDGER, MediaSizeName.NA_LEGAL, MediaSizeName.INVOICE, MediaSizeName.EXECUTIVE, MediaSizeName.ISO_A3, MediaSizeName.ISO_A4, MediaSizeName.ISO_A4, MediaSizeName.ISO_A5, MediaSizeName.JIS_B4, MediaSizeName.JIS_B5, MediaSizeName.FOLIO, MediaSizeName.QUARTO, MediaSizeName.NA_10X14_ENVELOPE, MediaSizeName.B, MediaSizeName.NA_LETTER, MediaSizeName.NA_NUMBER_9_ENVELOPE, MediaSizeName.NA_NUMBER_10_ENVELOPE, MediaSizeName.NA_NUMBER_11_ENVELOPE, MediaSizeName.NA_NUMBER_12_ENVELOPE, MediaSizeName.NA_NUMBER_14_ENVELOPE, MediaSizeName.C, MediaSizeName.D, MediaSizeName.E, MediaSizeName.ISO_DESIGNATED_LONG, MediaSizeName.ISO_C5, MediaSizeName.ISO_C3, MediaSizeName.ISO_C4, MediaSizeName.ISO_C6, MediaSizeName.ITALY_ENVELOPE, MediaSizeName.ISO_B4, MediaSizeName.ISO_B5, MediaSizeName.ISO_B6, MediaSizeName.ITALY_ENVELOPE, MediaSizeName.MONARCH_ENVELOPE, MediaSizeName.PERSONAL_ENVELOPE, MediaSizeName.NA_10X15_ENVELOPE, MediaSizeName.NA_9X12_ENVELOPE, MediaSizeName.FOLIO, MediaSizeName.ISO_B4, MediaSizeName.JAPANESE_POSTCARD, MediaSizeName.NA_9X11_ENVELOPE};
    public static MediaSize[] predefMedia;
    private static PrintProxy pp;

    public static Object getMediaByPrinter(PrintService psCurrent, DocFlavor docFlavor, HashPrintRequestAttributeSet asCurrent) {
        logger.debug("MediaUtil#getMediaByPrinter:" + psCurrent.getName());
        Object values = null;
        if (PropertyConfig.isUseMediaSizeDll()) {
            try {
                String printer = psCurrent.getName();
                values = PRINTSERVICES.get(printer);
                if (values == null) {
                    values = MediaUtil.initMedia(printer);
                    PRINTSERVICES.put(psCurrent.getName(), values);
                }
            }
            catch (Throwable e) {
                logger.error(e);
                values = psCurrent.getSupportedAttributeValues(mdCategory, docFlavor, asCurrent);
            }
        } else {
            values = psCurrent.getSupportedAttributeValues(mdCategory, docFlavor, asCurrent);
        }
        return values;
    }

    private static Object initMedia(String printer) throws Exception {
        logger.debug("MediaUtil#initMedia:" + printer);
        ArrayList arraylist = new ArrayList();
        ArrayList idList = new ArrayList();
        MediaSize[] mediaSizes = MediaUtil.getMediaSizes(idList, printer);
        for (int j = 0; j < idList.size(); ++j) {
            boolean flag;
            MediaSizeName mediasizename = mediaSizes[j].getMediaSizeName();
            if (mediasizename != null && (flag = MediaUtil.addToUniqueList(arraylist, mediasizename))) continue;
        }
        MediaSizeName[] mediaSizeNames = new MediaSizeName[arraylist.size()];
        arraylist.toArray(mediaSizeNames);
        return mediaSizeNames;
    }

    private static MediaSize[] getMediaSizes(ArrayList arraylist, String printer) throws Exception {
        logger.debug("MediaUtil#getMediaSizes:" + printer);
        int[] ai1 = MediaUtil.getAllMediaSizes(printer);
        String[] as = MediaUtil.getAllMediaNames(printer);
        arraylist.clear();
        MediaSize mediasize = null;
        if (ai1 == null || as == null) {
            return new MediaSize[0];
        }
        int i = ai1.length / 2;
        ArrayList<MediaSize> arraylist1 = new ArrayList<MediaSize>();
        for (int j = 0; j < i; ++j) {
            float f = ai1[j * 2] / 10;
            float f1 = ai1[j * 2 + 1] / 10;
            MediaSizeName mediasizename = MediaUtil.findMatchingMediaSizeNameMM(f, f1);
            if (mediasizename != null) {
                mediasize = MediaSize.getMediaSizeForName(mediasizename);
            }
            if (mediasize != null) {
                arraylist.add(mediasizename.getValue());
                arraylist1.add(mediasize);
            } else {
                MediaSizeNameExtend win32mediasize = MediaSizeNameExtend.create(as[j]);
                try {
                    arraylist.add(win32mediasize.getValue());
                    mediasize = new FreeMediaSize(f, f1, 1000, (MediaSizeName)win32mediasize);
                    arraylist1.add(mediasize);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            }
            mediasize = null;
        }
        MediaSize[] amediasize = new MediaSize[arraylist1.size()];
        arraylist1.toArray(amediasize);
        return amediasize;
    }

    private static MediaSizeName findMatchingMediaSizeNameMM(float f, float f1) {
        if (predefMedia != null) {
            for (int i = 0; i < predefMedia.length; ++i) {
                if (predefMedia[i] == null || !MediaUtil.isSameSize(predefMedia[i].getX(1000), predefMedia[i].getY(1000), f, f1)) continue;
                MediaSizeName msn = predefMedia[i].getMediaSizeName();
                return msn;
            }
        }
        return null;
    }

    private static boolean addToUniqueList(ArrayList arraylist, MediaSizeName mediasizename) {
        for (int i = 0; i < arraylist.size(); ++i) {
            MediaSizeName mediasizename1 = (MediaSizeName)arraylist.get(i);
            if (mediasizename1 != mediasizename) continue;
            return false;
        }
        arraylist.add(mediasizename);
        return true;
    }

    public static boolean isSameSize(float f, float f1, float f2, float f3) {
        float f4 = f - f2;
        float f5 = f1 - f3;
        float f6 = f - f3;
        float f7 = f1 - f2;
        return Math.abs(f4) <= 1.0f && Math.abs(f5) <= 1.0f || Math.abs(f6) <= 1.0f && Math.abs(f7) <= 1.0f;
    }

    public static boolean isPrinterCanUse(String printer) {
        boolean isCanUse = true;
        return isCanUse;
    }

    private static PrintProxy getPrintProxy() {
        if (pp == null) {
            logger.debug("MediaUtil#getPrintProxy#new PrintProxy");
            pp = PrintProxy.getInstance();
        }
        return pp;
    }

    private static String[] getAllMediaNames(String printer) {
        logger.debug("MediaUtil#getAllMediaNames:" + printer);
        try {
            return null;
        }
        catch (Throwable e) {
            logger.error(e);
            return null;
        }
    }

    private static int[] getAllMediaSizes(String printer) {
        logger.debug("MediaUtil#getAllMediaSizes:" + printer);
        int[] sizes = new int[]{};
        return sizes;
    }

    static {
        pp = null;
    }
}

