/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.util;

import com.kingdee.bos.ctrl.common.util.list.FileBasedList;
import com.kingdee.bos.ctrl.common.util.list.exception.OutOfCapacityException;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.print.ui.component.Page;
import com.kingdee.bos.ctrl.print.ui.io.Painter2Xml;
import com.kingdee.bos.ctrl.print.ui.io.Xml2Painter;
import com.kingdee.bos.ctrl.print.util.TempFileUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class PrintPageFileBuffer
extends FileBasedList {
    private int memoryBuffercount = 10;
    private List pageCache = new ArrayList();
    private Map styles = new HashMap();
    private Painter2Xml toXml = new Painter2Xml(this.styles);
    private Xml2Painter fromXml = new Xml2Painter(this.styles);
    private static final Log log = LogFactory.getLog(PrintPageFileBuffer.class);

    public PrintPageFileBuffer(int memoryCount) throws IOException {
        super(-1, false);
        this.memoryBuffercount = memoryCount;
    }

    private void createBufferFile() throws IOException {
        if (this.randomFile == null) {
            File bufferFile = TempFileUtil.createPrintTempFile();
            this.filePath = bufferFile.getCanonicalPath();
            if (this.filePath.contains("\\")) {
                this.filePath = this.filePath.replace('\\', '/');
                bufferFile = new File(this.filePath);
            }
            if (!bufferFile.getParentFile().exists()) {
                bufferFile.getParentFile().mkdirs();
            }
            this.randomFile = new RandomAccessFile(bufferFile, "rws");
            this.randomFile.setLength(0L);
        }
    }

    @Override
    public Object get(int index) {
        if (index < this.memoryBuffercount) {
            return this.pageCache.get(index);
        }
        return super.get(index - this.memoryBuffercount);
    }

    @Override
    public void add(int index, Object obj) throws OutOfCapacityException {
        if (index < this.memoryBuffercount) {
            this.pageCache.add(index, obj);
            return;
        }
        try {
            this.createBufferFile();
            super.add(index - this.memoryBuffercount, obj);
        }
        catch (IOException e) {
            log.error((Throwable)e);
            throw new OutOfCapacityException();
        }
    }

    @Override
    public void add(Object obj) throws OutOfCapacityException {
        this.add(this.size(), obj);
    }

    @Override
    public int size() {
        return this.pageCache.size() + super.size();
    }

    @Override
    protected Object pureReadObject(int position, int objsize) {
        Element xml;
        byte[] data;
        try {
            data = super.readBytes(position, objsize);
        }
        catch (IOException e) {
            log.error((Throwable)e);
            return null;
        }
        try {
            xml = XmlUtil.loadXmlBytes(data);
        }
        catch (IOException e1) {
            log.error((Throwable)e1);
            return null;
        }
        catch (DocumentException e1) {
            log.error((Throwable)e1);
            return null;
        }
        return this.fromXml.parsePage(xml);
    }

    @Override
    protected int pureWriteObject(int position, Object object) {
        byte[] data;
        if (!(object instanceof Page)) {
            return 0;
        }
        Element xml = this.toXml.makePage((Page)object);
        try {
            data = XmlUtil.saveXmlBytes(xml);
        }
        catch (IOException e1) {
            log.info(e1.getMessage());
            return 0;
        }
        try {
            super.writeBytes(position, data);
        }
        catch (IOException e) {
            log.info(e.getMessage());
            return 0;
        }
        return data.length;
    }

    @Override
    public void clear() {
        this.pageCache.clear();
        this.styles.clear();
        super.clear();
    }

    public Map getStyles() {
        return this.styles;
    }
}

