/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.util;

import com.kingdee.bos.ctrl.common.GlobalLocator;
import com.kingdee.bos.ctrl.common.util.FileUtil;
import java.io.File;
import java.io.IOException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class TempFileUtil {
    private static final Log logger = LogFactory.getLog(TempFileUtil.class);

    public static void deleteTempFile() {
        try {
            GlobalLocator gl = GlobalLocator.getInstance();
            FileUtil.deleteContent(gl.makeFilePath("/temp"), "tempprint");
        }
        catch (Throwable e) {
            logger.error("TempFileUtil#deleteTempFile: error.");
        }
    }

    public static File createTempFile() {
        File bufferFile = GlobalLocator.getInstance().createTempFile("tempprint", "");
        return bufferFile;
    }

    public static File createPrintTempFile() {
        try {
            File temp = File.createTempFile("tempprint", "", GlobalLocator.getInstance().locateResourceFolder("/temp/" + Thread.currentThread().getId()));
            return temp;
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    public static boolean clearPrintTempFileDir() {
        File dir = GlobalLocator.getInstance().locateResourceFolder("/temp/" + Thread.currentThread().getId());
        if (dir.exists() && dir.isDirectory()) {
            return FileUtil.deleteFile(dir) == null;
        }
        return false;
    }
}

