/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.xls;

import com.kingdee.bos.ctrl.print.ui.component.IPainter;
import com.kingdee.bos.ctrl.print.xls.translater.AR1PNode_V2X;
import com.kingdee.bos.ctrl.print.xls.translater.DividableObject_V2X;
import com.kingdee.bos.ctrl.print.xls.widget.IXlsNode;
import java.io.InputStream;
import java.rmi.server.ExportException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class R1PrintV2XExporter {
    private ObjectFactory _objFactory;
    private HashMap _catchFactory = new HashMap();
    protected Logger _log = Logger.getLogger((String)"R1PrintV2XExporter");
    private static final String DIVIDEV2XKEY = "divideObject";

    public R1PrintV2XExporter() throws ExportException {
        String config = "/R1PrintView2Xls.xml";
        try (InputStream in = this.getClass().getResourceAsStream(config);){
            if (in == null) {
                throw new ExportException("ObjectFactory config xml not found:" + config);
            }
            this._catchFactory.put(DIVIDEV2XKEY, new DividableObject_V2X());
            this._objFactory = new ObjectFactory(in);
        }
        catch (Exception e) {
            throw new ExportException("initError", e);
        }
    }

    private AR1PNode_V2X createExporter(IPainter painter) {
        String key = painter.getClass().getName();
        AR1PNode_V2X exporter = (AR1PNode_V2X)this._catchFactory.get(key);
        if (exporter == null) {
            exporter = this._objFactory.getV2X(key);
            this._catchFactory.put(key, exporter);
        }
        return exporter;
    }

    public IXlsNode translate(IPainter painter, IXlsNode parent) {
        AR1PNode_V2X translater = this.createExporter(painter);
        translater.setExporter(this);
        translater.setNode(painter);
        return translater.export(parent);
    }

    class ObjectFactory {
        private static final String NODE = "Node";
        private static final String TYPE = "type";
        private static final String CLASS = "class";
        private Map _classCache = new HashMap(16);

        public ObjectFactory(InputStream in) {
            SAXReader _sb = new SAXReader();
            Document doc = null;
            try {
                doc = _sb.read(in);
            }
            catch (Exception e) {
                R1PrintV2XExporter.this._log.error((Object)"parse config file faild");
            }
            if (doc != null) {
                Element root = doc.getRootElement();
                List children = root.elements(NODE);
                for (Element element : children) {
                    String key = element.attributeValue(TYPE);
                    String value = element.attributeValue(CLASS);
                    this._classCache.put(key, value);
                }
            }
        }

        public AR1PNode_V2X getV2X(String className) {
            String cls = (String)this._classCache.get(className);
            return (AR1PNode_V2X)this.createObject(cls);
        }

        private Object createObject(String cls) {
            Object obj = null;
            try {
                Class<?> c = Class.forName(cls);
                obj = c.newInstance();
            }
            catch (Exception e) {
                R1PrintV2XExporter.this._log.error((Object)("Can't create Instance of " + cls), (Throwable)e);
            }
            return obj;
        }
    }
}

