/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.xls.output;

import com.kingdee.bos.ctrl.print.util.TempFileUtil;
import com.kingdee.bos.ctrl.print.xls.widget.IXlsNode;
import com.kingdee.bos.ctrl.print.xls.widget.XlsCell;
import com.kingdee.bos.ctrl.print.xls.widget.XlsImageCell;
import com.kingdee.bos.ctrl.print.xls.widget.XlsLabelCell;
import com.kingdee.bos.ctrl.print.xls.widget.XlsPaper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class XlsNodeContainer {
    private int _limit = 10;
    private List _nodeCache;
    private int _size = 0;
    private SAXReader _sb;
    private RandomAccessFile _file;
    private Logger log = Logger.getLogger(XlsNodeContainer.class);
    private boolean _reachLimit = false;
    private FileInputStream _is = null;

    public XlsNodeContainer(int count) {
        this._limit = count;
        this._nodeCache = new ArrayList(count);
    }

    public void add(XlsPaper node) {
        this._nodeCache.add(node);
        ++this._size;
    }

    public void clear() {
        try {
            if (this._file != null) {
                this._file.close();
                this._file = null;
            }
            if (this._is != null) {
                this._is.close();
            }
            this._size = 0;
            this._nodeCache.clear();
            this._reachLimit = false;
        }
        catch (IOException e) {
            this.log.error((Object)"XlsNodeContainer clear faild");
        }
    }

    public Iterator iterator() {
        return new Iterator(){
            private int _currentIndex = 0;

            @Override
            public boolean hasNext() {
                return XlsNodeContainer.this._size > 0;
            }

            public Object next() {
                Object obj = null;
                obj = XlsNodeContainer.this._nodeCache.get(this._currentIndex);
                return obj;
            }

            @Override
            public void remove() {
                XlsNodeContainer.this._nodeCache.remove(this._currentIndex);
                XlsNodeContainer.this._size--;
            }
        };
    }

    private XlsPaper toPaper(Element element) {
        XlsPaper paper = new XlsPaper();
        Element paperInfo = element.element("common");
        Element kids = element.element("children");
        Element curElement2 = null;
        this.parseCommon(paperInfo, paper);
        List children = kids.elements();
        for (Element curElement2 : children) {
            paper.addNode(this.toNode(curElement2));
        }
        return paper;
    }

    private IXlsNode toNode(Element element) {
        XlsCell node = null;
        if (element.getName().equals("text")) {
            node = new XlsLabelCell();
            String value = element.element("value").getText();
            node.setValue(value);
        } else if (element.getName().equals("image")) {
            String content = element.getText();
            byte[] data = Base64.getDecoder().decode(content);
            ImageIcon icon = null;
            try {
                ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(data));
                icon = (ImageIcon)oin.readObject();
            }
            catch (Exception e) {
                this.log.error((Object)"read image cached data faild!", (Throwable)e);
            }
            XlsImageCell cell = new XlsImageCell();
            if (icon != null) {
                cell.setImage(icon.getImage());
            }
            node = cell;
        }
        Element tempE = element.element("common");
        this.parseCommon(tempE, node);
        return node;
    }

    private void parseCommon(Element element, IXlsNode node) {
        if (element == null) {
            return;
        }
        float width = Float.parseFloat(element.attributeValue("cell.width"));
        float height = Float.parseFloat(element.attributeValue("cell.height"));
        int layer = Integer.parseInt(element.attributeValue("layer"));
        String stylekey = element.attributeValue("stylecode");
        String location = element.elementText("location");
        String[] locations = location.split(",");
        node.setBounds(Float.parseFloat(locations[0]), Float.parseFloat(locations[1]), width + 1.0f, height + 1.0f);
        node.setStyleKey(stylekey);
        node.setLayer(layer);
    }

    private File createBufferFile() {
        File bufferFile = null;
        if (this._file == null) {
            bufferFile = TempFileUtil.createTempFile();
            try {
                this._file = new RandomAccessFile(bufferFile, "rw");
            }
            catch (IOException e) {
                this.log.error((Object)"create xls cache faild", (Throwable)e);
            }
        } else {
            bufferFile = TempFileUtil.createTempFile();
        }
        return bufferFile.getAbsoluteFile();
    }

    private SAXReader getSAXBuilder() {
        if (this._sb == null) {
            this._sb = new SAXReader();
        }
        return this._sb;
    }

    public int size() {
        return this._size;
    }
}

