/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.xls.widget;

import com.kingdee.bos.ctrl.print.ui.component.PainterInfo;
import com.kingdee.bos.ctrl.print.xls.exception.OutOfSizeException;
import com.kingdee.bos.ctrl.print.xls.output.LinesList;
import com.kingdee.bos.ctrl.print.xls.widget.IXlsNode;
import com.kingdee.bos.ctrl.print.xls.widget.XlsContainer;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;

public class XlsPaper
extends XlsContainer {
    private PainterInfo _painterInfo;
    private LinesList _horizonLines = new LinesList();
    private LinesList _verticalLines = new LinesList();
    private Logger log = Logger.getLogger(XlsPaper.class);

    @Override
    public void addNode(IXlsNode node) {
        if (node == null) {
            return;
        }
        try {
            this._verticalLines.add(node.getX1());
            this._verticalLines.add(node.getX2());
            this._horizonLines.add(node.getY1());
            this._horizonLines.add(node.getY2());
        }
        catch (OutOfSizeException e) {
            this.log.error((Object)("\u5355\u9875\u5217\u6570\u5927\u4e8e255\uff1f!" + e.getMessage()));
        }
        this.getChildren().add(node);
    }

    public LinesList getHorizonLines() {
        return this._horizonLines;
    }

    public LinesList getVerticalLines() {
        return this._verticalLines;
    }

    public void setPaintInfo(PainterInfo painterInfo) {
        this._painterInfo = painterInfo;
    }

    public PainterInfo getPainterInfo() {
        return this._painterInfo;
    }

    @Override
    public Element toXml() {
        DefaultElement pageXml = new DefaultElement("paper");
        pageXml.add(super.toXml());
        pageXml.add(this.child2Xml());
        return pageXml;
    }

    private Element child2Xml() {
        DefaultElement childrenNode = new DefaultElement("children");
        List children = this.getChildren();
        for (int index = 0; index < children.size(); ++index) {
            IXlsNode node = (IXlsNode)children.get(index);
            childrenNode.add(node.toXml());
        }
        return childrenNode;
    }
}

