/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.element;

public class ElementPath {
    private ElementPath parentPath;
    private transient Object lastPathComponent;

    public ElementPath(Object[] path) {
        if (path == null || path.length == 0) {
            throw new IllegalArgumentException("path in ElementPath must be non null and not empty.");
        }
        this.lastPathComponent = path[path.length - 1];
        if (path.length > 1) {
            this.parentPath = new ElementPath(path, path.length - 1);
        }
    }

    public ElementPath(Object singlePath) {
        if (singlePath == null) {
            throw new IllegalArgumentException("path in ElementPath must be non null.");
        }
        this.lastPathComponent = singlePath;
        this.parentPath = null;
    }

    protected ElementPath(ElementPath parent, Object lastElement) {
        if (lastElement == null) {
            throw new IllegalArgumentException("path in ElementPath must be non null.");
        }
        this.parentPath = parent;
        this.lastPathComponent = lastElement;
    }

    protected ElementPath(Object[] path, int length) {
        this.lastPathComponent = path[length - 1];
        if (length > 1) {
            this.parentPath = new ElementPath(path, length - 1);
        }
    }

    public Object[] getPath() {
        int i = this.getPathCount();
        Object[] result = new Object[i--];
        ElementPath path = this;
        while (path != null) {
            result[i--] = path.lastPathComponent;
            path = path.parentPath;
        }
        return result;
    }

    public Object getLastPathComponent() {
        return this.lastPathComponent;
    }

    public Object getRootPathComponent() {
        return this.getPathComponent(0);
    }

    public int getPathCount() {
        int result = 0;
        ElementPath path = this;
        while (path != null) {
            ++result;
            path = path.parentPath;
        }
        return result;
    }

    public Object getPathComponent(int element) {
        int pathLength = this.getPathCount();
        if (element < 0 || element >= pathLength) {
            throw new IllegalArgumentException("Index " + element + " is out of the specified range");
        }
        ElementPath path = this;
        for (int i = pathLength - 1; i != element; --i) {
            path = path.parentPath;
        }
        return path.lastPathComponent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ElementPath) {
            ElementPath oTreePath = (ElementPath)o;
            if (this.getPathCount() != oTreePath.getPathCount()) {
                return false;
            }
            ElementPath path = this;
            while (path != null) {
                if (!path.lastPathComponent.equals(oTreePath.lastPathComponent)) {
                    return false;
                }
                oTreePath = oTreePath.parentPath;
                path = path.parentPath;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.lastPathComponent.hashCode();
    }

    public boolean isDescendant(ElementPath aTreePath) {
        if (aTreePath == this) {
            return true;
        }
        if (aTreePath != null) {
            int pathLength = this.getPathCount();
            int oPathLength = aTreePath.getPathCount();
            if (oPathLength < pathLength) {
                return false;
            }
            while (oPathLength-- > pathLength) {
                aTreePath = aTreePath.getParentPath();
            }
            return this.equals(aTreePath);
        }
        return false;
    }

    public ElementPath pathByAddingChild(Object child) {
        if (child == null) {
            throw new NullPointerException("Null child not allowed");
        }
        return new ElementPath(this, child);
    }

    public ElementPath getParentPath() {
        return this.parentPath;
    }

    public String toString() {
        StringBuilder tempSpot = new StringBuilder("[");
        int maxCounter = this.getPathCount();
        for (int counter = 0; counter < maxCounter; ++counter) {
            if (counter > 0) {
                tempSpot.append(", ");
            }
            tempSpot.append(this.getPathComponent(counter));
        }
        tempSpot.append("]");
        return tempSpot.toString();
    }
}

