/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid;

import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.AbstractReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractCell;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractColumn;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.IGridsFactory;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.merge.MergeBlock;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.ContainerUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MergeUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.Util;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractGrid
extends AbstractReportObject
implements ICompositeObject {
    protected ArrayList _rows = new ArrayList();
    protected ArrayList _columns = new ArrayList();

    protected abstract IGridsFactory getGridsFactory();

    public int getFeatHeight() {
        int h = 0;
        int rowCnt = this.getRowsCount();
        for (int i = 0; i < rowCnt; ++i) {
            h += this.getRow(i).getFeatHeight();
        }
        return h;
    }

    public int getFeatWidth() {
        int w = 0;
        int colCnt = this.getColumnsCount();
        for (int j = 0; j < colCnt; ++j) {
            w += this.getColumn(j).getFeatWidth();
        }
        return w;
    }

    public AbstractRow insertRow(int type, int rowIndex) {
        if (rowIndex < 0 || rowIndex > this._rows.size()) {
            return null;
        }
        return this.createRow(type, rowIndex);
    }

    public AbstractRow addRow(int type) {
        return this.createRow(type, this._rows.size());
    }

    protected AbstractRow createRow(int type, int rowIndex) {
        AbstractRow row = this.getGridsFactory().createRow(type, this._columns.size());
        row.setHeightLom(50);
        this._rows.add(rowIndex, row);
        MergeUtil.adjustInserRow(this, rowIndex);
        return row;
    }

    public boolean insertRow(AbstractRow row, int idx) {
        if (row.getCellCount() == this.getColumnsCount() && idx >= 0 && idx <= this.getRowsCount()) {
            int c = row.getCellCount();
            for (int i = 0; i < c; ++i) {
                row.getCell(i).setMergeBlock(null);
            }
            this._rows.add(idx, row);
            MergeUtil.adjustInserRow(this, idx);
            return true;
        }
        return false;
    }

    public boolean removeRow(AbstractRow row) {
        int idx = this.getIndexOfRow(row);
        boolean result = this.getRows().remove(row);
        if (result) {
            MergeUtil.adjustDeleteRow(this, idx);
        }
        return result;
    }

    public AbstractRow getRow(int rowIndex) {
        return (AbstractRow)this._rows.get(rowIndex);
    }

    private List getRows() {
        return this._rows;
    }

    public int getRowsCount() {
        return this.getRows().size();
    }

    public AbstractColumn addColumn() {
        return this.createColumn(this._columns.size());
    }

    public AbstractColumn insertColumn(int colIndex) {
        if (colIndex < 0 || colIndex > this._columns.size()) {
            return null;
        }
        return this.createColumn(colIndex);
    }

    private AbstractColumn createColumn(int colIndex) {
        AbstractColumn col = this.getGridsFactory().createColumn();
        col.setWidthLom(40);
        this._columns.add(colIndex, col);
        for (int i = 0; i < this.getRowsCount(); ++i) {
            this.getRow(i).insertCell(colIndex);
        }
        MergeUtil.adjustInserCol(this, colIndex);
        return col;
    }

    public boolean removeColumn(AbstractColumn col) {
        int colIdx = this.getIndexOfColumn(col);
        boolean isRemoved = this.getColumns().remove(col);
        if (isRemoved) {
            for (int i = 0; i < this.getRowsCount(); ++i) {
                this.getRow(i).removeCell(colIdx);
            }
            MergeUtil.adjustDeleteCol(this, colIdx);
        }
        return isRemoved;
    }

    public void removeAllCell() {
        this.getColumns().clear();
        this.getRows().clear();
    }

    public AbstractColumn getColumn(int colIndex) {
        return (AbstractColumn)this._columns.get(colIndex);
    }

    public List getColumns() {
        return this._columns;
    }

    public int getColumnsCount() {
        return this.getColumns().size();
    }

    protected abstract int getRowChildrenMinRemain(int var1);

    protected abstract int getColumnChildrenMinRemain(int var1);

    public Point getIndexOfCell(AbstractCell cell) {
        int c = this.getRowsCount();
        for (int i = 0; i < c; ++i) {
            int idx = this.getRow(i).getCells().indexOf(cell);
            if (idx < 0) continue;
            return new Point(i, idx);
        }
        return new Point(-1, -1);
    }

    public int getIndexOfRow(AbstractRow row) {
        return this.getRows().indexOf(row);
    }

    public int getIndexOfColumn(AbstractColumn col) {
        return this.getColumns().indexOf(col);
    }

    public AbstractCell getCell(int rowIndex, int colIndex) {
        return this.getRow(rowIndex).getCell(colIndex);
    }

    public Style getCellStyle(int rowIndex, int colIndex) {
        Style style = this.getCell(rowIndex, colIndex).getStyle();
        if (style == null && (style = this.getRow(rowIndex).getStyle()) == null && (style = this.getColumn(colIndex).getStyle()) == null) {
            style = this.getStyle();
        }
        return style;
    }

    @Override
    public Point getRelativePosition(IElement ele) {
        int x = 0;
        int y = 0;
        Point rowColIdx = new Point(0, 0);
        if (ele instanceof AbstractCell) {
            rowColIdx = this.getIndexOfCell((AbstractCell)ele);
        } else if (ele instanceof AbstractRow) {
            rowColIdx.x = this.getIndexOfRow((AbstractRow)ele);
        } else if (ele instanceof AbstractColumn) {
            rowColIdx.y = this.getIndexOfColumn((AbstractColumn)ele);
        }
        for (int i = 0; i < rowColIdx.x; ++i) {
            y += this.getRow(i).getFeatHeight();
        }
        for (int j = 0; j < rowColIdx.y; ++j) {
            x += this.getColumn(j).getFeatWidth();
        }
        return new Point(x + this.getOffsetX(), y + this.getOffsetY());
    }

    @Override
    public Rectangle getSubElementRectangle(IElement ele) {
        Rectangle rect = new Rectangle();
        Point pt = this.getRelativePosition(ele);
        if (ele instanceof AbstractCell) {
            Point rowColIdx = this.getIndexOfCell((AbstractCell)ele);
            rect.x = pt.x;
            rect.y = pt.y;
            MergeBlock mb = ((AbstractCell)ele).getMergeBlock();
            if (mb != null && mb.isFirstCell(rowColIdx.x, rowColIdx.y)) {
                rect.width = mb.getBlockWidth(this);
                rect.height = mb.getBlockHeight(this);
            } else {
                rect.width = this.getColumn(rowColIdx.y).getFeatWidth();
                rect.height = this.getRow(rowColIdx.x).getFeatHeight();
            }
        } else if (ele instanceof AbstractRow) {
            int r = this.getIndexOfRow((AbstractRow)ele);
            rect.x = this.getOffsetX();
            rect.y = pt.y;
            rect.width = this.getFeatWidth();
            rect.height = this.getRow(r).getFeatHeight();
        } else if (ele instanceof AbstractColumn) {
            int c = this.getIndexOfColumn((AbstractColumn)ele);
            rect.x = pt.x;
            rect.y = this.getOffsetY();
            rect.width = this.getColumn(c).getFeatWidth();
            rect.height = this.getFeatHeight();
        }
        return rect;
    }

    protected ArrayList getCellsList() {
        ArrayList<AbstractCell> result = new ArrayList<AbstractCell>();
        int rc = this.getRowsCount();
        for (int i = 0; i < rc; ++i) {
            int cc = this.getColumnsCount();
            for (int j = 0; j < cc; ++j) {
                result.add(this.getRow(i).getCell(j));
            }
        }
        return result;
    }

    @Override
    public IElement[] getViewSubElements() {
        return this.getCellsList().toArray(new IElement[0]);
    }

    @Override
    public IElement[] getAllSubElements() {
        int i;
        ArrayList result = this.getCellsList();
        int rc = this.getRowsCount();
        for (i = 0; i < rc; ++i) {
            result.add(this.getRow(i));
        }
        int lc = this.getColumnsCount();
        for (i = 0; i < lc; ++i) {
            result.add(this.getColumn(i));
        }
        return result.toArray(new IElement[0]);
    }

    @Override
    public IElement[] getSubSubElements(IElement ele) {
        int idxCol;
        if (ele instanceof AbstractRow) {
            return ((AbstractRow)ele).getCells().toArray(new IElement[0]);
        }
        if (ele instanceof AbstractColumn && (idxCol = this.getIndexOfColumn((AbstractColumn)ele)) >= 0) {
            int c = this.getRowsCount();
            IElement[] cells = new IElement[c];
            for (int i = 0; i < c; ++i) {
                cells[i] = this.getRow(i).getCell(idxCol);
            }
            return cells;
        }
        return null;
    }

    @Override
    public ElementPath makeElementPath(IElement ele) {
        if (ele instanceof AbstractCell) {
            Point rowAndCol = this.getIndexOfCell((AbstractCell)ele);
            ElementPath elementPath = new ElementPath(new Object[]{this, this.getRow(rowAndCol.x), ele});
            return elementPath;
        }
        if (ele instanceof AbstractRow) {
            ElementPath elementPath = new ElementPath(new Object[]{this, ele});
            return elementPath;
        }
        if (ele instanceof AbstractColumn) {
            ElementPath elementPath = new ElementPath(new Object[]{this, ele});
            return elementPath;
        }
        return null;
    }

    @Override
    public boolean isPointInSubElement(IElement ele, Point ptAtPage) {
        Point ptAtObj = new Point(ptAtPage);
        Point ptThisAtPage = ContainerUtil.getPointAtPage(this);
        ptAtObj.translate(-ptThisAtPage.x, -ptThisAtPage.y);
        Rectangle rect = this.getSubElementRectangle(ele);
        int right = rect.x + rect.width;
        int bottom = rect.y + rect.height;
        return ptAtObj.x > rect.x && ptAtObj.x < right && ptAtObj.y > rect.y && ptAtObj.y < bottom;
    }

    protected boolean isNearEnough(int value, int target) {
        return Util.isNearEnough(value, target, 3);
    }

    protected boolean isKeepParentSize(boolean isHorizontalAdjust, boolean isCtrlDown) {
        boolean isKeepParentSize = false;
        isKeepParentSize = isHorizontalAdjust ? (this.isHorizontalFill() ? true : isCtrlDown) : (this.isVerticalFill() ? true : isCtrlDown);
        return isKeepParentSize;
    }

    public boolean isContains(Object ele) {
        if (ele instanceof AbstractCell) {
            return this.getIndexOfCell((AbstractCell)((AbstractCell)ele)).x != -1;
        }
        if (ele instanceof AbstractRow) {
            return this.getRows().contains(ele);
        }
        if (ele instanceof AbstractColumn) {
            return this.getColumns().contains(ele);
        }
        throw new RuntimeException("Element in Grid must be Row/Column/Cell.");
    }

    public int getOffsetX() {
        return 0;
    }

    public int getOffsetY() {
        return 0;
    }

    @Override
    public void applySubElementStyle(IElement ele, StyleAttributes sa) {
        block10: {
            block11: {
                block9: {
                    StyleAttributes saOld = ele.getNotNullSA();
                    saOld.replaceDirty(sa);
                    ele.setStyleAttribute(saOld);
                    if (!(ele instanceof AbstractColumn)) break block9;
                    AbstractColumn col = (AbstractColumn)ele;
                    int idx = this.getIndexOfColumn(col);
                    if (idx < 0) {
                        return;
                    }
                    for (int i = this.getRowsCount() - 1; i >= 0; --i) {
                        AbstractCell cell = this.getCell(i, idx);
                        StyleAttributes saTemp = cell.getStyleAttribute();
                        if (saTemp == null) {
                            saTemp = Styles.getSA(sa);
                        } else {
                            saTemp.replaceDirty(sa);
                        }
                        cell.setStyleAttribute(saTemp);
                    }
                    break block10;
                }
                if (!(ele instanceof AbstractRow)) break block11;
                AbstractRow row = (AbstractRow)ele;
                for (int i = row.getCellCount() - 1; i >= 0; --i) {
                    AbstractCell cell = row.getCell(i);
                    StyleAttributes saTemp = cell.getStyleAttribute();
                    if (saTemp == null) {
                        saTemp = Styles.getSA(sa);
                    } else {
                        saTemp.replaceDirty(sa);
                    }
                    cell.setStyleAttribute(saTemp);
                }
                break block10;
            }
            if (ele != this) break block10;
            for (int i = this.getRowsCount() - 1; i >= 0; --i) {
                AbstractRow row = this.getRow(i);
                for (int j = row.getCellCount() - 1; j >= 0; --j) {
                    AbstractCell cell = row.getCell(j);
                    StyleAttributes saTemp = cell.getNotNullSA();
                    saTemp.replace(sa);
                    cell.setStyleAttribute(saTemp);
                }
            }
        }
    }

    @Override
    public StyleAttributes mixSubElementStyle(IElement ele) {
        ArrayList<StyleAttributes> listSAs = new ArrayList<StyleAttributes>();
        StyleAttributes saDefault = Styles.getDefaultSA();
        if (ele == this) {
            for (int i = this.getRowsCount() - 1; i >= 0; --i) {
                AbstractRow row = this.getRow(i);
                for (int j = row.getCellCount() - 1; j >= 0; --j) {
                    StyleAttributes sa = row.getCell(j).getStyleAttribute();
                    listSAs.add(sa == null || sa.isEmpty() ? saDefault : sa);
                }
            }
        } else if (ele instanceof AbstractRow) {
            AbstractRow row = (AbstractRow)ele;
            for (int i = row.getCellCount() - 1; i >= 0; --i) {
                StyleAttributes sa = row.getCell(i).getStyleAttribute();
                listSAs.add(sa == null || sa.isEmpty() ? saDefault : sa);
            }
        } else if (ele instanceof AbstractColumn) {
            AbstractColumn column = (AbstractColumn)ele;
            int idxCol = this.getIndexOfColumn(column);
            for (int i = this.getRowsCount() - 1; i >= 0; --i) {
                StyleAttributes sa = this.getCell(i, idxCol).getStyleAttribute();
                listSAs.add(sa == null || sa.isEmpty() ? saDefault : sa);
            }
        } else if (ele instanceof AbstractCell) {
            StyleAttributes sa = ele.getStyleAttribute();
            listSAs.add(sa == null || sa.isEmpty() ? saDefault : sa);
        }
        StyleAttributes mixSA = Styles.mixSA(listSAs.toArray(new StyleAttributes[0]));
        ShareStyleAttributes mixSsa = Styles.mergeSSA(new StyleAttributes[]{mixSA, saDefault});
        return Styles.getSA(mixSsa);
    }

    public int getRowDrawingTimes(AbstractRow row) {
        return 1;
    }

    public boolean isMergedCell(AbstractCell cell) {
        if (cell.getMergeBlock() == null) {
            return false;
        }
        return !cell.getMergeBlock().isFirstCell(this.getIndexOfCell(cell));
    }

    public AbstractCell getMainCell(int rowIndex, int colIndex) {
        return this.getMainCell(this.getRow(rowIndex), rowIndex, colIndex);
    }

    public AbstractCell getMainCell(AbstractRow row, int colIndex) {
        int rowIndex = this.getIndexOfRow(row);
        return this.getMainCell(row, rowIndex, colIndex);
    }

    private AbstractCell getMainCell(AbstractRow row, int rowIndex, int colIndex) {
        AbstractCell cell = row.getCell(colIndex);
        MergeBlock mb = cell.getMergeBlock();
        if (mb == null || mb.isFirstCell(rowIndex, colIndex)) {
            return cell;
        }
        return this.getCell(mb.getTop(), mb.getLeft());
    }
}

