/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz;

import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractCell;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractGrid;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractLayoutGridCell;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.merge.MergeBlock;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.ContainerUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.Util;

public abstract class AbstractLayoutGrid
extends AbstractGrid
implements ICompositeContainer {
    @Override
    public void afterAdjusted() {
        this.layoutAllSubContainer();
    }

    @Override
    public int getHeightLom() {
        int h = 0;
        int rowCnt = this.getRowsCount();
        for (int i = 0; i < rowCnt; ++i) {
            h += this.getRow(i).getFeatHeight();
        }
        return Util.pixel2Lom(h);
    }

    @Override
    public void setHeightLom(int height) {
        int old = this.heightLom;
        this.heightLom = height;
        this.firePropertyChange("heightLom", old, height);
    }

    @Override
    public int getWidthLom() {
        int w = 0;
        int colCnt = this.getColumnsCount();
        for (int j = 0; j < colCnt; ++j) {
            w += this.getColumn(j).getFeatWidth();
        }
        return Util.pixel2Lom(w);
    }

    @Override
    public void setWidthLom(int width) {
        int old = this.widthLom;
        this.widthLom = width;
        this.firePropertyChange("widthLom", old, width);
    }

    @Override
    public void layoutAllSubContainer() {
        IContainer[] subContainers = this.getSubContainers();
        for (int i = 0; i < subContainers.length; ++i) {
            IContainer c = subContainers[i];
            if (c.getChildrenCount() <= 0) continue;
            for (IReportObject ro : c.getChildren()) {
                if (ro.isHorizontalFill()) {
                    ro.setXLom(0);
                    ro.setWidthLom(this.getSubContainerInsetsWidthLom(c));
                }
                if (ro.isVerticalFill()) {
                    ro.setYLom(0);
                    ro.setHeightLom(this.getSubContainerInsetsHeightLom(c));
                }
                if (ro instanceof IContainer) {
                    ((IContainer)((Object)ro)).layout();
                    continue;
                }
                if (!(ro instanceof ICompositeContainer)) continue;
                ((ICompositeContainer)((Object)ro)).layoutAllSubContainer();
            }
        }
    }

    @Override
    public IContainer[] getSubContainers() {
        return this.getCellsList().toArray(new IContainer[0]);
    }

    @Override
    public void addChild(IContainer subElement, IReportObject child) {
        if (!(subElement instanceof AbstractCell)) {
            throw new IllegalArgumentException("SubElement must be Cell");
        }
        subElement.addChild(child, null);
        ElementPath elementPath = this.makeElementPath((AbstractCell)((Object)subElement));
        child.setParent(elementPath);
    }

    @Override
    public void removeChild(IContainer subElement, IReportObject child) {
        subElement.removeChild(child);
        child.setParent(null);
    }

    @Override
    public int getSubContainerInsetsWidthLom(IContainer subElement) {
        AbstractCell cell = (AbstractCell)((Object)subElement);
        int w = this.getCellWidthLom(cell);
        Style style = cell.getStyle();
        if (style != null) {
            return w - style.getPadding().getLeft() - style.getPadding().getRight();
        }
        return w;
    }

    @Override
    public int getSubContainerInsetsHeightLom(IContainer subElement) {
        AbstractCell cell = (AbstractCell)((Object)subElement);
        int h = this.getCellHeightLom(cell);
        Style style = cell.getStyle();
        if (style != null) {
            return h - style.getPadding().getTop() - style.getPadding().getBottom();
        }
        return h;
    }

    private int getCellHeightLom(AbstractCell cell) {
        MergeBlock mb = cell.getMergeBlock();
        if (mb != null) {
            return mb.getBlockHeightLom(this);
        }
        int rowIdx = this.getIndexOfCell((AbstractCell)cell).x;
        return this.getRow(rowIdx).getHeightLom();
    }

    private int getCellWidthLom(AbstractCell cell) {
        MergeBlock mb = cell.getMergeBlock();
        if (mb != null) {
            return mb.getBlockWidthLom(this);
        }
        int colIdx = this.getIndexOfCell((AbstractCell)cell).y;
        return this.getColumn(colIdx).getWidthLom();
    }

    @Override
    protected int getRowChildrenMinRemain(int rowIdx) {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < this.getColumnsCount(); ++i) {
            AbstractLayoutGridCell cell = (AbstractLayoutGridCell)this.getCell(rowIdx, i);
            MergeBlock mb = cell.getMergeBlock();
            if (mb != null && !mb.isFirstCell(rowIdx, i)) {
                cell = (AbstractLayoutGridCell)this.getCell(mb.getTop(), mb.getLeft());
            }
            int bottom = ContainerUtil.searchChildrenMaxBottom(cell);
            int remain = this.getSubContainerInsetsHeightLom(cell) - bottom;
            if (remain >= min) continue;
            min = remain;
        }
        if (min == Integer.MAX_VALUE) {
            min = this.getRow(rowIdx).getHeightLom();
        }
        return min;
    }

    @Override
    protected int getColumnChildrenMinRemain(int colIdx) {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < this.getRowsCount(); ++i) {
            AbstractLayoutGridCell cell = (AbstractLayoutGridCell)this.getCell(i, colIdx);
            MergeBlock mb = cell.getMergeBlock();
            if (mb != null && !mb.isFirstCell(i, colIdx)) {
                cell = (AbstractLayoutGridCell)this.getCell(mb.getTop(), mb.getLeft());
            }
            int right = ContainerUtil.searchChildrenMaxRight(cell);
            int remain = this.getSubContainerInsetsWidthLom(cell) - right;
            if (remain >= min) continue;
            min = remain;
        }
        if (min == Integer.MAX_VALUE) {
            min = this.getColumn(colIdx).getWidthLom();
        }
        return min;
    }
}

