/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.merge;

import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractGrid;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractRow;
import java.awt.Point;

public class MergeBlock
implements Cloneable {
    private int _left;
    private int _right;
    private int _top;
    private int _bottom;

    private MergeBlock() {
    }

    public static MergeBlock create(int left, int right, int top, int bottom) {
        MergeBlock mb = new MergeBlock();
        mb.setLeft(left < right ? left : right);
        mb.setRight(left < right ? right : left);
        mb.setTop(top < bottom ? top : bottom);
        mb.setBottom(top < bottom ? bottom : top);
        return mb;
    }

    public Object clone() {
        return MergeBlock.create(this.getLeft(), this.getRight(), this.getTop(), this.getBottom());
    }

    public int getBottom() {
        return this._bottom;
    }

    public void setBottom(int bottom) {
        this._bottom = bottom;
    }

    public int getLeft() {
        return this._left;
    }

    public void setLeft(int left) {
        this._left = left;
    }

    public int getRight() {
        return this._right;
    }

    public void setRight(int right) {
        this._right = right;
    }

    public int getTop() {
        return this._top;
    }

    public void setTop(int top) {
        this._top = top;
    }

    public boolean isFirstCell(Point indexOfCell) {
        return this.isFirstCell(indexOfCell.x, indexOfCell.y);
    }

    public boolean isFirstCell(int rowIdx, int colIdx) {
        return rowIdx == this._top && colIdx == this._left;
    }

    public int getBlockWidthLom(AbstractGrid grid) {
        int w = 0;
        for (int i = this._left; i <= this._right; ++i) {
            w += grid.getColumn(i).getWidthLom();
        }
        return w;
    }

    public int getBlockHeightLom(AbstractGrid grid) {
        int h = 0;
        int lastRowMoreHeight = 0;
        for (int i = this._top; i <= this._bottom; ++i) {
            AbstractRow row = grid.getRow(i);
            int currentHeight = row.getHeightLom();
            h += currentHeight + lastRowMoreHeight;
            int moreTimes = grid.getRowDrawingTimes(row) - 1;
            lastRowMoreHeight = moreTimes > 0 ? currentHeight * moreTimes : 0;
        }
        return h;
    }

    public int getBlockWidth(AbstractGrid grid) {
        int w = 0;
        for (int i = this._left; i <= this._right; ++i) {
            w += grid.getColumn(i).getFeatWidth();
        }
        return w;
    }

    public int getBlockHeight(AbstractGrid grid) {
        int h = 0;
        int lastRowMoreHeight = 0;
        for (int i = this._top; i <= this._bottom; ++i) {
            AbstractRow row = grid.getRow(i);
            int currentHeight = row.getFeatHeight();
            h += currentHeight + lastRowMoreHeight;
            int moreTimes = grid.getRowDrawingTimes(row) - 1;
            lastRowMoreHeight = moreTimes > 0 ? currentHeight * moreTimes : 0;
        }
        return h;
    }

    public int getRowSpan() {
        return this.getBottom() - this.getTop() + 1;
    }

    public int getColSpan() {
        return this.getRight() - this.getLeft() + 1;
    }

    public boolean isInvalid() {
        if (this.getLeft() > this.getRight() || this.getTop() > this.getBottom()) {
            return true;
        }
        return this.getLeft() == this.getRight() && this.getTop() == this.getBottom();
    }

    public boolean is1x1() {
        return this.getLeft() == this.getRight() && this.getTop() == this.getBottom();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{top:");
        sb.append(this.getTop());
        sb.append(";bottom:");
        sb.append(this.getBottom());
        sb.append(";left:");
        sb.append(this.getLeft());
        sb.append(";right:");
        sb.append(this.getRight());
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MergeBlock) {
            MergeBlock another = (MergeBlock)obj;
            if (this.getLeft() == another.getLeft() && this.getRight() == another.getRight() && this.getTop() == another.getTop() && this.getBottom() == another.getBottom()) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = this.getLeft();
        result += this.getRight() * 100;
        result += this.getTop() * 100;
        return result += this.getBottom() * 100;
    }
}

