/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ToolboxGroup;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.toolbox.IToolboxItem;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.xmltrans.IObjectXmlTrans;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class ToolboxLoader {
    private static final Log log = LogFactory.getLog(ToolboxLoader.class);

    private static Element readXml(InputStream is) {
        Element root = null;
        try {
            root = XmlUtil.loadXmlStream(is);
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
        catch (DocumentException e) {
            log.error((Throwable)e);
        }
        return root;
    }

    private static void initWithConfig(Element root, Initialize initer) {
        for (Element nodeGroup : root.elements("Group")) {
            String title = nodeGroup.attributeValue("title");
            ToolboxGroup group = new ToolboxGroup();
            group.setTitle(title);
            initer.initGroup(group);
            for (Element nodeItem : nodeGroup.elements()) {
                String key;
                String classname = nodeItem.attributeValue("classname");
                IToolboxItem item = ToolboxLoader.createItem(classname, key = nodeItem.attributeValue("key"));
                if (item == null) continue;
                initer.initItem(group, item);
            }
        }
    }

    private static IToolboxItem createItem(String classname, String key) {
        Object obj = null;
        if (!StringUtil.isEmptyString(classname)) {
            try {
                obj = Class.forName(classname).newInstance();
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        if (obj instanceof IToolboxItem) {
            IToolboxItem item = obj;
            item.setKey(key);
            return item;
        }
        return null;
    }

    public static ArrayList createXmlTransChain(InputStream config) {
        ArrayList train = new ArrayList();
        Element root = ToolboxLoader.readXml(config);
        if (root != null && "Toolbox".equalsIgnoreCase(root.getName())) {
            InitWhenExecute initer = new InitWhenExecute();
            initer.setList(train);
            ToolboxLoader.initWithConfig(root, initer);
        }
        return train;
    }

    private static class InitWhenExecute
    implements Initialize {
        private List list;

        private InitWhenExecute() {
        }

        public void setList(List list) {
            this.list = list;
        }

        public List getList() {
            return this.list;
        }

        @Override
        public void initGroup(ToolboxGroup group) {
        }

        @Override
        public void initItem(ToolboxGroup group, IToolboxItem item) {
            IObjectXmlTrans oxt = item.getAnObjectFactory().getXmlTrans();
            this.list.add(oxt);
        }
    }

    private static interface Initialize {
        public void initGroup(ToolboxGroup var1);

        public void initItem(ToolboxGroup var1, IToolboxItem var2);
    }
}

