/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.model;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataExtend;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IBind;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IR1DataManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.IR1Page;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.EventListenerList;

public class ReportModel {
    public static final String KEY_DIRTY = "dirty";
    public static final String KEY_PAGE = "page";
    public static final String KEY_DATA = "data";
    public static final String KEY_ADD_ELEMENT = "addElement";
    public static final String KEY_DEL_ELEMENT = "delElement";
    public static final String KEY_RENAME_ELEMENT = "renElement";
    private IR1Page _page;
    private IR1DataManager _dataManager;
    private EventListenerList _listenerList = new EventListenerList();
    private boolean _isDirty;
    private HashMap _extProperty;

    public ReportModel(IR1DataManager dm) {
        this.setDataManager(dm);
    }

    public IR1Page getPage() {
        return this._page;
    }

    public void setPage(IR1Page page) {
        if (this._page != page) {
            IR1Page old = this._page;
            this._page = page;
            this.fireChangeEvent(this, KEY_PAGE, old, this._page);
            this.setDirty(true);
        }
    }

    public List getExistIds(IElement except) {
        ArrayList list = new ArrayList();
        ScanId scan = new ScanId();
        scan.doSthWithElement(this.getPage());
        scan.setList(list);
        scan.setExceptElement(except);
        this.scanContainer(this.getPage(), scan, true);
        return list;
    }

    public IElement getElementById(String id) {
        ScanId scan = new ScanId();
        scan.setAppointId(id);
        scan.doSthWithElement(this.getPage());
        this.scanContainer(this.getPage(), scan, true);
        return scan.getElementAppointedId();
    }

    public void scanContainer(IContainer c, IScanModel scan, boolean isToElement) {
        if (c.getChildrenCount() == 0) {
            return;
        }
        for (IReportObject ro : c.getChildren()) {
            int i;
            if (ro != scan.getExceptElement()) {
                scan.doSthWithElement(ro);
            }
            if (isToElement && ro instanceof ICompositeObject) {
                IElement[] eles = ((ICompositeObject)((Object)ro)).getAllSubElements();
                for (i = 0; i < eles.length; ++i) {
                    if (eles[i] == scan.getExceptElement()) continue;
                    scan.doSthWithElement(eles[i]);
                }
            }
            if (ro instanceof IContainer) {
                this.scanContainer((IContainer)((Object)ro), scan, isToElement);
                continue;
            }
            if (!(ro instanceof ICompositeContainer)) continue;
            IContainer[] ctns = ((ICompositeContainer)((Object)ro)).getSubContainers();
            for (i = 0; i < ctns.length; ++i) {
                this.scanContainer(ctns[i], scan, isToElement);
            }
        }
    }

    public void addChangeListener(PropertyChangeListener l) {
        this._listenerList.add(PropertyChangeListener.class, l);
    }

    public void removeChangeListener(PropertyChangeListener l) {
        this._listenerList.remove(PropertyChangeListener.class, l);
    }

    protected void fireChangeEvent(Object source, String name, Object oldValue, Object newValue) {
        Object[] list = this._listenerList.getListenerList();
        PropertyChangeEvent evt = null;
        for (int i = list.length - 2; i >= 0; i -= 2) {
            if (list[i] != PropertyChangeListener.class) continue;
            if (evt == null) {
                evt = new PropertyChangeEvent(source, name, oldValue, newValue);
            }
            ((PropertyChangeListener)list[i + 1]).propertyChange(evt);
        }
    }

    public void fireRemoveEvent(ElementPath ep) {
        this.fireChangeEvent(this, KEY_DEL_ELEMENT, null, ep);
        this.setDirty(true);
    }

    public void fireRenameEvent(ElementPath ep, String oldId, String newId) {
        this.fireChangeEvent(ep, KEY_RENAME_ELEMENT, oldId, newId);
        this.setDirty(true);
    }

    private void fireDataChangedEvent(PropertyChangeEvent evt) {
        this.fireChangeEvent(evt.getSource(), evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        if (evt.getPropertyName() == "rename") {
            String oldName = (String)evt.getOldValue();
            String newName = ((DataExtend)evt.getNewValue()).getName();
            ScanBindData scan = new ScanBindData(oldName, newName);
            this.scanContainer(this.getPage(), scan, true);
        }
        this.setDirty(true);
    }

    private void fireAddElementEvent(ElementPath ep) {
        this.fireChangeEvent(this, KEY_ADD_ELEMENT, null, ep);
        this.setDirty(true);
    }

    public void addReportObject(ICompositeContainer parentObj, IContainer parent, IReportObject childObj, String layoutParm) {
        if (parentObj == null) {
            parent.addChild(childObj, layoutParm);
        } else {
            parentObj.addChild(parent, childObj);
        }
        this.afterAddReportObject(parent, childObj);
    }

    private void afterAddReportObject(IContainer ctn, IReportObject childObj) {
        this.allotAddedElementId(childObj);
        this.fireAddElementEvent(new ElementPath(childObj));
    }

    private void allotAddedElementId(IReportObject addedObj) {
        this.allotAddedElementIdWithChildren(addedObj);
        if (addedObj instanceof ICompositeObject) {
            IElement[] eles = ((ICompositeObject)((Object)addedObj)).getAllSubElements();
            for (int i = 0; i < eles.length; ++i) {
                this.allotAddedElementIdWithChildren(eles[i]);
            }
        }
    }

    private void allotAddedElementIdWithChildren(IElement ele) {
        IContainer container;
        this.allotElementId(ele);
        if (ele instanceof IContainer && (container = (IContainer)((Object)ele)).getChildrenCount() > 0) {
            for (IReportObject child : container.getChildren()) {
                this.allotAddedElementId(child);
            }
        }
    }

    public boolean removeAllChildren(IContainer container) {
        if (container.getChildrenCount() == 0) {
            return false;
        }
        boolean isSomeRemoved = false;
        List children = container.getChildren();
        for (int i = children.size() - 1; i >= 0; --i) {
            IReportObject child = (IReportObject)children.get(i);
            isSomeRemoved = this.removeReportObject(child);
        }
        return isSomeRemoved;
    }

    public boolean removeReportObject(IReportObject targetObj) {
        this.fireRemoveEvent(new ElementPath(targetObj));
        ElementPath epParent = targetObj.getParent();
        IContainer objParent = (IContainer)epParent.getLastPathComponent();
        if (objParent instanceof IReportObject) {
            objParent.removeChild(targetObj);
        } else {
            ICompositeContainer cc = (ICompositeContainer)epParent.getRootPathComponent();
            cc.removeChild(objParent, targetObj);
        }
        return true;
    }

    public void allotSubElementIdWidthFire(ICompositeObject co, IElement ele) {
        this.allotSubElementId(co, ele);
        ElementPath ep = co.makeElementPath(ele);
        this.fireAddElementEvent(ep);
    }

    public void allotSubElementId(ICompositeObject co, IElement ele) {
        this.allotElementId(ele);
        IElement[] subs = co.getSubSubElements(ele);
        if (subs != null) {
            for (int i = 0; i < subs.length; ++i) {
                this.allotElementId(subs[i]);
            }
        }
    }

    public void allotSubElementId(ICompositeObject co) {
        IElement[] eles = co.getAllSubElements();
        for (int i = 0; i < eles.length; ++i) {
            this.allotElementId(eles[i]);
        }
    }

    private void allotElementId(IElement ele) {
        String id = this.getUniqueId(ele);
        ele.setId(id);
    }

    private String getUniqueId(IElement ele) {
        StringBuilder sb;
        List list = this.getExistIds(null);
        int i = 1;
        do {
            sb = new StringBuilder(ele.getIdPrefix());
            sb.append(i++);
        } while (list.contains(sb.toString()));
        return sb.toString();
    }

    public static ReportModel createModel(IR1Page page, IR1DataManager dm) {
        ReportModel model = new ReportModel(dm);
        model._page = page;
        model.allotElementId(page);
        model.fireChangeEvent(model, KEY_PAGE, null, page);
        return model;
    }

    private void setDataManager(IR1DataManager dm) {
        this._dataManager = dm;
        this._dataManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ReportModel.this.fireDataChangedEvent(evt);
            }
        });
    }

    public IR1DataManager getDataManager() {
        return this._dataManager;
    }

    public boolean isDirty() {
        return this._isDirty;
    }

    public void setDirty(boolean isDirty) {
        this._isDirty = isDirty;
        this.fireChangeEvent(this, KEY_DIRTY, null, isDirty);
    }

    public void clearPage() {
        List children = this.getPage().getChildren();
        for (int i = children.size() - 1; i >= 0; --i) {
            IReportObject ro = (IReportObject)children.get(i);
            this.removeReportObject(ro);
        }
        this.fireChangeEvent(this, KEY_PAGE, null, this.getPage());
    }

    private HashMap getExtProStore() {
        if (this._extProperty == null) {
            this._extProperty = new HashMap();
        }
        return this._extProperty;
    }

    public void setExtendProperty(String key, Object value) {
        this.getExtProStore().put(key, value);
    }

    public Object getExtendProperty(String key) {
        return this.getExtProStore().get(key);
    }

    private static class ScanBindData
    implements IScanModel {
        private String oldName;
        private String newName;

        public ScanBindData(String oldOne, String newOne) {
            this.oldName = oldOne;
            this.newName = newOne;
        }

        @Override
        public void doSthWithElement(IElement ele) {
            IBind bind;
            if (ele instanceof IBind && StringUtil.equals(this.oldName, (bind = (IBind)((Object)ele)).getDataSource().getDs())) {
                bind.getDataSource().setDs(this.newName);
            }
        }

        @Override
        public IElement getExceptElement() {
            return null;
        }
    }

    private static class ScanId
    implements IScanModel {
        private List list;
        private IElement except;
        private String id;
        private IElement element;

        private ScanId() {
        }

        public void setList(List list) {
            this.list = list;
        }

        public void setExceptElement(IElement ele) {
            this.except = ele;
        }

        public void setAppointId(String id) {
            this.id = id;
        }

        public IElement getElementAppointedId() {
            return this.element;
        }

        @Override
        public void doSthWithElement(IElement ele) {
            if (this.list != null) {
                this.list.add(ele.getId());
            }
            if (this.id != null && this.id.equals(ele.getId())) {
                this.element = ele;
            }
        }

        @Override
        public IElement getExceptElement() {
            return this.except;
        }
    }

    public static interface IScanModel {
        public void doSthWithElement(IElement var1);

        public IElement getExceptElement();
    }
}

