/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io;

import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataExtend;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IR1DataManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportModel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IDataXmlTrans;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IR1XmlReader;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IR1XmlRecursiveReader;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.StyleCache;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.xmltrans.IObjectXmlTrans;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.PrintFormAp;
import kd.bos.metadata.form.PrintMetadata;
import kd.bos.metadata.print.control.BaseControl;
import kd.bos.metadata.print.control.DataCell;
import kd.bos.metadata.print.control.DataGrid;
import kd.bos.metadata.print.control.DataRow;

public abstract class AbstractR1XmlReader
implements IR1XmlRecursiveReader,
IR1XmlReader {
    private static final String S_S = "%s.%s";
    private static final Log log = LogFactory.getLog(AbstractR1XmlReader.class);
    private StyleCache _styleCache = new StyleCache();
    private List _xmlTransChain;
    private String _readingWarning;

    protected StyleCache getStyleCache() {
        return this._styleCache;
    }

    @Override
    public void setXmlTransChain(List list) {
        this._xmlTransChain = list;
    }

    public int parseToInt(String value) {
        if (StringUtils.isBlank((CharSequence)value) || "mm".equals(value)) {
            return 0;
        }
        String cutValue = value.substring(0, value.length() - 2);
        Float v = Float.valueOf(Float.parseFloat(cutValue));
        return (int)(v.floatValue() * 10.0f);
    }

    @Override
    public ReportModel fromXml(PrintMetadata meta, IDataXmlTrans dataXmlTrans) throws R1Exception {
        this._readingWarning = null;
        this.getStyleCache().cacheStyleFromMeta(meta);
        ReportModel model = new ReportModel(this.createDataManager());
        dataXmlTrans.fromXml(meta, model.getDataManager());
        this.parseModel(model, meta);
        this.parseOthers(model, meta);
        this.initDataCellDs(meta);
        this.scanBindFields(meta.getItems(), model.getDataManager());
        return model;
    }

    private void scanBindFields(List<BaseControl<?>> controls, IR1DataManager dm) {
        if (controls == null || controls.size() == 0) {
            return;
        }
        String ds = null;
        String bindField = null;
        String conbineField = "";
        DataExtend[] dataExtends = dm.getDataExtends();
        for (DataExtend ext : dataExtends) {
            if (StringUtils.isNotBlank((CharSequence)ext.getParentName())) {
                ext.addUsedField(String.format(S_S, ext.getName(), "id"));
            }
            ext.addUsedField("id");
        }
        for (BaseControl baseControl : controls) {
            String bindDs;
            DataExtend ext;
            if (baseControl instanceof PrintFormAp || StringUtils.isBlank((CharSequence)(bindDs = baseControl.getDataSource()))) continue;
            try {
                Map mapData = (Map)SerializationUtils.fromJsonString((String)bindDs, Map.class);
                ds = ObjectUtils.isEmpty(mapData.get("cuskey")) ? (String)mapData.get("key") : (String)mapData.get("cuskey");
            }
            catch (Exception e) {
                ds = bindDs;
            }
            ext = dm.getDataExtend(ds);
            bindField = baseControl.getBindField();
            conbineField = baseControl.getCombineField();
            if (StringUtils.isBlank((CharSequence)ds) || StringUtils.isBlank((CharSequence)conbineField) && StringUtils.isBlank((CharSequence)bindField) || ext == null) continue;
            String bindType = baseControl.getBindType();
            if ("combination".equals(bindType) || baseControl instanceof DataCell && ((DataCell)baseControl).getCellType().equalsIgnoreCase("combination")) {
                String[] fields;
                String p = "\"([^\"]*)\"";
                Pattern pa = Pattern.compile(p);
                Matcher ma = pa.matcher(conbineField);
                while (ma.find()) {
                    conbineField = conbineField.replace(ma.group(), "");
                }
                for (String item : fields = conbineField.split("\\s+")) {
                    if (item.contains("|") || !StringUtils.isNotBlank((CharSequence)item)) continue;
                    if (StringUtils.isNotBlank((CharSequence)ext.getParentName())) {
                        ext.addUsedField(String.format(S_S, ext.getName(), item));
                        continue;
                    }
                    ext.addUsedField(item);
                }
            } else if (StringUtils.isNotBlank((CharSequence)ext.getParentName())) {
                if (bindField.endsWith(".seq")) {
                    ext.addUsedField(bindField);
                } else {
                    ext.addUsedField(String.format(S_S, ext.getName(), bindField));
                }
            } else {
                ext.addUsedField(bindField);
            }
            if (bindField == null) continue;
            String[] splitField = bindField.split("\\.");
            if (splitField.length == 3) {
                if (StringUtils.isBlank((CharSequence)ext.getParentName())) {
                    ext.addUsedField(splitField[0] + ".id");
                    ext.addUsedField(splitField[0] + "." + splitField[1] + ".id");
                    continue;
                }
                ext.addUsedField(String.format(S_S, ext.getName(), splitField[0] + ".id"));
                ext.addUsedField(String.format(S_S, ext.getName(), splitField[0] + "." + splitField[1] + ".id"));
                continue;
            }
            if (splitField.length != 4) continue;
            if (StringUtils.isBlank((CharSequence)ext.getParentName())) {
                ext.addUsedField(splitField[0] + ".id");
                ext.addUsedField(splitField[0] + "." + splitField[1] + ".id");
                ext.addUsedField(splitField[0] + "." + splitField[1] + "." + splitField[2] + ".id");
                continue;
            }
            ext.addUsedField(String.format(S_S, ext.getName(), splitField[0] + ".id"));
            ext.addUsedField(String.format(S_S, ext.getName(), splitField[0] + "." + splitField[1] + ".id"));
            ext.addUsedField(String.format(S_S, ext.getName(), splitField[0] + "." + splitField[1] + "." + splitField[2] + ".id"));
        }
    }

    private void initDataCellDs(PrintMetadata meta) {
        HashMap dataSource = new HashMap();
        HashMap rowDataSource = new HashMap();
        List items = meta.getItems();
        items.forEach(item -> {
            if (item instanceof DataGrid) {
                dataSource.put(item.getId(), item.getDataSource());
            }
        });
        items.forEach(item -> {
            if (item instanceof DataRow) {
                String dataGridID = item.getParentId();
                String ds = (String)dataSource.get(dataGridID);
                rowDataSource.put(item.getId(), ds);
            }
        });
        items.forEach(item -> {
            if (item instanceof DataCell) {
                String rowID = item.getParentId();
                if (StringUtils.isNotBlank((CharSequence)item.getBindField()) && StringUtils.isBlank((CharSequence)item.getDataSource())) {
                    item.setDataSource((String)rowDataSource.get(rowID));
                }
            }
        });
    }

    private void reduceUsedFields(IR1DataManager dm) {
        DataExtend[] dataExtends = dm.getDataExtends();
        DataExtend mainExt = dataExtends[0];
        for (int i = 1; i < dataExtends.length; ++i) {
            dataExtends[i].getUsedFields().forEach(field -> mainExt.addUsedField((String)field));
        }
    }

    protected abstract void parseModel(ReportModel var1, PrintMetadata var2) throws R1Exception;

    protected abstract void parseOthers(ReportModel var1, PrintMetadata var2) throws R1Exception;

    @Override
    public IReportObject parseObject(IR1XmlRecursiveReader reader, BaseControl<?> node, StyleCache styleCache, PrintMetadata meta) throws R1Exception {
        if (this._xmlTransChain == null) {
            return null;
        }
        for (Object objTrans : this._xmlTransChain) {
            IObjectXmlTrans trans;
            IReportObject ro;
            if (!(objTrans instanceof IObjectXmlTrans) || (ro = (trans = (IObjectXmlTrans)objTrans).fromXml(reader, node, styleCache)) == null) continue;
            return ro;
        }
        return null;
    }

    @Override
    public String getWarning() {
        return this._readingWarning;
    }
}

