/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io;

import com.kingdee.bos.ctrl.common.ui.select.IObjectSelector;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataExtend;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataParamSource;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IR1DataManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IDataXmlTrans;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSortItem;
import com.kingdee.bos.ctrl.reportone.r1.print.data.SystemR1PrintDataSortItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.form.PrintMetadata;
import kd.bos.metadata.print.control.BaseControl;
import kd.bos.metadata.print.control.DataRow;
import org.apache.commons.lang3.StringUtils;

public class DataXmlTrans
implements IDataXmlTrans {
    private static final Log log = LogFactory.getLog(DataXmlTrans.class);
    private static final String IS_MAIN_DS = "ismainds";
    private static final String PARAM = "param";
    private IObjectSelector _objectSelector;
    public static final String KEY_DATA_SORT = "dataExtend_sorts";

    public void setObjectSelector(IObjectSelector objectSelector) {
        this._objectSelector = objectSelector;
    }

    @Override
    public void fromXml(PrintMetadata meta, IR1DataManager dm) {
        StringBuilder invalidData = new StringBuilder();
        Map<String, List<R1PrintDataSortItem>> sortMap = this.buildSordFields(meta);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityTypeById((String)meta.getEntityId());
        Map entities = mainEntityType.getAllEntities();
        for (EntityType et : entities.values()) {
            List<R1PrintDataSortItem> sorts = null;
            if (sortMap.containsKey(et.getName())) {
                sorts = sortMap.get(et.getName());
            }
            this.dataExtFromMeta(mainEntityType, sorts, (IDataEntityType)et, dm);
        }
        String refQueryDataSource = meta.getRootAp().getRefQueryDataSource();
        if (StringUtils.isNotBlank((CharSequence)refQueryDataSource)) {
            List queryDataSource = (List)SerializationUtils.fromJsonString((String)refQueryDataSource, List.class);
            HashSet<String> unionFields = new HashSet<String>();
            String mainField = "";
            String joinField = "";
            for (Map mp : queryDataSource) {
                String queryEntityNumber = mp.get("customnumber") == null ? mp.get("number").toString() : mp.get("customnumber").toString();
                Object fields = mp.get("unionfield");
                String importField = "";
                if (!ObjectUtils.isEmpty(fields)) {
                    try {
                        Map mapfields = (Map)SerializationUtils.fromJsonString((String)fields.toString(), Map.class);
                        if (mapfields.get("importunionfield") != null) {
                            joinField = (String)mapfields.get("importunionfield");
                        }
                        if (mapfields.get("mainunionfield") != null) {
                            mainField = (String)mapfields.get("mainunionfield");
                        }
                    }
                    catch (Exception e) {
                        joinField = (String)fields;
                        mainField = (String)fields;
                    }
                    importField = mainField + "&" + joinField;
                }
                Object filter = mp.get("filtercondition");
                FilterCondition filterCondition = null;
                if (!ObjectUtils.isEmpty(filter)) {
                    filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter.toString(), FilterCondition.class);
                }
                this.queryEntityDataExt(mainEntityType, queryEntityNumber, importField, filterCondition, dm);
                if (!StringUtils.isNotEmpty((CharSequence)mainField)) continue;
                unionFields.add(mainField);
                for (EntityType et : entities.values()) {
                    DataExtend dataExtend = dm.getDataExtend(et.getName());
                    dataExtend.setUnionFields(unionFields);
                }
            }
        }
        this.customDataExt(meta, mainEntityType, dm);
        this.workflowDataExt(mainEntityType, "workflow.approveline", dm);
        this.attachDataExt(mainEntityType, "attachpanel", dm);
        if (invalidData.length() != 0) {
            invalidData.insert(0, ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u4ee5\u4e0b\u6570\u636e\u6e90\uff1a", (String)"DataXmlTrans_0", (String)"bos-print-engine", (Object[])new Object[0]));
            throw new RuntimeException(invalidData.toString());
        }
    }

    private void queryEntityDataExt(MainEntityType mainEntityType, String queryEntityNumber, String mainField, FilterCondition filterCondition, IR1DataManager dm) {
        if (StringUtils.isNotBlank((CharSequence)queryEntityNumber)) {
            String importNumber = queryEntityNumber;
            if (queryEntityNumber.contains(":")) {
                importNumber = StringUtils.substringBefore((String)queryEntityNumber, (String)":");
            }
            MainEntityType queryEntity = EntityMetadataCache.getDataEntityType((String)importNumber);
            String dsType = "";
            dsType = queryEntity instanceof QueryEntityType ? "7" : "9";
            DataExtend queryHeadExt = this.relateDataExt(mainEntityType, queryEntityNumber, mainField, filterCondition, dsType);
            queryHeadExt.setQueryEntityId(importNumber);
            Object dataObj = null;
            if (this._objectSelector != null) {
                dataObj = this._objectSelector.getObject(queryEntityNumber);
            }
            dm.setListenerUseful(false);
            dm.addData(queryHeadExt, dataObj);
            dm.setListenerUseful(true);
        }
    }

    private void customDataExt(PrintMetadata meta, MainEntityType mainEntityType, IR1DataManager dm) {
        String customDs = meta.getRootAp().getCustomDataSource();
        if (StringUtils.isNotBlank((CharSequence)customDs)) {
            List dsList = new ArrayList();
            try {
                Map mapData = (Map)SerializationUtils.fromJsonString((String)customDs, Map.class);
                Object dsEntry = mapData.get("dsentry");
                if (dsEntry != null) {
                    dsList = (List)mapData.get("dsentry");
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
            for (Map md : dsList) {
                Object mainDs = md.get(IS_MAIN_DS);
                boolean isMainDs = false;
                if (!ObjectUtils.isEmpty(mainDs)) {
                    isMainDs = (Boolean)md.get(IS_MAIN_DS);
                }
                md.get(IS_MAIN_DS);
                String name = (String)md.get("dsnumber");
                DataExtend ext = new DataExtend();
                ext.setName(name);
                ext.setAlias(name);
                ext.setInfo(name);
                ext.setMainDS(isMainDs);
                Object dataObj = null;
                if (this._objectSelector != null) {
                    dataObj = this._objectSelector.getObject(name);
                }
                String paramName = PARAM + name;
                DataParamSource paramSource = new DataParamSource();
                paramSource.setParamName(paramName);
                paramSource.setReferenceDataName(mainEntityType.getName());
                if (mainEntityType.getPrimaryKey() != null) {
                    paramSource.setValue(mainEntityType.getPrimaryKey().getName());
                } else {
                    paramSource.setValue("id");
                }
                ext.getParamSources().put(paramName, paramSource);
                dm.setListenerUseful(false);
                dm.addData(ext, dataObj);
                dm.setListenerUseful(true);
            }
        }
    }

    private void workflowDataExt(MainEntityType mainEntityType, String name, IR1DataManager dm) {
        DataExtend approveLineExt = this.relateDataExt(mainEntityType, "workflow.approveline", "workflow.approveline");
        Object dataObj = null;
        if (this._objectSelector != null) {
            dataObj = this._objectSelector.getObject(name);
        }
        dm.setListenerUseful(false);
        dm.addData(approveLineExt, dataObj);
        dm.setListenerUseful(true);
        DataExtend activityExt = this.relateDataExt(mainEntityType, "workflow.activity", "8");
        if (this._objectSelector != null) {
            dataObj = this._objectSelector.getObject(name);
        }
        dm.setListenerUseful(false);
        dm.addData(activityExt, dataObj);
        dm.setListenerUseful(true);
    }

    private void attachDataExt(MainEntityType mainEntityType, String name, IR1DataManager dm) {
        DataExtend dataExtend = this.relateDataExt(mainEntityType, "attachpanel", "attachpanel");
        Object dataObj = null;
        if (this._objectSelector != null) {
            dataObj = this._objectSelector.getObject(name);
        }
        dm.setListenerUseful(false);
        dm.addData(dataExtend, dataObj);
        dm.setListenerUseful(true);
    }

    private DataExtend relateDataExt(MainEntityType mainEntityType, String name, String dsType) {
        return this.relateDataExt(mainEntityType, name, null, null, dsType);
    }

    private DataExtend relateDataExt(MainEntityType mainEntityType, String name, String joinField, FilterCondition filterCondition, String dsType) {
        DataExtend ext = new DataExtend();
        ext.setName(name);
        ext.setAlias(name);
        ext.setInfo(name);
        ext.setDsType(dsType);
        String paramName = PARAM + name;
        DataParamSource paramSource = new DataParamSource();
        paramSource.setParamName(paramName);
        paramSource.setReferenceDataName(mainEntityType.getName());
        if (StringUtils.isNotBlank((CharSequence)joinField)) {
            paramSource.setValue(joinField);
        } else if (mainEntityType.getPrimaryKey() != null) {
            paramSource.setValue(mainEntityType.getPrimaryKey().getName());
        } else {
            paramSource.setValue("id");
        }
        if (filterCondition != null) {
            ext.setFilterCondition(filterCondition);
        }
        ext.getParamSources().put(paramName, paramSource);
        return ext;
    }

    private void dataExtFromMeta(MainEntityType mainEntityType, List<R1PrintDataSortItem> sorts, IDataEntityType metaData, IR1DataManager dm) {
        String name = metaData.getName();
        DataExtend ext = new DataExtend();
        ext.setName(name);
        ext.setAlias(name);
        ext.setInfo(name);
        ext.setQueryEntityId(mainEntityType.getName());
        Object dataObj = null;
        if (this._objectSelector != null) {
            dataObj = this._objectSelector.getObject(name);
        }
        this.paramFromMeta(ext, metaData);
        if (sorts != null && !sorts.isEmpty()) {
            ext.setProperty(KEY_DATA_SORT, sorts);
        }
        dm.setListenerUseful(false);
        dm.addData(ext, dataObj);
        dm.setListenerUseful(true);
    }

    private Map<String, List<R1PrintDataSortItem>> buildSordFields(PrintMetadata meta) {
        HashMap<String, List<R1PrintDataSortItem>> map = new HashMap<String, List<R1PrintDataSortItem>>();
        for (BaseControl control : meta.getItems()) {
            if (!(control instanceof DataRow)) continue;
            DataRow row = (DataRow)control;
            String rowType = row.getRowType();
            String groupField = row.getGroupField();
            if (!rowType.equalsIgnoreCase("startgroup") || !StringUtils.isNotEmpty((CharSequence)groupField)) continue;
            List<SystemR1PrintDataSortItem> sortInfo = null;
            String ds = control.getDataSource();
            if (map.containsKey(ds)) {
                sortInfo = (List)map.get(ds);
            } else {
                sortInfo = new ArrayList();
                map.put(ds, sortInfo);
            }
            SystemR1PrintDataSortItem item = new SystemR1PrintDataSortItem(groupField, 0, true);
            sortInfo.add(item);
        }
        return map;
    }

    private void paramFromMeta(DataExtend ext, IDataEntityType metaData) {
        String paramName = PARAM + metaData.getName();
        if (!ext.getParamSources().containsKey(paramName)) {
            IDataEntityType parent = metaData.getParent();
            if (parent != null) {
                DataParamSource paramSource = new DataParamSource();
                paramSource.setParamName(paramName);
                paramSource.setReferenceDataName(parent.getName());
                if (metaData instanceof SubEntryEntity) {
                    paramSource.setValue(((SubEntryEntity)metaData).getEntryPkFieldName());
                } else if (parent.getPrimaryKey() != null) {
                    paramSource.setValue(parent.getPrimaryKey().getName());
                } else {
                    paramSource.setValue("id");
                }
                ext.setDsType("2");
                ext.getParamSources().put(paramName, paramSource);
            } else {
                ext.setDsType("1");
                ext.setMainDS(true);
            }
        }
    }

    private static DataParamSource getParamSourceFromList(List<DataParamSource> list, String name) {
        for (DataParamSource dps : list) {
            if (!StringUtil.equals(dps.getName(), name)) continue;
            return dps;
        }
        return null;
    }
}

