/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.xmltrans;

import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.factory.IAnObjectFactory;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IR1XmlRecursiveReader;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.StyleCache;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.xmltrans.IObjectXmlTrans;
import kd.bos.metadata.print.control.BaseControl;

public abstract class AbstractObjectXmlTrans
implements IObjectXmlTrans {
    protected IR1XmlRecursiveReader r1Reader;
    private StyleCache styleCache;
    private IAnObjectFactory objFactory;

    protected IAnObjectFactory getFactory() {
        return this.objFactory;
    }

    protected StyleCache getStyleCache() {
        return this.styleCache;
    }

    public AbstractObjectXmlTrans(IAnObjectFactory factory) {
        this.objFactory = factory;
    }

    @Override
    public IReportObject fromXml(IR1XmlRecursiveReader reader, BaseControl<?> node, StyleCache styleCache) throws R1Exception {
        if (this.isMatch(node)) {
            this.r1Reader = reader;
            this.styleCache = styleCache;
            return this.fromXml(node);
        }
        return null;
    }

    protected void loadElementCommon(BaseControl<?> nodeElement, IElement ele) {
        ele.setId(nodeElement.getKey());
        String styleId = nodeElement.getId();
        StyleAttributes sa = this.styleCache.getStyle(styleId);
        if (sa != null) {
            ele.setStyleAttribute(Styles.getSA(sa));
        }
        boolean isHidden = nodeElement.isHidden();
        ele.setHide(isHidden);
    }

    protected void loadObjectCommon(BaseControl<?> nodeRo, IReportObject ro) {
        this.loadObjectLocation(nodeRo, ro);
        this.loadObjectOther(nodeRo, ro);
        this.loadElementCommon(nodeRo, ro);
    }

    protected void loadObjectLocation(BaseControl<?> nodeRo, IReportObject ro) {
        ro.setXLom(this.parseInt(nodeRo.getX().toString()));
        ro.setYLom(this.parseInt(nodeRo.getY().toString()));
        String w = nodeRo.getWidth().toString();
        String h = nodeRo.getHeight().toString();
        ro.setWidthLom(this.parseInt(w));
        ro.setHeightLom(this.parseInt(h));
    }

    protected int parseInt(String value) {
        if ("0".equals(value) || !value.contains("mm")) {
            return 0;
        }
        String cutValue = value.substring(0, value.length() - 2);
        Float v = Float.valueOf(Float.parseFloat(cutValue));
        return (int)(v.floatValue() * 10.0f);
    }

    protected abstract boolean isMatch(BaseControl<?> var1);

    protected abstract IReportObject fromXml(BaseControl<?> var1) throws R1Exception;

    protected abstract void loadObjectOther(BaseControl<?> var1, IReportObject var2);
}

