/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.script;

import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.script.miniscript.ScriptContext;
import com.kingdee.bos.ctrl.script.miniscript.exec.IScriptObjectDelegate;
import com.kingdee.bos.ctrl.script.miniscript.exec.SystemObject;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.dom4j.Element;

public class ScriptObjectFactory {
    private static final Log log = LogFactory.getLog(ScriptObjectFactory.class);
    private static final String CONFIGURE_FILE = "/ScriptObjectConfig.xml";
    private static ScriptObjectFactory instance;
    private HashMap configures = new HashMap();

    private ScriptObjectFactory() {
        try (InputStream ins = this.getClass().getResourceAsStream(CONFIGURE_FILE);){
            Element e = XmlUtil.loadXmlStream(ins);
            List children = e.elements("Configure");
            int count = children.size();
            for (int i = 0; i < count; ++i) {
                Element child = (Element)children.get(i);
                this.configures.put(child.attributeValue("type"), child.attributeValue("allowMethods"));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ScriptObjectFactory getInstance() {
        Class<ScriptObjectFactory> clazz = ScriptObjectFactory.class;
        synchronized (ScriptObjectFactory.class) {
            if (instance == null) {
                try {
                    instance = new ScriptObjectFactory();
                }
                catch (Exception ex) {
                    log.info("load script object configure...", (Object)ex);
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return null;
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public SystemObject makeScriptObject(Object customSysObj, Object currentObj, ScriptContext ctx) {
        if (currentObj == null) {
            throw new RuntimeException("object is null.");
        }
        return new R1ScriptSystemObject(ctx, currentObj, customSysObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method checkAllowedMethod(String name, List params, Object realObject) {
        Class<?> cls = realObject.getClass();
        Method method = null;
        HashMap hashMap = this.configures;
        synchronized (hashMap) {
            Object obj = this.configures.get(cls.getName());
            HashSet<String> allowMethods = null;
            if (obj != null) {
                if (obj instanceof HashMap) {
                    return ScriptObjectFactory.restoreMethod((HashMap)obj, name, params);
                }
                allowMethods = new HashSet<String>();
                String[] ss = ((String)obj).split(",");
                for (int i = 0; i < ss.length; ++i) {
                    allowMethods.add(ss[i]);
                }
            }
            HashMap allowedMethodsMap = new HashMap();
            Method[] methods = cls.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (allowMethods != null && !allowMethods.contains(methods[i].getName())) continue;
                ScriptObjectFactory.storeMethod(allowedMethodsMap, methods[i].getName(), methods[i]);
            }
            this.configures.put(cls.getName(), allowedMethodsMap);
            method = ScriptObjectFactory.restoreMethod(allowedMethodsMap, name, params);
        }
        if (method == null) {
            throw new RuntimeException("The method is not supported or is not allowed to be called\uff0eobject class:" + cls);
        }
        return method;
    }

    private static void storeMethod(HashMap methodsMap, String name, Method method) {
        if (methodsMap.containsKey(name)) {
            Object objMethods = methodsMap.get(name);
            if (objMethods instanceof Method) {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(objMethods);
                list.add(method);
                methodsMap.put(name, list);
            } else {
                ((ArrayList)objMethods).add(method);
            }
        } else {
            methodsMap.put(name, method);
        }
    }

    private static Method restoreMethod(HashMap methodsMap, String name, List params) {
        Object objMethods = methodsMap.get(name);
        if (objMethods == null) {
            return null;
        }
        if (objMethods instanceof Method) {
            return ScriptObjectFactory.checkParam((Method)objMethods, params);
        }
        ArrayList list = (ArrayList)objMethods;
        for (int i = 0; i < list.size(); ++i) {
            Method method = ScriptObjectFactory.checkParam((Method)list.get(i), params);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    private static Method checkParam(Method method, List params) {
        Class<?>[] paramClss = method.getParameterTypes();
        if (paramClss.length == params.size()) {
            boolean ok = true;
            for (int j = 0; j < paramClss.length; ++j) {
                if (params.get(j) == null) continue;
                if (paramClss[j].isPrimitive()) {
                    if (params.get(j).getClass() == ScriptObjectFactory.getPrimitiveType(paramClss[j])) continue;
                    ok = false;
                    break;
                }
                if (paramClss[j].isAssignableFrom(params.get(j).getClass())) continue;
                ok = false;
                break;
            }
            if (ok) {
                return method;
            }
        }
        return null;
    }

    private static Class getPrimitiveType(Class cls) {
        if (cls == Integer.TYPE) {
            return Integer.class;
        }
        if (cls == Float.TYPE) {
            return Float.class;
        }
        if (cls == Double.TYPE) {
            return Double.class;
        }
        if (cls == Boolean.TYPE) {
            return Boolean.class;
        }
        if (cls == Long.TYPE) {
            return Long.class;
        }
        if (cls == Short.TYPE) {
            return Short.class;
        }
        if (cls == Byte.TYPE) {
            return Byte.class;
        }
        if (cls == Character.TYPE) {
            return Character.class;
        }
        throw new RuntimeException("Impossible");
    }

    private class R1ScriptSystemObject
    extends SystemObject
    implements IScriptObjectDelegate {
        private Object realObject;
        private Object sysObjEx;

        public R1ScriptSystemObject(ScriptContext ctx, Object realObject) {
            this(ctx, realObject, null);
        }

        public R1ScriptSystemObject(ScriptContext ctx, Object realObject, Object sysObjEx) {
            super(ctx);
            this.realObject = realObject;
            this.sysObjEx = sysObjEx;
        }

        @Override
        public Object invoke(String name, List params, boolean forceMethod) {
            Method method = null;
            Object implObj = null;
            try {
                method = ScriptObjectFactory.this.checkAllowedMethod(name, params, this.sysObjEx);
                implObj = this.sysObjEx;
            }
            catch (RuntimeException e) {
                log.info(e.getMessage());
            }
            if (method == null) {
                method = ScriptObjectFactory.this.checkAllowedMethod(name, params, this.realObject);
                implObj = this.realObject;
            }
            Object[] args = params.toArray();
            if (method == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("\u627e\u4e0d\u5230\u5408\u9002\u7684\u811a\u672c\u51fd\u6570\uff1a");
                sb.append(name);
                sb.append("(");
                for (int i = 0; i < args.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(args[i].getClass().getName());
                }
                sb.append(")");
                log.debug(sb.toString());
                return null;
            }
            try {
                return method.invoke(implObj, args);
            }
            catch (Exception ex) {
                Throwable eex = ex;
                if (ex instanceof InvocationTargetException) {
                    eex = ((InvocationTargetException)ex).getCause();
                }
                throw new RuntimeException(eex);
            }
        }
    }
}

