/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.Constant;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.BeanProperty;
import java.lang.reflect.Method;
import java.util.ArrayList;

public final class BeanUtil {
    public static String makePropertyName(Method mtdGetSet) {
        StringBuilder sb = new StringBuilder(mtdGetSet.getName().substring(3));
        sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
        return sb.toString();
    }

    public static Method findSetter(Method getter) throws SecurityException {
        Method setter;
        String propName = BeanUtil.removeGetterPrefix(getter.getName());
        if (propName == null) {
            return null;
        }
        Class[] argTypes = new Class[]{getter.getReturnType()};
        try {
            setter = getter.getDeclaringClass().getMethod("set" + propName, argTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        if (setter.getReturnType() != Void.TYPE) {
            return null;
        }
        if (setter.getModifiers() != getter.getModifiers()) {
            return null;
        }
        return setter;
    }

    public static String removeGetterPrefix(String mtdName) {
        int prefixLen;
        if (mtdName.startsWith("get")) {
            prefixLen = 3;
        } else if (mtdName.startsWith("is")) {
            prefixLen = 2;
        } else {
            return null;
        }
        if (mtdName.length() == prefixLen) {
            return null;
        }
        if (!Character.isUpperCase(mtdName.charAt(prefixLen))) {
            return null;
        }
        return mtdName.substring(prefixLen);
    }

    public static BeanProperty[] makeProperties(Class cls) {
        ArrayList<BeanProperty> propList = new ArrayList<BeanProperty>();
        Method[] mtds = cls.getMethods();
        for (int i = 0; i < mtds.length; ++i) {
            BeanProperty prop = BeanUtil.makeProperty(mtds[i]);
            if (prop == null) continue;
            propList.add(prop);
        }
        BeanProperty[] props = new BeanProperty[propList.size()];
        return propList.toArray(props);
    }

    public static BeanProperty[] makeProperties(Class cls, String[] getNames) throws SecurityException, NoSuchMethodException {
        BeanProperty[] props = new BeanProperty[getNames.length];
        for (int i = 0; i < getNames.length; ++i) {
            BeanProperty prop;
            Method mtd = cls.getMethod(getNames[i], Constant.NULL_CLASS_ARRAY);
            props[i] = prop = BeanUtil.makeProperty(mtd);
        }
        return props;
    }

    public static BeanProperty makeProperty(Method getter) {
        int mdf = getter.getModifiers();
        if ((mdf & 1) != 1 || (mdf & 8) == 8) {
            return null;
        }
        Method setter = BeanUtil.findSetter(getter);
        if (setter == null) {
            return null;
        }
        BeanProperty prop = new BeanProperty();
        prop.setName(BeanUtil.makePropertyName(setter));
        prop.setType(getter.getReturnType());
        prop.setGetter(getter);
        prop.setSetter(setter);
        return prop;
    }
}

