/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.barcode;

import com.kingdee.bos.ctrl.reportone.r1.print.barcode.CustomTextPainter;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.painter.BarcodeContext;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.painter.GraphicsForBarcode;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.jbarcode.JBarcode;
import org.jbarcode.encode.BarcodeEncoder;
import org.jbarcode.encode.CodabarEncoder;
import org.jbarcode.encode.Code11Encoder;
import org.jbarcode.encode.Code128Encoder;
import org.jbarcode.encode.Code39Encoder;
import org.jbarcode.encode.Code39ExtEncoder;
import org.jbarcode.encode.Code93Encoder;
import org.jbarcode.encode.Code93ExtEncoder;
import org.jbarcode.encode.EAN13Encoder;
import org.jbarcode.encode.EAN8Encoder;
import org.jbarcode.encode.Interleaved2of5Encoder;
import org.jbarcode.encode.InvalidAtributeException;
import org.jbarcode.encode.MSIPlesseyEncoder;
import org.jbarcode.encode.PostNetEncoder;
import org.jbarcode.encode.Standard2of5Encoder;
import org.jbarcode.encode.UPCAEncoder;
import org.jbarcode.encode.UPCEEncoder;
import org.jbarcode.paint.BaseLineTextPainter;
import org.jbarcode.paint.EAN13TextPainter;
import org.jbarcode.paint.EAN8TextPainter;
import org.jbarcode.paint.HeightCodedPainter;
import org.jbarcode.paint.TextPainter;
import org.jbarcode.paint.UPCATextPainter;
import org.jbarcode.paint.UPCETextPainter;
import org.jbarcode.paint.WideRatioCodedPainter;
import org.jbarcode.paint.WidthCodedPainter;
import org.jbarcode.util.ImageUtil;

public class BarCodeGeneraterUtil {
    private static final Log log = LogFactory.getLog(BarCodeGeneraterUtil.class);
    private static final String BAR_HEIGHT = "barHeight";
    private static String CODE128 = "code128";
    private static String CODE39 = "code39";
    private static String CODE11 = "code11";
    private static String CODE39EXT = "code39-ext";
    private static String CODE93 = "code93";
    private static String CODE93EXT = "code93-ext";
    private static String EAN13 = "ean-13";
    private static String EAN8 = "ean-8";
    private static String CODABAR = "codabar";
    private static String Interleaved2of5 = "itf";
    private static String MSI = "msi";
    private static String POSTNET = "postnet";
    private static String Standard2of5 = "standard2of5";
    private static String UPCA = "upc-a";
    private static String UPCE = "upc-e";

    public static byte[] generateBarcodePicture(String barcode, String type, Map<String, Object> config) throws InvalidAtributeException, IOException {
        double height;
        if (type == null || "".equals(type)) {
            type = CODE128;
        }
        JBarcode localJBarcode = null;
        if (type.equals(CODE128)) {
            localJBarcode = new JBarcode((BarcodeEncoder)Code128Encoder.getInstance(), WidthCodedPainter.getInstance(), (TextPainter)CustomTextPainter.getInstance());
            localJBarcode.setShowCheckDigit(false);
            localJBarcode.setXDimension(0.3);
        } else if (type.equals(CODE39)) {
            localJBarcode = new JBarcode(Code39Encoder.getInstance(), WideRatioCodedPainter.getInstance(), (TextPainter)CustomTextPainter.getInstance());
            localJBarcode.setCheckDigit(false);
            localJBarcode.setShowCheckDigit(false);
        } else if (type.equals(CODE39EXT)) {
            localJBarcode = new JBarcode(Code39ExtEncoder.getInstance(), WideRatioCodedPainter.getInstance(), (TextPainter)CustomTextPainter.getInstance());
            localJBarcode.setCheckDigit(false);
            localJBarcode.setShowCheckDigit(false);
        } else if (type.equals(CODE93)) {
            localJBarcode = new JBarcode(Code93Encoder.getInstance(), WidthCodedPainter.getInstance(), (TextPainter)CustomTextPainter.getInstance());
            localJBarcode.setShowCheckDigit(false);
        } else if (type.equals(CODE93EXT)) {
            localJBarcode = new JBarcode(Code93ExtEncoder.getInstance(), WidthCodedPainter.getInstance(), (TextPainter)CustomTextPainter.getInstance());
            localJBarcode.setCheckDigit(true);
            localJBarcode.setShowCheckDigit(false);
        } else if (type.equals(CODE11)) {
            localJBarcode = new JBarcode(Code11Encoder.getInstance(), WidthCodedPainter.getInstance(), (TextPainter)CustomTextPainter.getInstance());
            localJBarcode.setShowText(true);
            localJBarcode.setCheckDigit(true);
            localJBarcode.setShowCheckDigit(true);
        } else if (type.equals(EAN13)) {
            localJBarcode = new JBarcode((BarcodeEncoder)EAN13Encoder.getInstance(), WidthCodedPainter.getInstance(), EAN13TextPainter.getInstance());
            if (barcode.length() == 13) {
                localJBarcode.setCheckDigit(false);
            }
        } else if (type.equals(EAN8)) {
            localJBarcode = new JBarcode((BarcodeEncoder)EAN8Encoder.getInstance(), WidthCodedPainter.getInstance(), EAN8TextPainter.getInstance());
        } else if (type.equals(CODABAR)) {
            localJBarcode = new JBarcode((BarcodeEncoder)CodabarEncoder.getInstance(), WideRatioCodedPainter.getInstance(), BaseLineTextPainter.getInstance());
        } else if (type.equals(Interleaved2of5)) {
            localJBarcode = new JBarcode((BarcodeEncoder)Interleaved2of5Encoder.getInstance(), WideRatioCodedPainter.getInstance(), BaseLineTextPainter.getInstance());
        } else if (type.equals(MSI)) {
            localJBarcode = new JBarcode(MSIPlesseyEncoder.getInstance(), WidthCodedPainter.getInstance(), BaseLineTextPainter.getInstance());
        } else if (type.equals(POSTNET)) {
            localJBarcode = new JBarcode((BarcodeEncoder)PostNetEncoder.getInstance(), HeightCodedPainter.getInstance(), BaseLineTextPainter.getInstance());
        } else if (type.equals(Standard2of5)) {
            localJBarcode = new JBarcode((BarcodeEncoder)Standard2of5Encoder.getInstance(), WideRatioCodedPainter.getInstance(), BaseLineTextPainter.getInstance());
        } else if (type.equals(UPCA)) {
            localJBarcode = new JBarcode((BarcodeEncoder)UPCAEncoder.getInstance(), WidthCodedPainter.getInstance(), UPCATextPainter.getInstance());
        } else if (type.equals(UPCE)) {
            localJBarcode = new JBarcode((BarcodeEncoder)UPCEEncoder.getInstance(), WidthCodedPainter.getInstance(), UPCETextPainter.getInstance());
        } else {
            throw new KDException(new ErrorCode("print-exception", ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u6761\u5f62\u7801\u7c7b\u578b\u3002", (String)"BarCodeGeneraterUtil_0", (String)"bos-print-engine", (Object[])new Object[0])), new Object[0]);
        }
        if (config.get("showText") != null) {
            boolean isShwoText = (Boolean)config.get("showText");
            localJBarcode.setShowText(isShwoText);
            localJBarcode.setBarHeight(2.0);
        }
        BufferedImage localBufferedImage = null;
        int dpi = 150;
        if (StringUtils.isNotBlank((Object)config.get("dpi"))) {
            dpi = (Integer)config.get("dpi");
        }
        if (config.get(BAR_HEIGHT) != null && !"".equals(config.get(BAR_HEIGHT).toString().trim()) && (height = Double.parseDouble(config.get(BAR_HEIGHT).toString())) != 0.0) {
            localJBarcode.setBarHeight(height);
        }
        localBufferedImage = localJBarcode.createBarcode(barcode);
        byte[] result = ImageUtil.encode((BufferedImage)localBufferedImage, (String)"png", (int)dpi, (int)dpi);
        localBufferedImage.getGraphics().dispose();
        return result;
    }

    public static BufferedImage rotateImage(BufferedImage bufferedimage, int degree) {
        int w = bufferedimage.getWidth();
        int h = bufferedimage.getHeight();
        int type = bufferedimage.getColorModel().getTransparency();
        BufferedImage img = new BufferedImage(w, h, type);
        Graphics2D graphics2d = img.createGraphics();
        graphics2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2d.rotate(Math.toRadians(degree), w / 2, h / 2);
        graphics2d.drawImage((Image)bufferedimage, 0, 0, null);
        graphics2d.dispose();
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] createNewImg(BufferedImage src, int width, int height, int dpi) {
        Image image = src.getScaledInstance(width, height, 1);
        BufferedImage tag = new BufferedImage(width, height, 1);
        Graphics g = tag.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        try {
            byte[] byArray = ImageUtil.encode((BufferedImage)tag, (String)"png", (int)dpi, (int)dpi);
            return byArray;
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
        finally {
            if (tag != null) {
                tag.getGraphics().dispose();
            }
        }
        return null;
    }

    public static void paint(BarcodeContext barcodeContext) throws InvalidAtributeException {
        String type = barcodeContext.getBarcodeType();
        if (type == null || "".equals(type)) {
            type = CODE128;
        }
        String barcode = barcodeContext.getText();
        JBarcode localJBarcode = null;
        if (type.equals(CODE128)) {
            localJBarcode = new JBarcode((BarcodeEncoder)Code128Encoder.getInstance(), WidthCodedPainter.getInstance(), (TextPainter)CustomTextPainter.getInstance());
            localJBarcode.setShowCheckDigit(false);
        } else if (type.equals(CODE39)) {
            localJBarcode = new JBarcode(Code39Encoder.getInstance(), WideRatioCodedPainter.getInstance(), (TextPainter)CustomTextPainter.getInstance());
            localJBarcode.setShowCheckDigit(false);
        } else if (type.equals(CODE39EXT)) {
            localJBarcode = new JBarcode(Code39ExtEncoder.getInstance(), WideRatioCodedPainter.getInstance(), (TextPainter)CustomTextPainter.getInstance());
            localJBarcode.setShowCheckDigit(false);
        } else if (type.equals(CODE93)) {
            localJBarcode = new JBarcode(Code93Encoder.getInstance(), WidthCodedPainter.getInstance(), (TextPainter)CustomTextPainter.getInstance());
            localJBarcode.setShowCheckDigit(false);
        } else if (type.equals(CODE93EXT)) {
            localJBarcode = new JBarcode(Code93ExtEncoder.getInstance(), WidthCodedPainter.getInstance(), (TextPainter)CustomTextPainter.getInstance());
            localJBarcode.setCheckDigit(true);
            localJBarcode.setShowCheckDigit(false);
        } else if (type.equals(CODE11)) {
            localJBarcode = new JBarcode(Code11Encoder.getInstance(), WidthCodedPainter.getInstance(), (TextPainter)CustomTextPainter.getInstance());
            localJBarcode.setShowText(true);
            localJBarcode.setCheckDigit(true);
            localJBarcode.setShowCheckDigit(true);
        } else if (type.equals(EAN13)) {
            localJBarcode = new JBarcode((BarcodeEncoder)EAN13Encoder.getInstance(), WidthCodedPainter.getInstance(), EAN13TextPainter.getInstance());
            if (barcode.length() == 13) {
                localJBarcode.setCheckDigit(false);
            }
        } else if (type.equals(EAN8)) {
            localJBarcode = new JBarcode((BarcodeEncoder)EAN8Encoder.getInstance(), WidthCodedPainter.getInstance(), EAN8TextPainter.getInstance());
        } else if (type.equals(CODABAR)) {
            localJBarcode = new JBarcode((BarcodeEncoder)CodabarEncoder.getInstance(), WideRatioCodedPainter.getInstance(), BaseLineTextPainter.getInstance());
        } else if (type.equals(Interleaved2of5)) {
            localJBarcode = new JBarcode((BarcodeEncoder)Interleaved2of5Encoder.getInstance(), WideRatioCodedPainter.getInstance(), BaseLineTextPainter.getInstance());
        } else if (type.equals(MSI)) {
            localJBarcode = new JBarcode(MSIPlesseyEncoder.getInstance(), WidthCodedPainter.getInstance(), BaseLineTextPainter.getInstance());
        } else if (type.equals(POSTNET)) {
            localJBarcode = new JBarcode((BarcodeEncoder)PostNetEncoder.getInstance(), HeightCodedPainter.getInstance(), BaseLineTextPainter.getInstance());
        } else if (type.equals(Standard2of5)) {
            localJBarcode = new JBarcode((BarcodeEncoder)Standard2of5Encoder.getInstance(), WideRatioCodedPainter.getInstance(), BaseLineTextPainter.getInstance());
        } else if (type.equals(UPCA)) {
            localJBarcode = new JBarcode((BarcodeEncoder)UPCAEncoder.getInstance(), WidthCodedPainter.getInstance(), UPCATextPainter.getInstance());
        } else if (type.equals(UPCE)) {
            localJBarcode = new JBarcode((BarcodeEncoder)UPCEEncoder.getInstance(), WidthCodedPainter.getInstance(), UPCETextPainter.getInstance());
        } else {
            throw new KDException(new ErrorCode("print-exception", ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u6761\u5f62\u7801\u7c7b\u578b\u3002", (String)"BarCodeGeneraterUtil_0", (String)"bos-print-engine", (Object[])new Object[0])), new Object[0]);
        }
        boolean isShwoText = barcodeContext.isShowText();
        localJBarcode.setShowText(isShwoText);
        double height = barcodeContext.getBarZoneHeight();
        localJBarcode.setBarHeight(height);
        BufferedImage localBufferedImage = localJBarcode.createBarcode(barcode);
        GraphicsForBarcode g = barcodeContext.getGraphics();
        g.drawImage((Image)localBufferedImage, 0, 0, (ImageObserver)null);
        g.dispose();
    }
}

