/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.barcode;

import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.factory.IAnObjectFactory;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.BarcodeObject;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.xmltrans.AbstractR1PrintXmlTrans;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.print.control.Barcode;
import kd.bos.metadata.print.control.BaseControl;
import kd.bos.metadata.print.control.QRCode;

public class BarcodeXmlTrans
extends AbstractR1PrintXmlTrans {
    private static final Log log = LogFactory.getLog(BarcodeXmlTrans.class);

    public BarcodeXmlTrans(IAnObjectFactory factory) {
        super(factory);
    }

    @Override
    protected boolean isMatch(BaseControl<?> node) {
        return node instanceof Barcode || node instanceof QRCode;
    }

    @Override
    protected IReportObject fromXml(BaseControl<?> node) throws R1Exception {
        BarcodeObject picObj = (BarcodeObject)this.getFactory().create();
        this.loadObjectCommon(node, picObj);
        Barcode code = (Barcode)node;
        if ("original".equalsIgnoreCase(code.getDisplayMode())) {
            picObj.setScale(0);
        } else {
            picObj.setScale(3);
        }
        picObj.setBarCodeFontSize(code.getBarCodeFontSize());
        return picObj;
    }

    @Override
    protected void loadDataNode(BaseControl<?> nodeRo, IReportObject ro) {
        String suffix;
        LocaleString bindText;
        String symbolShape;
        super.loadDataNode(nodeRo, ro);
        BarcodeObject bo = (BarcodeObject)ro;
        Barcode bc = (Barcode)nodeRo;
        if (nodeRo instanceof QRCode) {
            QRCode qr = (QRCode)nodeRo;
            bo.setBarcodeType(qr.getQRMode().toUpperCase());
            if ("PDF_417".equalsIgnoreCase(bo.getBarcodeType())) {
                bo.setErrorCorrection(qr.getIntErrorCorrection());
            } else {
                bo.setErrorCorrection(qr.getErrorCorrection());
            }
        } else {
            bo.setBarcodeType(bc.getEncodeMode());
        }
        bo.setDpi(bc.getDpi());
        String modelWidthStr = bc.getWidth().toString();
        String barHeightStr = bc.getHeight().toString();
        if (modelWidthStr != null) {
            try {
                bo.setModelWidth(1.0);
            }
            catch (NumberFormatException e) {
                log.error((Throwable)e);
            }
        }
        if (barHeightStr != null) {
            try {
                bo.setBarHeight(this.parseInt(barHeightStr));
            }
            catch (NumberFormatException e) {
                log.error((Throwable)e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(symbolShape = bc.getSymbolShape()))) {
            bo.setShape(symbolShape);
        }
        if (StringUtils.isNotBlank((Object)(bindText = bc.getBindText()))) {
            bo.setSampleTxt(bindText.toString());
        } else {
            String sampleTxt = bc.getSampleText();
            if (StringUtils.isNotBlank((CharSequence)sampleTxt)) {
                bo.setSampleTxt(sampleTxt);
            }
        }
        boolean showSample = bc.isShowSample();
        bo.setShowSample(showSample);
        bo.setShowText(bc.isDisplayText());
        String prefix = bc.getPrefix();
        if (StringUtils.isNotBlank((CharSequence)prefix)) {
            bo.setPrefix(prefix);
        }
        if (StringUtils.isNotBlank((CharSequence)(suffix = bc.getSuffix()))) {
            bo.setSuffix(suffix);
        }
    }
}

