/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.barcode;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.BarcodeObject;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintException;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.AbstractPrintWidgetText;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IAdjustHeightSupport;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IDatasourceSupport;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPrintWidget;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class PWBarcode
extends AbstractPrintWidgetText
implements IAdjustHeightSupport,
IDatasourceSupport {
    private static final String AUTO_MATCH = "autoMatch";
    private static final Log log = LogFactory.getLog(PWBarcode.class);
    private String _ds;
    private String _oriValue;
    private Variant _outputValue;
    private boolean _isAdjustHeight;
    private int _maxHeightToAdjust;
    private BarcodeObject barcodeObject;
    public static final String NUMBERIC_FORMAT = "0000.00";

    @Override
    public IPrintWidget copy() {
        IPrintWidget widget = super.copy();
        PWBarcode wp = (PWBarcode)widget;
        wp.setBarcodeObject(this.getBarcodeObject());
        return widget;
    }

    @Override
    protected void executing(IWidgetExecuteHelper helper, IPrintWidget outputWidget) throws R1PrintException {
        PWBarcode output = (PWBarcode)outputWidget;
        Variant outputValue = null;
        Variant opValue = output.getOutputValue();
        if (opValue != null) {
            outputValue = opValue;
        } else if (StringUtils.isNotBlank((CharSequence)this.getDatasource())) {
            if (StringUtils.isNotBlank((Object)this.barcodeObject.getBindField().getField())) {
                String fieldName = this.barcodeObject.getBindField().getField().getName();
                outputValue = this.getDataHelper(helper, this._ds).getFieldValue(this._ds, fieldName);
            }
        } else {
            outputValue = new Variant(this.barcodeObject.getSampleTxt());
        }
        if (outputValue != null && StringUtils.isNotBlank((Object)outputValue.getValue())) {
            boolean isQr;
            String code = outputValue.getValue().toString();
            String prefix = this.barcodeObject.getPrefix();
            String suffix = this.barcodeObject.getSuffix();
            if (StringUtils.isNotBlank((CharSequence)prefix)) {
                code = prefix + code;
            }
            if (StringUtils.isNotBlank((CharSequence)suffix)) {
                code = code + suffix;
            }
            boolean bl = isQr = "QR_CODE".equalsIgnoreCase(this.barcodeObject.getBarcodeType()) || "DATA_MATRIX".equalsIgnoreCase(this.barcodeObject.getBarcodeType()) || "PDF_417".equalsIgnoreCase(this.barcodeObject.getBarcodeType());
            if (isQr && this.containsNonAsciiChar(code)) {
                code = code + "\n";
            }
            Map<String, Object> config = this.generateConfig(code);
            outputValue = new Variant(config);
        }
        output.setOutputValue(outputValue);
    }

    private boolean containsNonAsciiChar(String code) {
        for (int i = 0; i < code.length(); ++i) {
            char c = code.charAt(i);
            if (c <= '\u0080') continue;
            return true;
        }
        return false;
    }

    public String tranNumericToStr(Object value, String format) {
        if (value == null) {
            return "";
        }
        if (format == null || "".equals(format)) {
            format = NUMBERIC_FORMAT;
        }
        String result = "";
        try {
            format = format.replaceAll("\\d", "0");
            int pointBeforeLength = format.length();
            int pointAfterLength = 0;
            if (format.lastIndexOf(46) > -1) {
                int pointIndex = format.lastIndexOf(46);
                pointAfterLength = format.length() - pointIndex - 1;
                pointBeforeLength = format.length() - pointAfterLength - 1;
            }
            if ((result = value.toString().replaceAll(",", "")).lastIndexOf(46) > -1) {
                int point = result.indexOf(46);
                String str1 = result.substring(0, point);
                String str2 = result.substring(point + 1, result.length());
                result = this.subStrByLength(str1, pointBeforeLength, true) + this.subStrByLength(str2, pointAfterLength, false);
            } else {
                result = this.subStrByLength(result, pointBeforeLength, true) + this.subStrByLength("", pointAfterLength, false);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return "";
        }
        return result;
    }

    public String subStrByLength(String str, int length, boolean isBefore) {
        while (str.length() < length) {
            if (isBefore) {
                str = "0" + str;
                continue;
            }
            str = str + "0";
        }
        while (str.length() > length) {
            if (isBefore) {
                str = str.substring(1);
                continue;
            }
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    private Map<String, Object> generateConfig(String code) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("barcode", code);
        double height = (double)this.barcodeObject.getHeight() * 0.1;
        double width = (double)this.barcodeObject.getWidth() * 0.1;
        config.put("height", height);
        config.put("width", width);
        config.put("dpi", this.barcodeObject.getDpi());
        config.put("modelWidth", this.barcodeObject.getModelWidth());
        config.put("shape", this.barcodeObject.getShape());
        if (this.barcodeObject.getScale() == 3) {
            config.put(AUTO_MATCH, true);
        } else {
            config.put(AUTO_MATCH, false);
        }
        config.put("barcodeType", this.barcodeObject.getBarcodeType());
        config.put("showText", this.barcodeObject.isShowText());
        config.put("errorCorrectionLevel", this.barcodeObject.getErrorCorrection());
        return config;
    }

    public BarcodeObject getBarcodeObject() {
        return this.barcodeObject;
    }

    public void setBarcodeObject(BarcodeObject barcodeObject) {
        this.barcodeObject = barcodeObject;
    }

    @Override
    public void setOriValue(String value) {
        this._oriValue = value;
    }

    @Override
    public String getOriValue() {
        return this._oriValue;
    }

    @Override
    public void setDatasource(String ds) {
        this._ds = ds;
    }

    @Override
    public String getDatasource() {
        return this._ds;
    }

    @Override
    public void setOutputValue(Variant value) {
        this._outputValue = value;
    }

    @Override
    public Variant getOutputValue() {
        return this._outputValue;
    }

    @Override
    public void setAdjustHeight(boolean isAdjustHeight) {
        this._isAdjustHeight = isAdjustHeight;
    }

    @Override
    public boolean isAdjustHeight() {
        return this._isAdjustHeight;
    }

    @Override
    public void setMaxHeightToAdjust(int maxHeight) {
        this._maxHeightToAdjust = maxHeight;
    }

    @Override
    public int getMaxHeightToAdjust() {
        return this._maxHeightToAdjust;
    }

    @Override
    public void setRemainContent(boolean isRemain) {
    }

    @Override
    public boolean isRemainContent() {
        return false;
    }

    @Override
    public Object getFieldValue(String field) {
        return this.getFieldValue(this.getDatasource(), field);
    }
}

