/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.barcode;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.print.ui.component.BarCodeCell;
import com.kingdee.bos.ctrl.print.ui.component.IPainter;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.PWBarcode;
import com.kingdee.bos.ctrl.reportone.r1.print.common.ImageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exporter.AR1PNode_W2V;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPrintWidget;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class R1PBarcode_W2V
extends AR1PNode_W2V {
    private static final Log log = LogFactory.getLog(R1PBarcode_W2V.class);

    @Override
    protected IPainter createViewt(IPrintWidget node) {
        return new BarCodeCell();
    }

    @Override
    protected void exportSpecial(IPrintWidget widget, IPainter view) {
        PWBarcode pwBarcode = (PWBarcode)widget;
        BarCodeCell barcodeCell = (BarCodeCell)view;
        Variant outputValue = pwBarcode.getOutputValue();
        if (outputValue != null && StringUtils.isNotBlank((Object)outputValue.getValue())) {
            barcodeCell.setConfig((Map)outputValue.getValue());
        }
    }

    public static Image loadImage(Object value) {
        if (value != null) {
            byte[] imageData = null;
            if (value instanceof byte[]) {
                imageData = (byte[])value;
            } else if (value instanceof Blob) {
                imageData = R1PBarcode_W2V.blobToBytes((Blob)value);
            } else if (value instanceof String && value != null && StringUtils.isNotBlank((CharSequence)value.toString())) {
                imageData = ImageUtil.getImageByUrl((String)value);
            }
            if (imageData != null) {
                return ImageUtil.makeImage(imageData);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] blobToBytes(Blob blob) {
        ByteArrayOutputStream baos = null;
        try (InputStream is = blob.getBinaryStream();){
            if (is != null) {
                baos = new ByteArrayOutputStream();
                byte[] c = new byte[1024];
                int len = 0;
                while ((len = is.read(c, 0, c.length)) != -1) {
                    baos.write(c, 0, len);
                }
                byte[] byArray = baos.toByteArray();
                return byArray;
            }
        }
        catch (SQLException sqlEx) {
            log.error((Throwable)sqlEx);
        }
        catch (IOException ioEx) {
            log.error((Throwable)ioEx);
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
        return new byte[0];
    }
}

