/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.browser;

import com.kingdee.bos.ctrl.helper.ExportContext;
import com.kingdee.bos.ctrl.kdf.form2.ui.AbstractNotePrint;
import com.kingdee.bos.ctrl.kdf.form2.ui.INotePrintHelper;
import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.print.config.PrintJobConfig;
import com.kingdee.bos.ctrl.print.config.attribute.FreeMediaSize;
import com.kingdee.bos.ctrl.print.config.attribute.MediaSizeNameExtend;
import com.kingdee.bos.ctrl.print.config.attribute.PageIntervalInfo;
import com.kingdee.bos.ctrl.print.printjob.BufferPrintJob;
import com.kingdee.bos.ctrl.print.printjob.IPrintJob;
import com.kingdee.bos.ctrl.print.ui.component.Paper;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportModel;
import com.kingdee.bos.ctrl.reportone.r1.print.browser.R1PrintPageProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.common.R1PrintInfo;
import com.kingdee.bos.ctrl.reportone.r1.print.common.headfooter.LongPageModeHeadFooterModel;
import com.kingdee.bos.ctrl.reportone.r1.print.data.IPrintVariantListener;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.R1PrintPage;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.R1PrintModelHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.RuntimeModel;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintDataException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.OutputStream;
import java.util.List;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class R1PrintBrowser
extends AbstractNotePrint {
    private static final Log log = LogFactory.getLog(R1PrintBrowser.class);
    private IPrintVariantListener _varListener;
    private INotePrintHelper.ICustomizePrintJobConfig _customizePrintJobConfig;
    private boolean isCrossPrint = false;

    public void setVariantListener(IPrintVariantListener l) {
        this._varListener = l;
    }

    @Override
    public void initPrintCtrl(Object templateModel) {
        if (!(templateModel instanceof RuntimeModel)) {
            throw new IllegalArgumentException("Argument templateModel must be RuntimeModel.");
        }
        RuntimeModel runtimeModel = (RuntimeModel)templateModel;
        runtimeModel.setVariantListener(this._varListener);
    }

    @Override
    public int print(Object templateModel, boolean isPreview, boolean isShowPrinterDialog, Component owner, String title) {
        if (templateModel instanceof RuntimeModel) {
            return this.print((RuntimeModel)templateModel, R1PrintBrowser.getMaxPagesLimit(), isPreview, isShowPrinterDialog, false, owner, title);
        }
        throw new IllegalArgumentException("Argument templateModel must be RuntimeModel.");
    }

    private int print(RuntimeModel runtimeModel, int forceStopPages, boolean isPreview, boolean isShowPrinterDialog, boolean isSync, Component owner, String title) {
        this.getPrinterCtrl().clear();
        this.initPrintCtrl(runtimeModel);
        R1PrintPageProvider pageProvider = this.createPageProvider(forceStopPages);
        this.generate(runtimeModel, isSync, pageProvider);
        ReportModel mo = runtimeModel.getReportModel();
        R1PrintInfo pi = R1PrintBrowser.getPrintInfo(mo);
        this.createPrintJob(mo, pi, pageProvider);
        return R1PrintBrowser.runPrintCtrl(this.getPrinterCtrl(), isPreview, isShowPrinterDialog, owner, title);
    }

    public int designTimePreview(RuntimeModel rm, Component owner, String title) {
        return this.print(rm, 10, true, true, true, owner, title);
    }

    public Paper getPrintPaper(RuntimeModel runtimeModel) {
        ReportModel mo = runtimeModel.getReportModel();
        runtimeModel.setVariantListener(this._varListener);
        this.getPrinterCtrl().clear();
        R1PrintInfo pi = R1PrintBrowser.getPrintInfo(mo);
        R1PrintPageProvider pageProvider = this.createPageProvider(1);
        this.generate(runtimeModel, true, pageProvider);
        IPrintJob printJob = this.createPrintJob(mo, pi, pageProvider);
        this.getPrinterCtrl().preParePrint();
        Paper paper = printJob.getPaper(0);
        return paper;
    }

    private R1PrintPageProvider createPageProvider(int forceStopPages) {
        R1PrintPageProvider pageProvider = new R1PrintPageProvider();
        pageProvider.setPagesOfForceStop(forceStopPages);
        pageProvider.setCrossPrint(this.isCrossPrint);
        return pageProvider;
    }

    private void generate(RuntimeModel runtimeModel, boolean sync, R1PrintPageProvider pageProvider) {
        final Generater generater = new Generater(pageProvider, runtimeModel);
        if (sync) {
            try {
                generater.generate();
            }
            catch (R1PrintDataException e) {
                log.error((Throwable)e);
            }
        } else {
            Thread thread = new Thread((Runnable)generater, "R1-Print Engine");
            this.getPrinterCtrl().addPreviewActionListener(new IPrintActionListener(){

                @Override
                public void beforePrintOrPreview() {
                }

                @Override
                public void beforePreview() {
                }

                @Override
                public void beforePrint() {
                }

                @Override
                public void closePreview() {
                    generater.stopPageProvider();
                }
            });
            thread.start();
        }
    }

    @Override
    public IPrintJob createPrintJob(Object templateModel) {
        RuntimeModel runtimeModel = (RuntimeModel)templateModel;
        runtimeModel.reInitialize();
        R1PrintPageProvider pageProvider = this.createPageProvider(ExportContext.get().getPdfMaxPageSize());
        this.generate(runtimeModel, true, pageProvider);
        ReportModel mo = runtimeModel.getReportModel();
        R1PrintInfo pi = R1PrintBrowser.getPrintInfo(mo);
        return this.createPrintJob(mo, pi, pageProvider);
    }

    private IPrintJob createPrintJob(ReportModel model, R1PrintInfo pi, R1PrintPageProvider pageProvider) {
        BufferPrintJob prtJob = new BufferPrintJob();
        prtJob.setPageProvider(pageProvider);
        this.getPrinterCtrl().addPrintJob(prtJob);
        this.makePrintJobConfig(pi, prtJob.getConfig());
        prtJob.setVariantParser(pageProvider.getDelayVarProvider());
        return prtJob;
    }

    private void makePrintJobConfig(R1PrintInfo pi, PrintJobConfig pjc) {
        if (this._customizePrintJobConfig != null) {
            this._customizePrintJobConfig.setConfigChangeHandlerEnabled(false);
        }
        pjc.getPrintRequestAttributeSet().add(PageIntervalInfo.getDefault());
        int leftMagin = pi.getMarginLeft();
        int rightMagin = pi.getMarginRight();
        int topMagin = pi.getMarginTop();
        int bottomMagin = pi.getMarginBottom();
        pjc.setLeftMargin(leftMagin < 0 ? 0 : leftMagin / 10, 1000);
        pjc.setRightMargin(rightMagin < 0 ? 0 : rightMagin / 10, 1000);
        pjc.setBodyTopMargin(topMagin < 0 ? 0 : topMagin / 10, 1000);
        pjc.setBodyBottomMargin(bottomMagin < 0 ? 0 : bottomMagin / 10, 1000);
        log.debug(String.format("\u5f53\u524d\u8fb9\u8ddd\u8d4b\u503c\u4e3a \u4e0a\uff1a%d  \u5de6\uff1a%d  \u5e95\uff1a%d  \u53f3\uff1a%d ", topMagin, leftMagin, bottomMagin, rightMagin));
        MediaSizeName msn = null;
        if (pi.isCustomPaper()) {
            int oriWidth = pi.getCustomWidth();
            int oriHeight = pi.getCustomHeight();
            this.getPrinterCtrl().setDynamicPaper(pi.isDynamicPaper());
            float width = (float)oriWidth / 10.0f;
            float height = pi.isDynamicPaper() ? 65535.0f : (float)(oriHeight / 10);
            MediaSizeNameExtend media = MediaSizeNameExtend.CUSTOM;
            MediaSize ms = MediaSize.getMediaSizeForName(media);
            if (ms instanceof FreeMediaSize) {
                ((FreeMediaSize)ms).setXY(width, height, 1000);
            } else if (ms == null) {
                new FreeMediaSize(width, height, 1000, (MediaSizeName)media);
            }
            pjc.addAttribute(media);
        } else {
            String newName = "";
            switch (pi.getPaperName()) {
                case "B5": {
                    newName = "iso-b5";
                    break;
                }
                case "A3": {
                    newName = "iso-a3";
                    break;
                }
                case "A4": {
                    newName = "iso-a4";
                    break;
                }
                default: {
                    newName = pi.getPaperName();
                }
            }
            msn = KDPrinterUtils.getMediaSizeName(newName);
            pjc.addAttribute(msn);
        }
        if ("LANDSCAPE".equalsIgnoreCase(pi.getOrientation())) {
            pjc.addAttribute(OrientationRequested.LANDSCAPE);
        } else {
            pjc.addAttribute(OrientationRequested.PORTRAIT);
        }
        if (this._customizePrintJobConfig != null) {
            this._customizePrintJobConfig.customize(pjc);
            this._customizePrintJobConfig.setConfigChangeHandlerEnabled(true);
        }
    }

    @Override
    public void setCustomizePrintJobConfig(INotePrintHelper.ICustomizePrintJobConfig customizePrintJobConfig) {
        this._customizePrintJobConfig = customizePrintJobConfig;
    }

    @Override
    public List<BufferedImage> exportJPG(Object templateModel) {
        this.innerExportPDF(templateModel);
        return this.getPrinterCtrl().getIOManager().exportToJpg();
    }

    @Override
    public void exportPDF(Object templateModel, String file) {
        this.innerExportPDF(templateModel);
        this.getPrinterCtrl().getIOManager().exportToPdf(file);
    }

    @Override
    public void exportPDF(Object templateModel, OutputStream outputStream) {
        this.innerExportPDF(templateModel);
        this.getPrinterCtrl().getIOManager().exportToPdf(((RuntimeModel)templateModel).getPdfName(), outputStream);
    }

    private void innerExportPDF(Object templateModel) {
        if (!(templateModel instanceof RuntimeModel)) {
            throw new KDException(BosErrorCode.systemError, new Object[]{ResManager.loadKDString((String)"\u5957\u6253\u6a21\u578b\u751f\u6210\u9519\u8bef--\u751f\u6210\u7684\u6a21\u578b\u4e0d\u662fRuntimeModel\u3002", (String)"R1PrintBrowser_0", (String)"bos-print-engine", (Object[])new Object[0])});
        }
        RuntimeModel runtimeModel = (RuntimeModel)templateModel;
        this.getPrinterCtrl().clear();
        runtimeModel.setVariantListener(this._varListener);
        R1PrintPageProvider pageProvider = this.createPageProvider(R1PrintBrowser.getMaxPagesLimit());
        this.generate(runtimeModel, true, pageProvider);
        ReportModel mo = runtimeModel.getReportModel();
        R1PrintInfo pi = R1PrintBrowser.getPrintInfo(mo);
        this.createPrintJob(mo, pi, pageProvider);
    }

    @Override
    public void setCrossPrint(boolean isCrossPrint) {
        this.isCrossPrint = isCrossPrint;
    }

    private static R1PrintInfo getPrintInfo(ReportModel mo) {
        LongPageModeHeadFooterModel hfm;
        R1PrintInfo pi = R1PrintModelHelper.getPrintInfo(mo);
        R1PrintPage page = (R1PrintPage)mo.getPage();
        if (!page.isHeightSyncFromPaper() && (hfm = R1PrintModelHelper.getHeadFooterOfLongPageMode(page)) != null) {
            int newMarginTop = (pi = new R1PrintInfo(pi)).getMarginTop() - hfm.getHeader().getHeightLom();
            if (newMarginTop < 0) {
                newMarginTop = 0;
                hfm.getHeader().setHeightLom(pi.getMarginTop());
            }
            pi.setMarginTop(newMarginTop);
            int newMarginBottom = pi.getMarginBottom() - hfm.getFooter().getHeightLom();
            if (newMarginBottom < 0) {
                newMarginBottom = 0;
                hfm.getFooter().setHeightLom(pi.getMarginBottom());
            }
            pi.setMarginBottom(newMarginBottom);
        }
        return pi;
    }

    private static class Generater
    implements Runnable {
        private R1PrintPageProvider pageProvider;
        private RuntimeModel runtimeModel;

        public Generater(R1PrintPageProvider pp, RuntimeModel mo) {
            this.pageProvider = pp;
            this.runtimeModel = mo;
        }

        @Override
        public void run() {
            try {
                this.generate();
            }
            catch (Exception t) {
                log.error("R1-Print\u5f15\u64ce\u6267\u884c\u7ebf\u7a0b\u672a\u6355\u83b7\u7684\u5f02\u5e38", (Throwable)t);
                this.pageProvider.errorForceStopped();
            }
        }

        public void generate() throws R1PrintDataException {
            R1PrintInfo pi = R1PrintModelHelper.getPrintInfo(this.runtimeModel.getReportModel());
            Dimension dim = pi.getPrintableAreaSize();
            if (pi.isDynamicPaper()) {
                dim.height = 10000;
            }
            this.pageProvider.generate(this.runtimeModel, dim.width, dim.height);
        }

        public void stopPageProvider() {
            this.pageProvider.forceStop();
        }
    }
}

