/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.common;

import com.kingdee.bos.ctrl.kdf.util.BMPReader;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.http.util.ByteArrayBuffer;

public class ImageUtil {
    private static final Log log = LogFactory.getLog(ImageUtil.class);

    public static Image getImage(String str) {
        byte[] bytes = ImageUtil.getImageByteContent(str);
        if (bytes != null) {
            return ImageUtil.makeImage(bytes);
        }
        return null;
    }

    public static final Image makeImage(byte[] data) {
        if (data.length > 1 && data[0] == 66 && data[1] == 77) {
            return BMPReader.loadBitMap(data);
        }
        return new ImageIcon(data).getImage();
    }

    public static byte[] compressPicByte(byte[] picByte, double scale) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(picByte);
        Thumbnails.Builder builder = Thumbnails.of((InputStream[])new InputStream[]{inputStream}).scale(scale);
        try {
            BufferedImage bufferedImage = builder.asBufferedImage();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "jpg", baos);
            return baos.toByteArray();
        }
        catch (IOException e) {
            log.info("\u6253\u5370-\u56fe\u7247\u538b\u7f29\u5931\u8d25");
            return picByte;
        }
    }

    private static double getAccuracy(long size) {
        double accuracy = size < 100L ? 1.0 : (size < 500L ? 0.8 : (size < 1024L ? 0.6 : (size < 2048L ? 0.5 : 0.2)));
        return accuracy;
    }

    /*
     * Exception decompiling
     */
    public static byte[] getImageByteContent(String str) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static byte[] getImageByUrl(String imageUrl) {
        byte[] result = new byte[]{};
        double scale = 1.0;
        if (imageUrl.startsWith("http:") || imageUrl.startsWith("https:")) {
            try {
                result = ImageUtil.readImageFromNet(imageUrl);
            }
            catch (IOException e) {
                log.error("\u6253\u5370-\u65e0\u6cd5\u4e0b\u8f7d\u56fe\u7247 :" + imageUrl + ", \u539f\u56e0: " + e.getCause());
            }
        } else {
            result = ImageUtil.download(imageUrl);
        }
        return result;
    }

    private static byte[] download(String imageUrl) {
        String newUrl = imageUrl;
        if (imageUrl.indexOf("?v=") > 0) {
            newUrl = imageUrl.substring(0, imageUrl.indexOf("?v="));
        }
        if (imageUrl.indexOf("&v=") > 0) {
            newUrl = imageUrl.substring(0, imageUrl.indexOf("&v="));
        }
        byte[] byteImage = null;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            FileServiceFactory.getImageFileService().download(newUrl, (OutputStream)bos, null);
            byteImage = bos.toByteArray();
        }
        catch (IOException e) {
            log.error("\u6253\u5370-\u65e0\u6cd5\u4e0b\u8f7d\u56fe\u7247.", (Throwable)e);
        }
        return byteImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readImageFromNet(String fullUrl) throws IOException {
        InputStream in = null;
        BufferedInputStream bis = null;
        byte[] queryResult = null;
        try {
            HttpURLConnection urlConn;
            URL url = new URL(fullUrl);
            HttpURLConnection httpConn = urlConn = (HttpURLConnection)url.openConnection();
            httpConn.setAllowUserInteraction(false);
            httpConn.connect();
            in = httpConn.getInputStream();
            bis = new BufferedInputStream(in);
            ByteArrayBuffer baf = new ByteArrayBuffer(50);
            int read = 0;
            int bufSize = 1024;
            byte[] buffer = new byte[bufSize];
            while ((read = bis.read(buffer)) != -1) {
                baf.append(buffer, 0, read);
            }
            queryResult = baf.toByteArray();
        }
        catch (MalformedURLException e) {
            log.error("DEBUG: ", (Throwable)e);
        }
        catch (IOException e) {
            log.error("DEBUG: ", (Throwable)e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    log.error("io", (Throwable)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error("io", (Throwable)e);
                }
            }
        }
        return queryResult;
    }

    private static boolean needToCompress(String imageUrl) {
        boolean isNeed = true;
        try {
            String newUrl = imageUrl;
            int index = imageUrl.indexOf("?v=");
            if (index > 0) {
                newUrl = imageUrl.substring(0, index);
            }
            if ((index = imageUrl.indexOf("&v=")) > 0) {
                newUrl = imageUrl.substring(0, index);
            }
            if (newUrl.contains(".") && newUrl.substring(newUrl.lastIndexOf(46), newUrl.length()).trim().equals(".gif")) {
                isNeed = false;
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            isNeed = true;
        }
        return isNeed;
    }
}

