/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.common;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import kd.bos.metadata.form.PrintFormAp;
import kd.bos.metadata.form.PrintMetadata;
import kd.bos.metadata.print.control.BaseContainer;
import kd.bos.metadata.print.control.BaseControl;
import kd.bos.metadata.print.control.Footer;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;

public class R1PrintInfo {
    private static final long serialVersionUID = 1L;
    public static final String PORTRAIT = "PORTRAIT";
    public static final String LANDSCAPE = "LANDSCAPE";
    public static final String CUSTOM_PAPER = "Custom";
    private static final String CUSTOM = "custom";
    public static final String[] CUSTOM_PAPERS = new String[]{"custom", "KP-J101", "KP-J102", "KP-J103", "KP-J104", "KP-J105", "KP-J106", "KP-J107", "KP-J108", "KP-J109"};
    private static final String HEIGHT = "height";
    private String paperName = "iso-a4";
    private String orientation = "PORTRAIT";
    private int paperWidth = 2100;
    private int paperHeight = 2970;
    private int marginLeft = 190;
    private int marginRight = 190;
    private int marginTop = 250;
    private int marginBottom = 250;
    private int headerHeight = 150;
    private int headerMargin = 100;
    private int footerHeight = 0;
    private int footerMargin = 100;
    private boolean isDynamicPaperValue;
    private boolean isVerEconomizePaperValue;
    private boolean isHorEconomizePaperValue;
    private int verPageSpace = 0;
    private int horPageSpace = 0;
    private boolean haveBackgroundPicture;

    public static String[] getAllPaperNames() {
        return new MyMediaSizeName().getStringTable();
    }

    public static R1PrintInfo readFromMeta(PrintMetadata meta) {
        R1PrintInfo info = new R1PrintInfo();
        PrintFormAp paperMeta = meta.getRootAp();
        int topM = R1PrintInfo.parseToInt(paperMeta.getMarginTop().toString());
        int leftM = R1PrintInfo.parseToInt(paperMeta.getMarginLeft().toString());
        int bottomM = R1PrintInfo.parseToInt(paperMeta.getMarginBottom().toString());
        int rightM = R1PrintInfo.parseToInt(paperMeta.getMarginRight().toString());
        info.setMarginTop(topM);
        info.setMarginLeft(leftM);
        info.setMarginBottom(bottomM);
        info.setMarginRight(rightM);
        if (Objects.equals("vertical", paperMeta.getPaperDirection())) {
            info.setOrientation(PORTRAIT);
        } else {
            info.setOrientation(LANDSCAPE);
        }
        HashSet<String> customPapers = new HashSet<String>(Arrays.asList(CUSTOM_PAPERS));
        if (CUSTOM.equalsIgnoreCase(paperMeta.getPaper()) || customPapers.contains(paperMeta.getPaper())) {
            info.setPaperName(CUSTOM_PAPER);
            int w = R1PrintInfo.parseToInt(paperMeta.getWidth().getLocaleValue_zh_CN());
            int h = R1PrintInfo.parseToInt(paperMeta.getHeight().getLocaleValue_zh_CN());
            if (info.getOrientation().equals(LANDSCAPE)) {
                info.setCustomPaper(h, w);
            } else {
                info.setCustomPaper(w, h);
            }
        } else {
            info.setPaperName(paperMeta.getPaper());
        }
        info.setHorEconomizePaper(paperMeta.isHorEconomic());
        info.setVerEconomizePaper(paperMeta.isVerEconomic());
        Optional<BaseControl> opt = meta.getHeaderOrFooterItems().stream().filter(p -> (BaseContainer)p instanceof Footer).findFirst();
        if (opt.isPresent()) {
            Footer foo = (Footer)opt.get();
            int footerHeight = R1PrintInfo.parseToInt(foo.getHeight().toString());
            info.setFooterHeight(footerHeight);
        }
        if (CUSTOM.equalsIgnoreCase(paperMeta.getPaper())) {
            info.setDynamicPaper(paperMeta.isDynamicPaper());
        }
        return info;
    }

    private static int parseToInt(String value) {
        if (StringUtils.isBlank((CharSequence)value) || "mm".equals(value)) {
            return 0;
        }
        String cutValue = value.substring(0, value.length() - 2);
        Float v = Float.valueOf(Float.parseFloat(cutValue));
        return (int)(v.floatValue() * 10.0f);
    }

    public static R1PrintInfo fromXml(Element xmlNode) {
        Element xmlPreviewSetup;
        Element xmlBackground;
        Element xmlEconomizePaper;
        R1PrintInfo info = new R1PrintInfo();
        Element xmlPaperSetup = xmlNode.element("PaperSetup");
        Element xmlPaperName = xmlPaperSetup.element("Paper");
        Element xmlOrientation = xmlPaperSetup.element("Orientation");
        Element xmlPageMargin = xmlPaperSetup.element("PageMargin");
        Element xmlHeader = xmlPaperSetup.element("Header");
        Element xmlFooter = xmlPaperSetup.element("Footer");
        info.setPaperName(xmlPaperName.getTextTrim());
        if (info.isCustomPaper()) {
            int w = Integer.parseInt(xmlPaperName.attributeValue("width"));
            int h = Integer.parseInt(xmlPaperName.attributeValue(HEIGHT));
            info.setCustomPaper(w, h);
        }
        if (StringUtil.equals(LANDSCAPE, xmlOrientation.getTextTrim())) {
            info.setOrientation(LANDSCAPE);
        } else {
            info.setOrientation(PORTRAIT);
        }
        info.setMarginLeft(Integer.parseInt(xmlPageMargin.attributeValue("left")));
        info.setMarginRight(Integer.parseInt(xmlPageMargin.attributeValue("right")));
        info.setMarginTop(Integer.parseInt(xmlPageMargin.attributeValue("top")));
        info.setMarginBottom(Integer.parseInt(xmlPageMargin.attributeValue("bottom")));
        info.setHeaderHeight(Integer.parseInt(xmlHeader.attributeValue(HEIGHT)));
        info.setHeaderMargin(Integer.parseInt(xmlHeader.attributeValue("margin")));
        info.setFooterHeight(Integer.parseInt(xmlFooter.attributeValue(HEIGHT)));
        info.setFooterMargin(Integer.parseInt(xmlFooter.attributeValue("margin")));
        Element xmlPrinterSetup = xmlNode.element("PrinterSetup");
        Element xmlDynamicPaper = xmlPrinterSetup.element("DynamicPaper");
        if (xmlDynamicPaper != null) {
            info.setDynamicPaper(Boolean.parseBoolean(xmlDynamicPaper.getTextTrim()));
        }
        if ((xmlEconomizePaper = xmlPrinterSetup.element("EconomizePaper")) != null) {
            if ("true".equalsIgnoreCase(xmlEconomizePaper.getTextTrim())) {
                info.setVerEconomizePaper(true);
                info.setVerPageSpace(10);
            } else {
                info.setVerEconomizePaper(false);
            }
            if (xmlEconomizePaper.attributeValue("isVerEconomizePaper") != null) {
                info.setVerEconomizePaper(Boolean.parseBoolean(xmlEconomizePaper.attributeValue("isVerEconomizePaper")));
            }
            if (xmlEconomizePaper.attributeValue("verSpace") != null) {
                info.setVerPageSpace(Integer.parseInt(xmlEconomizePaper.attributeValue("verSpace")));
            }
            if (xmlEconomizePaper.attributeValue("isHorEconomizePaper") != null) {
                info.setHorEconomizePaper(Boolean.parseBoolean(xmlEconomizePaper.attributeValue("isHorEconomizePaper")));
            }
            if (xmlEconomizePaper.attributeValue("horSpace") != null) {
                info.setHorPageSpace(Integer.parseInt(xmlEconomizePaper.attributeValue("horSpace")));
            }
        }
        if ((xmlBackground = (xmlPreviewSetup = xmlNode.element("PreviewSetup")).element("BackgroundPicture")) != null) {
            info.setHaveBackground(Boolean.parseBoolean(xmlBackground.getTextTrim()));
        }
        return info;
    }

    public static Dimension getPaperSize(String paperName) {
        String newName = "";
        switch (paperName) {
            case "B5": {
                newName = "iso-b5";
                break;
            }
            case "A3": {
                newName = "iso-a3";
                break;
            }
            case "A4": {
                newName = "iso-a4";
                break;
            }
            default: {
                newName = paperName;
            }
        }
        MediaSizeName msn = KDPrinterUtils.getMediaSizeName(newName);
        MediaSize ms = MediaSize.getMediaSizeForName(msn);
        int w = (int)ms.getX(1000) * 10;
        int h = (int)ms.getY(1000) * 10;
        return new Dimension(w, h);
    }

    public R1PrintInfo() {
    }

    public R1PrintInfo(R1PrintInfo old) {
        this.paperName = old.paperName;
        this.orientation = old.orientation;
        this.paperWidth = old.paperWidth;
        this.paperHeight = old.paperHeight;
        this.marginLeft = old.marginLeft;
        this.marginRight = old.marginRight;
        this.marginTop = old.marginTop;
        this.marginBottom = old.marginBottom;
        this.headerHeight = old.headerHeight;
        this.headerMargin = old.headerMargin;
        this.footerHeight = old.footerHeight;
        this.footerMargin = old.footerMargin;
        this.isDynamicPaperValue = old.isDynamicPaperValue;
        this.isVerEconomizePaperValue = old.isVerEconomizePaperValue;
        this.isHorEconomizePaperValue = old.isHorEconomizePaperValue;
        this.horPageSpace = old.horPageSpace;
        this.verPageSpace = old.verPageSpace;
        this.haveBackgroundPicture = old.haveBackgroundPicture;
    }

    public String getPaperName() {
        return this.paperName;
    }

    public void setPaperName(String name) {
        this.paperName = name;
    }

    public boolean isCustomPaper() {
        return StringUtil.equalsIgnoreCase(this.getPaperName(), CUSTOM_PAPER);
    }

    public void setCustomPaper(int width, int height) {
        this.setPaperName(CUSTOM_PAPER);
        this.paperWidth = width;
        this.paperHeight = height;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    public int getCustomWidth() {
        return this.paperWidth;
    }

    public int getCustomHeight() {
        return this.paperHeight;
    }

    public Dimension getPaperSize() {
        if (this.isCustomPaper()) {
            return new Dimension(this.getCustomWidth(), this.getCustomHeight());
        }
        return R1PrintInfo.getPaperSize(this.getPaperName());
    }

    public Dimension getPrintablePaperSize() {
        int height;
        int width;
        Dimension paperSize = this.getPaperSize();
        if (this.getOrientation().equals(LANDSCAPE)) {
            width = paperSize.height;
            height = paperSize.width;
        } else {
            width = paperSize.width;
            height = paperSize.height;
        }
        if (width < 0) {
            width = 0;
        }
        if (height < 0) {
            height = 0;
        }
        return new Dimension(width, height);
    }

    public Dimension getPrintableAreaSize() {
        int height;
        int width;
        Dimension paperSize = this.getPaperSize();
        if (this.getOrientation().equals(LANDSCAPE)) {
            width = paperSize.height - this.getMarginLeft() - this.getMarginRight();
            height = paperSize.width - this.getMarginTop() - this.getMarginBottom();
        } else {
            width = paperSize.width - this.getMarginLeft() - this.getMarginRight();
            height = paperSize.height - this.getMarginTop() - this.getMarginBottom();
        }
        if (width < 0) {
            width = 0;
        }
        if (height < 0) {
            height = 0;
        }
        return new Dimension(width, height);
    }

    public void setPrintableAreaSize(Dimension pageSize) {
        int height;
        int width;
        if (this.getOrientation().equals(LANDSCAPE)) {
            width = pageSize.height + this.getMarginTop() + this.getMarginBottom();
            height = pageSize.width + this.getMarginLeft() + this.getMarginRight();
        } else {
            width = pageSize.width + this.getMarginLeft() + this.getMarginRight();
            height = pageSize.height + this.getMarginTop() + this.getMarginBottom();
        }
        this.setCustomPaper(width, height);
    }

    public void setMarginLeft(int value) {
        this.marginLeft = value;
    }

    public int getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginRight(int value) {
        this.marginRight = value;
    }

    public int getMarginRight() {
        return this.marginRight;
    }

    public void setMarginTop(int value) {
        this.marginTop = value;
    }

    public int getMarginTop() {
        return this.marginTop;
    }

    public void setMarginBottom(int value) {
        this.marginBottom = value;
    }

    public int getMarginBottom() {
        return this.marginBottom;
    }

    public boolean isDynamicPaper() {
        return this.isDynamicPaperValue;
    }

    public void setDynamicPaper(boolean value) {
        this.isDynamicPaperValue = value;
    }

    public int getHeaderHeight() {
        return this.headerHeight;
    }

    public void setHeaderHeight(int value) {
        this.headerHeight = value;
    }

    public int getHeaderMargin() {
        return this.headerMargin;
    }

    public void setHeaderMargin(int value) {
        this.headerMargin = value;
    }

    public int getFooterHeight() {
        return this.footerHeight;
    }

    public void setFooterHeight(int value) {
        this.footerHeight = value;
    }

    public int getFooterMargin() {
        return this.footerMargin;
    }

    public void setFooterMargin(int value) {
        this.footerMargin = value;
    }

    public boolean getHaveBackground() {
        return this.haveBackgroundPicture;
    }

    public void setHaveBackground(boolean value) {
        this.haveBackgroundPicture = value;
    }

    public boolean isVerEconomizePaper() {
        return this.isVerEconomizePaperValue;
    }

    public void setVerEconomizePaper(boolean value) {
        this.isVerEconomizePaperValue = value;
    }

    public boolean isHorEconomizePaper() {
        return this.isHorEconomizePaperValue;
    }

    public void setHorEconomizePaper(boolean value) {
        this.isHorEconomizePaperValue = value;
    }

    public int getHorPageSpace() {
        return this.horPageSpace;
    }

    public void setHorPageSpace(int value) {
        this.horPageSpace = value;
    }

    public int getVerPageSpace() {
        return this.verPageSpace;
    }

    public void setVerPageSpace(int value) {
        this.verPageSpace = value;
    }

    static class MyMediaSizeName
    extends MediaSizeName {
        protected MyMediaSizeName() {
            super(0);
        }

        @Override
        public String[] getStringTable() {
            return super.getStringTable();
        }
    }
}

