/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.common;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.render.r1print.ComplexTextRenderer;
import com.kingdee.bos.ctrl.kdf.util.render.r1print.DivideCharacterRenderer;
import com.kingdee.bos.ctrl.kdf.util.render.r1print.IDivideCharacterSupport;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.ui.component.IRender;
import com.kingdee.bos.ctrl.reportone.r1.print.common.AdjustHeightRenderer;
import com.kingdee.bos.ctrl.reportone.r1.print.common.IAdjustHeightRenderSupport;
import java.awt.Graphics;
import java.awt.Rectangle;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class R1PrintStringRender
implements IRender {
    private static final Log log = LogFactory.getLog(R1PrintStringRender.class);
    private static R1PrintStringRender shareInst;
    private ComplexTextRenderer complexTextRenderer;

    public static synchronized R1PrintStringRender getInstance() {
        if (shareInst == null) {
            shareInst = new R1PrintStringRender();
            R1PrintStringRender.shareInst.complexTextRenderer = new ComplexTextRenderer();
        }
        return R1PrintStringRender.getR1PrintStringRender();
    }

    private static R1PrintStringRender getR1PrintStringRender() {
        R1PrintStringRender r1PrintStringRender = new R1PrintStringRender();
        r1PrintStringRender.complexTextRenderer = new ComplexTextRenderer();
        return r1PrintStringRender;
    }

    @Override
    public void drawText(Graphics g, Rectangle rect, String text, Style style, Object targetObj) {
        if (((IAdjustHeightRenderSupport)targetObj).isUseAdjustHeightRender() && targetObj instanceof IAdjustHeightRenderSupport && StringUtils.isNotBlank((CharSequence)text)) {
            AdjustHeightRenderer.draw(g, rect, text, style);
            return;
        }
        int divideCharNums = -1;
        if (targetObj instanceof IDivideCharacterSupport) {
            divideCharNums = ((IDivideCharacterSupport)targetObj).getDivideCharNums();
        }
        if (divideCharNums > 0) {
            boolean isDrawBorder = false;
            if (style != null) {
                isDrawBorder = !style.getBorderLineStyle(Styles.Position.LEFT).isNullBorder();
            }
            DivideCharacterRenderer renderer = DivideCharacterRenderer.shareInstance(divideCharNums, isDrawBorder);
            String drawText = "";
            if (text != null) {
                drawText = text;
            }
            renderer.draw(g, rect, drawText, style, targetObj);
        } else if (!StringUtil.isEmptyString(text)) {
            this.complexTextRenderer.draw(g, rect, text, style);
        }
    }
}

