/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.common.currency;

import com.kingdee.bos.ctrl.common.currency.ICurrencyUpperFunction;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.reportone.r1.print.common.currency.CurrencyFormatInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.TreeSet;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class CurrencyFormatManager {
    private static final Log log = LogFactory.getLog(CurrencyFormatManager.class);
    private static CurrencyFormatManager instance;
    private HashMap _infos;

    public static CurrencyFormatManager shareInstance() {
        if (instance == null) {
            instance = new CurrencyFormatManager();
        }
        return instance;
    }

    private HashMap getInfos() {
        if (this._infos == null) {
            this._infos = new HashMap();
            Element root = this.loadConfigFile();
            if (root != null) {
                this.parseConfigFile(root, this._infos);
            }
        }
        return this._infos;
    }

    private Element loadConfigFile() {
        Element root = null;
        try (InputStream is = CurrencyFormatManager.class.getResourceAsStream("/currencyformat.xml");){
            try {
                root = XmlUtil.loadXmlStream(is);
            }
            catch (IOException e) {
                log.error("\u89e3\u6790\u91d1\u989d\u683c\u5f0f\u5316\u914d\u7f6e\u6587\u4ef6XML\u683c\u5f0f\u5f02\u5e38\u3002 ", (Throwable)e);
            }
            catch (DocumentException e) {
                log.error("\u89e3\u6790\u91d1\u989d\u683c\u5f0f\u5316\u914d\u7f6e\u6587\u4ef6XML\u683c\u5f0f\u5f02\u5e38\u3002 ", (Throwable)e);
            }
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
        return root;
    }

    private void parseConfigFile(Element xmlRoot, HashMap mapInfos) {
        Element nodeFuncs = xmlRoot.element("UpperFormatFunctions");
        Element nodeCodes = xmlRoot.element("Codes");
        HashMap<String, ICurrencyUpperFunction> mapFuncs = new HashMap<String, ICurrencyUpperFunction>();
        for (Element nodeFunc : nodeFuncs.elements()) {
            ICurrencyUpperFunction func;
            String id = nodeFunc.attributeValue("id");
            String funcClassName = nodeFunc.attributeValue("function");
            if (StringUtils.isEmpty((CharSequence)id) || StringUtils.isEmpty((CharSequence)funcClassName) || (func = this.createUpperFunction(funcClassName)) == null) continue;
            mapFuncs.put(id, func);
        }
        for (Element nodeCode : nodeCodes.elements()) {
            String id = nodeCode.attributeValue("id");
            String symbol = nodeCode.attributeValue("symbol");
            String upperPrefix = nodeCode.attributeValue("upperPrefix");
            String upperFunc = nodeCode.attributeValue("upperFunction");
            if (StringUtil.isEmptyString(id)) continue;
            CurrencyFormatInfo info = new CurrencyFormatInfo();
            info.setCurrencyCode(id);
            info.setSymbol(symbol);
            info.setUpperPrefix(upperPrefix);
            info.setUpperFunction((ICurrencyUpperFunction)mapFuncs.get(upperFunc));
            mapInfos.put(id, info);
        }
    }

    private ICurrencyUpperFunction createUpperFunction(String className) {
        ICurrencyUpperFunction func = null;
        try {
            func = (ICurrencyUpperFunction)Class.forName(className).newInstance();
        }
        catch (InstantiationException e) {
            log.error("\u5b9e\u4f8b\u5316\u91d1\u989d\u5927\u5199\u683c\u5f0f\u5316\u51fd\u6570\u5f02\u5e38\u3002 " + className, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error("\u5b9e\u4f8b\u5316\u91d1\u989d\u5927\u5199\u683c\u5f0f\u5316\u51fd\u6570\u5f02\u5e38\u3002 " + className, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error("\u5b9e\u4f8b\u5316\u91d1\u989d\u5927\u5199\u683c\u5f0f\u5316\u51fd\u6570\u5f02\u5e38\u3002 " + className, (Throwable)e);
        }
        catch (ClassCastException e) {
            log.error("\u5b9e\u4f8b\u5316\u91d1\u989d\u5927\u5199\u683c\u5f0f\u5316\u51fd\u6570\u5f02\u5e38\u3002 " + className, (Throwable)e);
        }
        return func;
    }

    public String getSymbol(String code) {
        CurrencyFormatInfo info = (CurrencyFormatInfo)this.getInfos().get(code);
        if (info != null) {
            return info.getSymbol();
        }
        return "";
    }

    public ICurrencyUpperFunction getUpperFunction(String code) {
        CurrencyFormatInfo info = (CurrencyFormatInfo)this.getInfos().get(code);
        if (info != null) {
            return info.getUpperFunction();
        }
        return new DefaultUpperFunction();
    }

    public String upperFomat(String code, Locale locale, Variant value, boolean isAddPrefix) {
        return this.getUpperFunction(code).format(locale, value, isAddPrefix);
    }

    public String[] getAllCodes() {
        TreeSet set = new TreeSet(this.getInfos().keySet());
        return set.toArray(new String[0]);
    }

    static class DefaultUpperFunction
    implements ICurrencyUpperFunction {
        DefaultUpperFunction() {
        }

        @Override
        public String format(Locale locale, Variant variant, boolean isAddPrefix) {
            return variant.toString();
        }
    }
}

