/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute;

import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute.AbstractExpr;
import com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute.ICompositeExpr;
import com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute.Oper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;

public class CompositeExpr
extends AbstractExpr
implements ICompositeExpr {
    private AbstractExpr _leftExpr;
    private Oper _op;
    private AbstractExpr _rightExpr;
    private int _hashCode;

    public CompositeExpr(AbstractExpr leftExpr, Oper op, AbstractExpr rightExpr) {
        this._leftExpr = leftExpr;
        this._op = op;
        this._rightExpr = rightExpr;
    }

    @Override
    public String getExprString() {
        StringBuilder result = new StringBuilder();
        boolean bracketLeftExpr = false;
        if (this._leftExpr instanceof ICompositeExpr && ((ICompositeExpr)((Object)this._leftExpr)).getOper().getPriority() < this._op.getPriority()) {
            bracketLeftExpr = true;
            result.append("(");
        }
        result.append(this._leftExpr.getExprString());
        if (bracketLeftExpr) {
            result.append(")");
        }
        result.append(" ");
        result.append(this._op.toString());
        result.append(" ");
        boolean bracketRightExpr = false;
        if (this._rightExpr instanceof ICompositeExpr && ((ICompositeExpr)((Object)this._rightExpr)).getOper().getPriority() < this._op.getPriority()) {
            bracketRightExpr = true;
            result.append("(");
        }
        result.append(this._rightExpr.getExprString());
        if (bracketRightExpr) {
            result.append(")");
        }
        return result.toString();
    }

    @Override
    public AbstractExpr runtimeClone() {
        AbstractExpr leftExpr = this._leftExpr.runtimeClone();
        AbstractExpr rightExpr = this._rightExpr.runtimeClone();
        return new CompositeExpr(leftExpr, this._op, rightExpr);
    }

    @Override
    public void computing(IWidgetExecuteHelper helper, String ds) throws SyntaxErrorException {
        if (this._leftExpr.isReturnValueUnsure()) {
            this._leftExpr.computing(helper, ds);
        }
        if (this._rightExpr.isReturnValueUnsure()) {
            this._rightExpr.computing(helper, ds);
        }
        if (!this._leftExpr.isReturnValueUnsure() && !this._rightExpr.isReturnValueUnsure()) {
            this._returnValue = this._op.computing(this._leftExpr.getReturnValue(), this._rightExpr.getReturnValue());
        }
    }

    @Override
    public void clearStat(int level) {
        this._leftExpr.clearStat(level);
        this._rightExpr.clearStat(level);
    }

    @Override
    public void confirmReturnValue(int level) throws SyntaxErrorException {
        if (this._leftExpr.isReturnValueUnsure()) {
            this._leftExpr.confirmReturnValue(level);
        }
        if (this._rightExpr.isReturnValueUnsure()) {
            this._rightExpr.confirmReturnValue(level);
        }
        if (!this._leftExpr.isReturnValueUnsure() && !this._rightExpr.isReturnValueUnsure()) {
            this._returnValue = this._op.computing(this._leftExpr.getReturnValue(), this._rightExpr.getReturnValue());
        }
    }

    @Override
    public AbstractExpr getLeftExpr() {
        return this._leftExpr;
    }

    @Override
    public AbstractExpr getRightExpr() {
        return this._rightExpr;
    }

    @Override
    public Oper getOper() {
        return this._op;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CompositeExpr) {
            CompositeExpr another = (CompositeExpr)obj;
            return this._leftExpr.equals(another.getLeftExpr()) && this._op.equals(another.getOper()) && this._rightExpr.equals(another.getRightExpr());
        }
        return false;
    }

    public int hashCode() {
        if (this._hashCode == 0) {
            this._hashCode = this._leftExpr.hashCode();
            this._hashCode = this._hashCode * 21 + this._rightExpr.hashCode();
            this._hashCode = this._hashCode * 21 + this._op.hashCode();
        }
        return this._hashCode;
    }
}

