/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute;

import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute.AbstractExpr;
import com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute.AbstractHExpr;
import com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute.ICompositeExpr;
import com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute.Oper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;

public class CompositeHExpr
extends AbstractHExpr
implements ICompositeExpr {
    private AbstractHExpr _leftExpr;
    private Oper _op;
    private AbstractHExpr _rightExpr;

    public CompositeHExpr(AbstractHExpr leftExpr, Oper op, AbstractHExpr rightExpr) {
        this._leftExpr = leftExpr;
        this._op = op;
        this._rightExpr = rightExpr;
    }

    @Override
    public String getExprString() {
        char leftBrack = '(';
        char rightBrack = ')';
        char blank = ' ';
        StringBuilder result = new StringBuilder();
        boolean bracketLeftExpr = false;
        if (this._leftExpr instanceof ICompositeExpr && ((ICompositeExpr)((Object)this._leftExpr)).getOper().getPriority() < this._op.getPriority()) {
            bracketLeftExpr = true;
            result.append(leftBrack);
        }
        result.append(this._leftExpr.getExprString());
        if (bracketLeftExpr) {
            result.append(rightBrack);
        }
        result.append(blank);
        result.append(this._op.toString());
        result.append(blank);
        boolean bracketRightExpr = false;
        if (this._rightExpr instanceof ICompositeExpr && ((ICompositeExpr)((Object)this._rightExpr)).getOper().getPriority() < this._op.getPriority()) {
            bracketRightExpr = true;
            result.append(leftBrack);
        }
        result.append(this._rightExpr.getExprString());
        if (bracketRightExpr) {
            result.append(rightBrack);
        }
        return result.toString();
    }

    @Override
    public AbstractExpr runtimeClone() {
        AbstractHExpr leftExpr = (AbstractHExpr)this._leftExpr.runtimeClone();
        AbstractHExpr rightExpr = (AbstractHExpr)this._rightExpr.runtimeClone();
        CompositeHExpr resultExpr = new CompositeHExpr(leftExpr, this._op, rightExpr);
        resultExpr._returnValue = this._returnValue;
        return resultExpr;
    }

    @Override
    public void computing(IWidgetExecuteHelper helper, String ds) throws SyntaxErrorException {
        this._leftExpr.computing(helper, ds);
        this._rightExpr.computing(helper, ds);
        this._returnValue = this._op.computing(this._leftExpr.getReturnValue(), this._rightExpr.getReturnValue());
    }

    @Override
    public AbstractExpr getLeftExpr() {
        return this._leftExpr;
    }

    @Override
    public AbstractExpr getRightExpr() {
        return this._rightExpr;
    }

    @Override
    public Oper getOper() {
        return this._op;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CompositeHExpr) {
            CompositeHExpr another = (CompositeHExpr)obj;
            return this._leftExpr.equals(another.getLeftExpr()) && this._op.equals(another.getOper()) && this._rightExpr.equals(another.getRightExpr());
        }
        return false;
    }

    public int hashCode() {
        return this._leftExpr.hashCode() * 1000 + this._rightExpr.hashCode() + this._op.hashCode();
    }

    @Override
    public void clearStat(int level) {
        this._leftExpr.clearStat(level);
        this._rightExpr.clearStat(level);
    }
}

