/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid;

import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IBind;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractCell;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractColumn;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.IGridsFactory;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractDataGrid;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractDetailRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractGroupRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.merge.MergeBlock;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.ContainerUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.Util;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.data.R1PrintBindDataSource;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGridCell;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGridDetailRow;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGridFactory;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.IDataGridRow;
import java.awt.Point;
import java.awt.Rectangle;
import kd.bos.dataentity.resource.ResManager;

public class DataGrid
extends AbstractDataGrid
implements ICompositeContainer {
    private boolean isSubGridField = false;

    public boolean isSubGrid() {
        return this.isSubGridField;
    }

    public void setSubGrid(boolean isSubGrid) {
        this.isSubGridField = isSubGrid;
    }

    public DataGrid() {
        this.setPrint(true);
    }

    public int getIndexOfDetailRow() {
        for (int i = 0; i < this.getRowsCount(); ++i) {
            AbstractRow row = this.getRow(i);
            if (!(row instanceof AbstractDetailRow) || ((IDataGridRow)((Object)row)).isBackwardForward()) continue;
            return i;
        }
        throw new RuntimeException("The DataGrid has no DetailRow. It's invalid.");
    }

    private boolean isNextRowSameGroup(AbstractGroupRow groupRow) {
        int idx = this.getIndexOfRow(groupRow);
        if (idx > 0 && this.isSameGroup(groupRow, this.getRow(idx - 1))) {
            return true;
        }
        return idx < this.getRowsCount() - 1 && this.isSameGroup(groupRow, this.getRow(idx + 1));
    }

    private boolean isSameGroup(AbstractGroupRow targetRow, AbstractRow compareRow) {
        if (compareRow instanceof AbstractGroupRow) {
            return targetRow.getGroup() == ((AbstractGroupRow)compareRow).getGroup();
        }
        return false;
    }

    private boolean isMoreThanOneDetailRow() {
        return false;
    }

    @Override
    public int[] locateDetailRow() {
        int[] ab = new int[2];
        ab[1] = -1;
        boolean isBefore = true;
        int c = this.getRowsCount();
        for (int i = 0; i < c; ++i) {
            if (isBefore && this.getRow(i) instanceof AbstractDetailRow) {
                ab[0] = i;
                isBefore = false;
                continue;
            }
            if (isBefore || this.getRow(i) instanceof AbstractDetailRow) continue;
            ab[1] = i;
            break;
        }
        if (ab[1] < 0) {
            ab[1] = c;
        }
        return ab;
    }

    @Override
    public IBind.IBindDataSource getDataSource() {
        if (this._bindDs == null) {
            this._bindDs = new R1PrintBindDataSource();
        }
        return this._bindDs;
    }

    @Override
    public String getType() {
        return "DataGrid";
    }

    @Override
    public String getIdPrefix() {
        return "dataGrid";
    }

    @Override
    public String getTypePrompt() {
        return ResManager.loadKDString((String)"\u6570\u636e\u8868", (String)"AbstractCell_7", (String)"bos-print-engine", (Object[])new Object[0]);
    }

    @Override
    public int getHeightLom() {
        return Util.pixel2Lom(this.getFeatHeight());
    }

    @Override
    public int getFeatHeight() {
        return this.addRowHeight(0, this.getRowsCount());
    }

    private int addRowHeight(int fromIdx, int toIdx) {
        int h = 0;
        for (int i = fromIdx; i < toIdx; ++i) {
            AbstractRow row = this.getRow(i);
            h += row.getFeatHeight() * this.getRowDrawingTimes(row);
        }
        return h;
    }

    @Override
    public int getRowDrawingTimes(AbstractRow row) {
        if (row instanceof DataGridDetailRow) {
            int times = ((DataGridDetailRow)row).getRepeatTimes();
            if (times == 0) {
                return 1;
            }
            AbstractRow[] bfRows = this.getBackwardForwardRow();
            if (bfRows[0] instanceof DataGridDetailRow) {
                --times;
            }
            if (bfRows[1] instanceof DataGridDetailRow) {
                --times;
            }
            return times > 0 ? times : 1;
        }
        return 1;
    }

    @Override
    public void setHeightLom(int height) {
        int old = this.heightLom;
        this.heightLom = height;
        this.firePropertyChange("heightLom", old, height);
    }

    @Override
    public int getWidthLom() {
        int w = 0;
        int colCnt = this.getColumnsCount();
        for (int j = 0; j < colCnt; ++j) {
            w += this.getColumn(j).getFeatWidth();
        }
        return Util.pixel2Lom(w);
    }

    @Override
    public void setWidthLom(int width) {
        int old = this.widthLom;
        this.widthLom = width;
        this.firePropertyChange("widthLom", old, width);
    }

    @Override
    public Point getRelativePosition(IElement ele) {
        Point rowColIdx = new Point(0, 0);
        if (ele instanceof AbstractCell) {
            rowColIdx = this.getIndexOfCell((AbstractCell)ele);
        } else if (ele instanceof AbstractRow) {
            rowColIdx.x = this.getIndexOfRow((AbstractRow)ele);
        } else if (ele instanceof AbstractColumn) {
            rowColIdx.y = this.getIndexOfColumn((AbstractColumn)ele);
        }
        int y = this.addRowHeight(0, rowColIdx.x);
        int x = 0;
        for (int j = 0; j < rowColIdx.y; ++j) {
            x += this.getColumn(j).getFeatWidth();
        }
        return new Point(x + this.getOffsetX(), y + this.getOffsetY());
    }

    @Override
    public Rectangle getSubElementRectangle(IElement ele) {
        Rectangle rect = new Rectangle();
        Point pt = this.getRelativePosition(ele);
        if (ele instanceof AbstractCell) {
            Point rowColIdx = this.getIndexOfCell((AbstractCell)ele);
            rect.x = pt.x;
            rect.y = pt.y;
            MergeBlock mb = ((AbstractCell)ele).getMergeBlock();
            if (mb != null && mb.isFirstCell(rowColIdx.x, rowColIdx.y)) {
                rect.width = mb.getBlockWidth(this);
                rect.height = mb.getBlockHeight(this);
            } else {
                rect.width = this.getColumn(rowColIdx.y).getFeatWidth();
                rect.height = this.getRow(rowColIdx.x).getFeatHeight();
            }
        } else if (ele instanceof AbstractRow) {
            int r = this.getIndexOfRow((AbstractRow)ele);
            rect.x = this.getOffsetX();
            rect.y = pt.y;
            rect.width = this.getFeatWidth();
            rect.height = this.getRow(r).getFeatHeight();
        } else if (ele instanceof AbstractColumn) {
            int c = this.getIndexOfColumn((AbstractColumn)ele);
            rect.x = pt.x;
            rect.y = this.getOffsetY();
            rect.width = this.getColumn(c).getFeatWidth();
            rect.height = this.getFeatHeight();
        }
        return rect;
    }

    protected int getIndexOfRowByPoint(int pixelYAtGrid) {
        if (pixelYAtGrid < 0) {
            return -1;
        }
        int h = this.getOffsetY();
        int rowCnt = this.getRowsCount();
        for (int i = 0; i < rowCnt; ++i) {
            AbstractRow row = this.getRow(i);
            if (pixelYAtGrid >= (h += row.getFeatHeight() * this.getRowDrawingTimes(row))) continue;
            return i;
        }
        return -1;
    }

    protected int getIndexOfColumnByPoint(int pixelXAtGrid) {
        if (pixelXAtGrid < 0) {
            return -1;
        }
        int w = this.getOffsetX();
        int colCnt = this.getColumnsCount();
        for (int j = 0; j < colCnt; ++j) {
            if (pixelXAtGrid >= (w += this.getColumn(j).getFeatWidth())) continue;
            return j;
        }
        return -1;
    }

    @Override
    protected IGridsFactory getGridsFactory() {
        return DataGridFactory.getPrintDataGridFactory();
    }

    public AbstractRow[] getBackwardForwardRow() {
        AbstractRow[] rows = new AbstractRow[2];
        boolean isBeforeDetail = true;
        int c = this.getRowsCount();
        for (int i = 0; i < c; ++i) {
            AbstractRow row = this.getRow(i);
            if (((IDataGridRow)((Object)row)).isBackwardForward()) {
                if (isBeforeDetail) {
                    rows[0] = row;
                    continue;
                }
                rows[1] = row;
                break;
            }
            if (!(row instanceof AbstractDetailRow)) continue;
            isBeforeDetail = false;
        }
        return rows;
    }

    @Override
    public void layoutAllSubContainer() {
        IContainer[] subContainers = this.getSubContainers();
        for (int i = 0; i < subContainers.length; ++i) {
            IContainer c = subContainers[i];
            if (c.getChildrenCount() <= 0) continue;
            for (IReportObject ro : c.getChildren()) {
                if (ro.isHorizontalFill()) {
                    ro.setXLom(0);
                    ro.setWidthLom(this.getSubContainerInsetsWidthLom(c));
                }
                if (ro.isVerticalFill()) {
                    ro.setYLom(0);
                    ro.setHeightLom(this.getSubContainerInsetsHeightLom(c));
                }
                if (ro instanceof IContainer) {
                    ((IContainer)((Object)ro)).layout();
                    continue;
                }
                if (!(ro instanceof ICompositeContainer)) continue;
                ((ICompositeContainer)((Object)ro)).layoutAllSubContainer();
            }
        }
    }

    @Override
    public IContainer[] getSubContainers() {
        return this.getCellsList().toArray(new IContainer[0]);
    }

    @Override
    public void addChild(IContainer subElement, IReportObject child) {
        if (!(subElement instanceof AbstractCell)) {
            throw new IllegalArgumentException("SubElement must be Cell");
        }
        subElement.addChild(child, null);
        ElementPath elementPath = this.makeElementPath((AbstractCell)((Object)subElement));
        child.setParent(elementPath);
    }

    @Override
    public void removeChild(IContainer subElement, IReportObject child) {
        subElement.removeChild(child);
        child.setParent(null);
    }

    @Override
    public int getSubContainerInsetsWidthLom(IContainer subElement) {
        AbstractCell cell = (AbstractCell)((Object)subElement);
        int w = this.getCellWidthLom(cell);
        Style style = cell.getStyle();
        if (style != null) {
            return w - style.getPadding().getLeft() - style.getPadding().getRight();
        }
        return w;
    }

    @Override
    public int getSubContainerInsetsHeightLom(IContainer subElement) {
        AbstractCell cell = (AbstractCell)((Object)subElement);
        int h = this.getCellHeightLom(cell);
        Style style = cell.getStyle();
        if (style != null) {
            return h - style.getPadding().getTop() - style.getPadding().getBottom();
        }
        return h;
    }

    private int getCellHeightLom(AbstractCell cell) {
        MergeBlock mb = cell.getMergeBlock();
        if (mb != null) {
            return mb.getBlockHeightLom(this);
        }
        int rowIdx = this.getIndexOfCell((AbstractCell)cell).x;
        return this.getRow(rowIdx).getHeightLom();
    }

    private int getCellWidthLom(AbstractCell cell) {
        MergeBlock mb = cell.getMergeBlock();
        if (mb != null) {
            return mb.getBlockWidthLom(this);
        }
        int colIdx = this.getIndexOfCell((AbstractCell)cell).y;
        return this.getColumn(colIdx).getWidthLom();
    }

    @Override
    protected int getRowChildrenMinRemain(int rowIdx) {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < this.getColumnsCount(); ++i) {
            DataGridCell cell = (DataGridCell)this.getCell(rowIdx, i);
            MergeBlock mb = cell.getMergeBlock();
            if (mb != null && !mb.isFirstCell(rowIdx, i)) {
                cell = (DataGridCell)this.getCell(mb.getTop(), mb.getLeft());
            }
            int bottom = ContainerUtil.searchChildrenMaxBottom(cell);
            int remain = this.getSubContainerInsetsHeightLom(cell) - bottom;
            if (remain >= min) continue;
            min = remain;
        }
        if (min == Integer.MAX_VALUE) {
            min = this.getRow(rowIdx).getHeightLom();
        }
        return min;
    }

    @Override
    protected int getColumnChildrenMinRemain(int colIdx) {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < this.getRowsCount(); ++i) {
            DataGridCell cell = (DataGridCell)this.getCell(i, colIdx);
            MergeBlock mb = cell.getMergeBlock();
            if (mb != null && !mb.isFirstCell(i, colIdx)) {
                cell = (DataGridCell)this.getCell(mb.getTop(), mb.getLeft());
            }
            int right = ContainerUtil.searchChildrenMaxRight(cell);
            int remain = this.getSubContainerInsetsWidthLom(cell) - right;
            if (remain >= min) continue;
            min = remain;
        }
        if (min == Integer.MAX_VALUE) {
            min = this.getColumn(colIdx).getWidthLom();
        }
        return min;
    }

    @Override
    public void afterAdjusted() {
        this.layoutAllSubContainer();
    }

    @Override
    public boolean isVerticalResizable() {
        return false;
    }
}

