/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.model.io;

import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IR1DataManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.IR1Page;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportModel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.AbstractR1XmlReader;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IR1XmlRecursiveReader;
import com.kingdee.bos.ctrl.reportone.r1.print.common.R1PrintInfo;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.data.R1PrintDataManager;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.R1PrintPage;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.R1PrintModelHelper;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Stream;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.PrintFormAp;
import kd.bos.metadata.form.PrintMetadata;
import kd.bos.metadata.print.control.BaseContainer;
import kd.bos.metadata.print.control.BaseControl;
import kd.bos.metadata.print.control.Footer;

public class R1PrintXmlReader
extends AbstractR1XmlReader {
    private static final Log log = LogFactory.getLog(R1PrintXmlReader.class);

    @Override
    public IR1Page createPage() {
        R1PrintPage page = new R1PrintPage();
        page.setWidthLom(1720);
        page.setHeightLom(2470);
        page.setExtendProperty("pi", new R1PrintInfo());
        return page;
    }

    @Override
    public IR1DataManager createDataManager() {
        return new R1PrintDataManager();
    }

    @Override
    protected void parseModel(ReportModel model, PrintMetadata meta) throws R1Exception {
        IR1Page page = this.parsePage(meta);
        model.setPage(page);
        if (!((R1PrintPage)page).isHeightSyncFromPaper()) {
            // empty if block
        }
    }

    private IR1Page parsePage(PrintMetadata meta) throws R1Exception {
        PrintFormAp printFormAp = null;
        for (BaseControl child : meta.getItems()) {
            if (!(child instanceof PrintFormAp)) continue;
            printFormAp = (PrintFormAp)child;
            break;
        }
        IR1Page page = this.parsePage(printFormAp);
        Stream<BaseControl> footerStream = meta.getItems().stream().filter(p -> p instanceof Footer);
        Optional<BaseControl> footerOpt = footerStream.findFirst();
        if (footerOpt.isPresent()) {
            page.setFooterHeight(this.parseToInt(footerOpt.get().getHeight().toString()));
        }
        this.loadContainer(this, null, null, page, meta);
        return page;
    }

    @Override
    protected void parseOthers(ReportModel model, PrintMetadata meta) throws R1Exception {
        R1PrintInfo info = R1PrintInfo.readFromMeta(meta);
        R1PrintModelHelper.setPrintInfo(model, info);
    }

    @Override
    public void loadContainer(IR1XmlRecursiveReader reader, BaseContainer<?> node, ICompositeContainer compositeContainer, IContainer container, PrintMetadata meta) throws R1Exception {
        Iterator it = null;
        it = meta != null ? meta.getRootItems().iterator() : node.get().iterator();
        while (it.hasNext()) {
            BaseControl child = (BaseControl)it.next();
            IReportObject ro = this.parseObject(reader, child, this.getStyleCache(), meta);
            if (ro == null) continue;
            if (compositeContainer == null) {
                container.addChild(ro, null);
                continue;
            }
            compositeContainer.addChild(container, ro);
        }
    }

    private IR1Page parsePage(PrintFormAp pageAp) {
        R1PrintPage page = (R1PrintPage)this.createPage();
        if (pageAp != null) {
            page.setId(pageAp.getId());
            int width = this.parseToInt(pageAp.getWidth().toString()) - this.parseToInt(pageAp.getMarginLeft().toString()) - this.parseToInt(pageAp.getMarginRight().toString());
            int height = this.parseToInt(pageAp.getHeight().toString()) - this.parseToInt(pageAp.getMarginTop().toString()) - this.parseToInt(pageAp.getMarginBottom().toString());
            page.setWidthLom(width);
            page.setHeightLom(height);
            String styleKey = "0";
            StyleAttributes sa = this.getStyleCache().getStyle(styleKey);
            if (sa != null) {
                page.setStyleAttribute(sa);
            }
        }
        return page;
    }
}

