/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.model.xmltrans;

import com.kingdee.bos.ctrl.kdf.util.render.r1print.DivideModel;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.factory.IAnObjectFactory;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.currency.CurrencyObject;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.currency.CurrencyProperty;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.util.Language;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.xmltrans.AbstractR1PrintXmlTrans;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.metadata.print.control.Amount;
import kd.bos.metadata.print.control.BaseControl;

public class CurrencyXmlTrans
extends AbstractR1PrintXmlTrans {
    public CurrencyXmlTrans(IAnObjectFactory factory) {
        super(factory);
    }

    @Override
    protected boolean isMatch(BaseControl<?> node) {
        return node instanceof Amount;
    }

    @Override
    protected IReportObject fromXml(BaseControl<?> node) throws R1Exception {
        int divideNums;
        CurrencyObject currency = (CurrencyObject)this.getFactory().create();
        this.loadObjectCommon(node, currency);
        Amount amt = (Amount)node;
        CurrencyProperty cp = currency.getCurrencyProperty();
        if (amt.getLetterType().equals("uppercase")) {
            cp.setUpperLower(1);
            String locale = RequestContext.get().getLang().name();
            if (StringUtils.isNotBlank((CharSequence)locale)) {
                cp.setLanguage(Language.getLanguage(""));
            }
        } else {
            cp.setUpperLower(0);
        }
        boolean isDivided = amt.isDivideModel();
        if (isDivided && (divideNums = amt.getDivideCharNums()) > 0) {
            currency.setDivideCharNums(divideNums);
            boolean isShowDivideLine = amt.isShowDivideLine();
            if (isShowDivideLine) {
                DivideModel model = new DivideModel();
                model.setShowLine(isShowDivideLine);
                StyleAttributes ssa = this.getStyleCache().getStyle("divideLineId");
                model.upDataDivideLine(ssa);
                currency.setDivideModel(model);
            }
        }
        cp.setIgnoreTailZero(amt.isIgnoreTailZero());
        cp.setIgnoreZero(amt.isIgnoreZero());
        cp.setNoteType(false);
        Long inteFormatId = 0L;
        if (amt.getInteFormatId() != null) {
            inteFormatId = amt.getInteFormatId();
        }
        cp.setInteFormatId(inteFormatId);
        if (amt.isShowCySymbol()) {
            cp.setAddPrefix(true);
            cp.setShowCySymbol(amt.isShowCySymbol());
        } else if (amt.isShowCyCode()) {
            cp.setAddPrefix(true);
            cp.setShowCyCode(amt.isShowCyCode());
        } else if (StringUtils.isNotBlank((CharSequence)amt.getSymbol())) {
            cp.setAddPrefix(true);
            cp.setCodeConstant(amt.getSymbol());
        } else {
            cp.setAddPrefix(false);
        }
        return currency;
    }

    @Override
    protected void loadDataNode(BaseControl<?> nodeRo, IReportObject ro) {
        super.loadDataNode(nodeRo, ro);
        CurrencyObject currency = (CurrencyObject)ro;
        LocaleString text = nodeRo.getBindText();
        if (StringUtils.isNotBlank((Object)text)) {
            currency.setText(text.toString());
        }
    }
}

