/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.model.xmltrans.grid;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.Field;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractCell;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractGrid;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.CellField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.ICellValue;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.StatField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.Text;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.merge.MergeBlock;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGridCell;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGridGroupRow;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.R1PrintGroup;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.cellvalue.GridCompute;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.layoutgrid.LayoutGridCell;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.layoutgrid.cellvalue.CellAloneField;
import java.awt.Point;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.metadata.print.control.DataCell;
import kd.bos.metadata.print.control.LayoutCell;
import org.dom4j.Element;
import org.dom4j.tree.DefaultCDATA;
import org.dom4j.tree.DefaultElement;

class GridXmlTransUtil {
    private static final String CUSTOM = "custom";
    private static final String ACCORDING = "according";
    private static final String STAT_SUM = "sum";
    private static final String STAT_AVG = "avg";
    private static final String STAT_MAX = "max";
    private static final String STAT_MIN = "min";
    private static final String STAT_COUNT = "count";
    private static final String STAT_RANGE_AREA = "area";
    private static final String STAT_RANGE_CUMULATION = "cumulation";
    private static final String STAT_RANGE_AREA_GROUP = "areagroup";
    private static final String GROUP_ACCORDING_FIELD = "field";
    private static final String GROUP_ACCORDING_FORMULA = "formula";

    GridXmlTransUtil() {
    }

    static void loadCellValue(DataCell nodeCell, DataGridCell cell) {
        if (nodeCell.get().size() == 0) {
            ICellValue cellValue = null;
            String type = nodeCell.getCellType();
            if (type.equals("text")) {
                String textValue = nodeCell.getBindText() == null ? "" : nodeCell.getBindText().toString();
                cellValue = new Text(textValue);
            } else if (type.equals(GROUP_ACCORDING_FIELD)) {
                cellValue = CellField.create(nodeCell.getBindField(), null);
            } else if (type.equals(CUSTOM)) {
                cellValue = CellField.create(nodeCell.getCustomField(), null);
            } else if (type.equals("combination")) {
                cellValue = CellField.create(nodeCell.getCombineField(), null);
            } else if (type.equals("stat")) {
                cellValue = new StatField();
                Field mf = Field.valueOf(nodeCell.getBindField(), null);
                ((StatField)cellValue).setField(mf);
                String statType = nodeCell.getStatType();
                ((StatField)cellValue).setType(GridXmlTransUtil.loadStatType(statType));
                String statRange = nodeCell.getStatRange();
                ((StatField)cellValue).setRange(GridXmlTransUtil.loadStatRange(statRange));
            } else if (StringUtil.equals(type, "compute")) {
                cellValue = new GridCompute();
            }
            cell.setValue(cellValue);
        }
    }

    private static int loadStatType(String statType) {
        if (StringUtil.equalsIgnoreCase(STAT_SUM, statType)) {
            return 1;
        }
        if (StringUtil.equalsIgnoreCase(STAT_AVG, statType)) {
            return 2;
        }
        if (StringUtil.equalsIgnoreCase(STAT_MAX, statType)) {
            return 3;
        }
        if (StringUtil.equalsIgnoreCase(STAT_MIN, statType)) {
            return 4;
        }
        if (StringUtil.equalsIgnoreCase(STAT_COUNT, statType)) {
            return 5;
        }
        return 1;
    }

    private static int loadStatRange(String statRange) {
        if (StringUtil.equalsIgnoreCase(STAT_RANGE_AREA, statRange)) {
            return 17;
        }
        if (StringUtil.equalsIgnoreCase(STAT_RANGE_CUMULATION, statRange)) {
            return 16;
        }
        if (StringUtil.equalsIgnoreCase(STAT_RANGE_AREA_GROUP, statRange)) {
            return 19;
        }
        return 18;
    }

    static void loadCellValue(LayoutCell nodeCell, LayoutGridCell cell) {
        if (nodeCell.get().isEmpty()) {
            String ds;
            String textValue = nodeCell.getBindText() == null ? "" : nodeCell.getBindText().toString();
            ICellValue cellValue = new Text(textValue);
            String type = nodeCell.getCellType();
            if (type.equals("text")) {
                LocaleString bindText = nodeCell.getBindText();
                if (bindText != null) {
                    cellValue = new Text(bindText.toString());
                }
            } else if ((type.equals(GROUP_ACCORDING_FIELD) || type.equals(CUSTOM)) && StringUtils.isNotBlank((CharSequence)(ds = nodeCell.getDataSource()))) {
                String dsString = "";
                try {
                    Map mapData = (Map)SerializationUtils.fromJsonString((String)ds, Map.class);
                    dsString = ObjectUtils.isEmpty(mapData.get("cuskey")) ? (String)mapData.get("key") : (String)mapData.get("cuskey");
                }
                catch (Exception e) {
                    dsString = ds;
                }
                String field = nodeCell.getBindField();
                if (type.equals(CUSTOM)) {
                    field = nodeCell.getCustomField();
                }
                cellValue = CellAloneField.create(dsString, field, null);
            }
            cell.setValue(cellValue);
        }
    }

    static void saveCellValue(LayoutGridCell cell, Element nodeCell) {
        ICellValue value = cell.getValue();
        if (value != null) {
            DefaultElement nodeValue = new DefaultElement("Value");
            switch (value.getCellType()) {
                case 1: {
                    nodeValue.addAttribute("type", "text");
                    String content = ((Text)value).getText();
                    nodeValue.setContent(Stream.of(new DefaultCDATA(content)).collect(Collectors.toList()));
                    break;
                }
                case 21: {
                    nodeValue.addAttribute("type", GROUP_ACCORDING_FIELD);
                    CellAloneField vfield = (CellAloneField)value;
                    if (vfield.isInvalid()) break;
                    nodeValue.addAttribute("dataSource", vfield.getDs());
                    String content = vfield.getField().getName();
                    nodeValue.addElement(content);
                    break;
                }
            }
            nodeCell.add((Element)nodeValue);
        }
    }

    static class GroupsSaver {
        private HashMap<R1PrintGroup, String> mapGroups = new HashMap(4);
        private int iGroupId = 0;

        GroupsSaver() {
        }

        public void storeGroup(DataGridGroupRow row, Element nodeRow) {
            String groupId;
            R1PrintGroup group = (R1PrintGroup)row.getGroup();
            if (this.mapGroups.containsKey(group)) {
                groupId = this.mapGroups.get(group);
            } else {
                groupId = "g" + this.iGroupId++;
                this.mapGroups.put(group, groupId);
            }
            nodeRow.addAttribute("group", groupId);
        }

        public void saveGroups(Element nodeGrid) {
            if (this.mapGroups.size() > 0) {
                DefaultElement nodeGroups = new DefaultElement("Groups");
                for (Map.Entry<R1PrintGroup, String> entry : this.mapGroups.entrySet()) {
                    R1PrintGroup group = entry.getKey();
                    String groupId = entry.getValue();
                    DefaultElement nodeGroup = new DefaultElement("Group");
                    nodeGroup.addAttribute("id", groupId);
                    if (group.getAccordingType() == 2) {
                        nodeGroup.addAttribute(GridXmlTransUtil.ACCORDING, GridXmlTransUtil.GROUP_ACCORDING_FORMULA);
                    } else {
                        nodeGroup.addAttribute(GridXmlTransUtil.ACCORDING, GridXmlTransUtil.GROUP_ACCORDING_FIELD);
                    }
                    if (group.isDividePageWhenDifferGroup()) {
                        nodeGroup.addAttribute("dividePage", "true");
                    }
                    nodeGroup.setText(group.getAccording());
                    nodeGroups.add((Element)nodeGroup);
                }
                nodeGrid.add((Element)nodeGroups);
            }
        }
    }

    static class MergeBlocksSaver {
        private Element nodeMergeBlocks = new DefaultElement("MergeBlocks");

        MergeBlocksSaver() {
        }

        public void saveMergeBlocks(Element nodeGrid) {
            if (this.nodeMergeBlocks.elements().size() > 0) {
                nodeGrid.add(this.nodeMergeBlocks);
            }
        }

        public void storeMergeBlock(AbstractGrid grid, AbstractCell cell) {
            if (cell.getMergeBlock() != null) {
                MergeBlock mb = cell.getMergeBlock();
                Point pt = grid.getIndexOfCell(cell);
                if (mb.isFirstCell(pt.x, pt.y)) {
                    DefaultElement nodeBlock = new DefaultElement("Block");
                    nodeBlock.addAttribute("left", String.valueOf(mb.getLeft()));
                    nodeBlock.addAttribute("right", String.valueOf(mb.getRight()));
                    nodeBlock.addAttribute("top", String.valueOf(mb.getTop()));
                    nodeBlock.addAttribute("bottom", String.valueOf(mb.getBottom()));
                    this.nodeMergeBlocks.add((Element)nodeBlock);
                }
            }
        }
    }

    static class GroupsLoader {
        private HashMap mapGroups = new HashMap();

        GroupsLoader() {
        }

        public void loadGroups(Element nodeGrid) {
            Element nodeGroups = nodeGrid.element("Groups");
            if (nodeGroups == null) {
                return;
            }
            List list = nodeGroups.elements();
            for (int i = 0; i < list.size(); ++i) {
                Element nodeGroup = (Element)list.get(i);
                String groupId = nodeGroup.attributeValue("id");
                R1PrintGroup group = new R1PrintGroup(nodeGroup.getText());
                if (GridXmlTransUtil.GROUP_ACCORDING_FORMULA.equals(nodeGroup.attributeValue(GridXmlTransUtil.ACCORDING))) {
                    group.setAccordingType(2);
                } else {
                    group.setAccordingType(1);
                }
                group.setDividePageWhenDifferGroup("true".equals(nodeGroup.attributeValue("dividePage")));
                this.mapGroups.put(groupId, group);
            }
        }

        public void supplyGroup(Element nodeRow, DataGridGroupRow row) {
            String id = nodeRow.attributeValue("group");
            R1PrintGroup group = (R1PrintGroup)this.mapGroups.get(id);
            row.setGroup(group);
        }
    }

    static class MergeBlocksLoader {
        MergeBlocksLoader() {
        }

        static void loadMergeBlock(List<Map<String, Integer>> nodeMergeBlocks, AbstractGrid grid) {
            if (nodeMergeBlocks != null && nodeMergeBlocks.size() > 0) {
                for (Map<String, Integer> nodeBlock : nodeMergeBlocks) {
                    int left = nodeBlock.get("left");
                    int right = nodeBlock.get("right");
                    int top = nodeBlock.get("top");
                    int bottom = nodeBlock.get("bottom");
                    MergeBlock mb = MergeBlock.create(left, right, top, bottom);
                    for (int i = top; i <= bottom; ++i) {
                        for (int j = left; j <= right; ++j) {
                            AbstractCell cell = grid.getCell(i, j);
                            cell.setMergeBlock(mb);
                        }
                    }
                }
            }
        }
    }
}

