/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.model.xmltrans.grid;

import com.kingdee.bos.ctrl.kdf.util.render.r1print.DivideModel;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.factory.IAnObjectFactory;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractColumn;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractGrid;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractRow;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGridCell;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGridDetailRow;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGridGroupRow;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGridNormalRow;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.IDataGridRow;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.IDisplayEveryPage;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.R1PrintGroup;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.xmltrans.AbstractR1PrintXmlTrans;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.xmltrans.grid.GridXmlTransUtil;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.print.control.BaseContainer;
import kd.bos.metadata.print.control.BaseControl;
import kd.bos.metadata.print.control.BaseGrid;
import kd.bos.metadata.print.control.DataCell;
import kd.bos.metadata.print.control.DataColumn;
import kd.bos.metadata.print.control.DataGrid;
import kd.bos.metadata.print.control.DataRow;
import kd.bos.metadata.print.control.SubDataGrid;

public class PrintDataGridXmlTrans
extends AbstractR1PrintXmlTrans {
    private static final Log log = LogFactory.getLog(PrintDataGridXmlTrans.class);
    private HashMap<String, R1PrintGroup> mapGroups = new HashMap();

    public PrintDataGridXmlTrans(IAnObjectFactory factory) {
        super(factory);
    }

    @Override
    protected boolean isMatch(BaseControl<?> node) {
        return node instanceof DataGrid || node instanceof SubDataGrid;
    }

    @Override
    protected IReportObject fromXml(BaseControl<?> node) throws R1Exception {
        com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGrid grid = new com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGrid();
        if (node instanceof SubDataGrid) {
            grid.setSubGrid(true);
        }
        this.loadObjectCommon(node, grid);
        BaseContainer gridMeta = (BaseContainer)node;
        for (BaseControl control : gridMeta.get()) {
            if (!(control instanceof DataColumn)) continue;
            this.loadColumn(control, grid);
        }
        for (BaseControl control : gridMeta.get()) {
            if (!(control instanceof DataRow)) continue;
            this.loadRow((DataRow)control, grid);
        }
        BaseGrid baseGridMeta = (BaseGrid)node;
        if (baseGridMeta.getMergeBlocks() != null) {
            List blocks = baseGridMeta.getMergeBlocks();
            GridXmlTransUtil.MergeBlocksLoader.loadMergeBlock(blocks, grid);
        }
        return grid;
    }

    private void loadColumn(BaseControl<?> nodeCol, AbstractGrid grid) {
        String type = ((DataColumn)nodeCol).getColumnType();
        boolean isMergeDetailCol = ((DataColumn)nodeCol).isMergeDetailCol();
        AbstractColumn column = grid.addColumn();
        column.setColumnType(type);
        column.setMergeDetailCol(isMergeDetailCol);
        this.loadElementCommon(nodeCol, column);
        column.setWidthLom(this.parseInt(nodeCol.getWidth().toString()));
    }

    private void loadRow(DataRow designRow, com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGrid grid) throws R1Exception {
        AbstractRow row;
        String rowType = designRow.getRowType();
        if (rowType.equalsIgnoreCase("detail")) {
            row = grid.addRow(2);
            int repeatTimes = designRow.getRepeatTimes();
            if ("report".equals(designRow.getPrintType())) {
                ((DataGridDetailRow)row).setRepeatTimes(0);
                row.setFixedHeight(!designRow.isAutoAdjustHeight());
            } else if ("template".equals(designRow.getPrintType())) {
                row.setFixedHeight(true);
                ((DataGridDetailRow)row).setRepeatTimes(repeatTimes);
            }
            ((DataGridDetailRow)row).setNotBlankRow(designRow.isNotBlankRow());
        } else if (rowType.equalsIgnoreCase("extend")) {
            row = grid.addRow(5);
            row.setExtRow(true);
        } else if (rowType.equalsIgnoreCase("startgroup") || rowType.equalsIgnoreCase("endgroup") || rowType.equalsIgnoreCase("group")) {
            row = grid.addRow(3);
            R1PrintGroup group = null;
            String id = designRow.getGroupID();
            if (this.mapGroups.containsKey(id)) {
                group = this.mapGroups.get(id);
            } else if (StringUtils.isNotBlank((CharSequence)designRow.getGroupField())) {
                group = new R1PrintGroup(designRow.getGroupField());
                group.setAccordingType(1);
                group.setDividePageWhenDifferGroup(designRow.isDividePage());
                this.mapGroups.put(id, group);
            }
            if (group != null) {
                ((DataGridGroupRow)row).setGroup(group);
            }
            this.loadRowCommon(designRow, (DataGridGroupRow)row);
        } else {
            row = grid.addRow(1);
            this.loadRowCommon(designRow, (DataGridNormalRow)row);
        }
        this.loadElementCommon((BaseControl<?>)designRow, row);
        row.setHeightLom(this.parseInt(designRow.getHeight().toString()));
        ((IDataGridRow)((Object)row)).setBackwardForward(designRow.isBackwardForward());
        List cells = designRow.get();
        for (int i = 0; i < cells.size(); ++i) {
            DataCell designCell = (DataCell)cells.get(i);
            DataGridCell cell = (DataGridCell)row.getCell(i);
            this.loadCell(designCell, grid, cell);
        }
    }

    private void loadRowCommon(DataRow nodeRow, IDisplayEveryPage row) {
        row.setDisplayEveryPage(nodeRow.isDisplayEveryPage());
    }

    private void loadCell(DataCell designCell, com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGrid grid, DataGridCell cell) throws R1Exception {
        int divideNums;
        this.loadElementCommon((BaseControl<?>)designCell, cell);
        GridXmlTransUtil.loadCellValue(designCell, cell);
        boolean isDivided = designCell.isDivideModel();
        if (isDivided && (divideNums = designCell.getDivideCharNums()) > 0) {
            cell.setDivideCharNums(divideNums);
            boolean isShowDivideLine = designCell.isShowDivideLine();
            if (isShowDivideLine) {
                DivideModel model = new DivideModel();
                model.setShowLine(isShowDivideLine);
                StyleAttributes ssa = this.getStyleCache().getStyle("divideLineId");
                model.upDataDivideLine(ssa);
                cell.setDivideModel(model);
            }
        }
        boolean sumAfterFormat = designCell.isSumAfterFormat();
        cell.setSumAfterFormat(sumAfterFormat);
        this.r1Reader.loadContainer(this.r1Reader, (BaseContainer<?>)designCell, grid, cell, null);
    }

    @Override
    protected void loadObjectLocation(BaseControl<?> nodeRo, IReportObject ro) {
        ro.setXLom(this.parseInt(nodeRo.getX().toString()));
        ro.setYLom(this.parseInt(nodeRo.getY().toString()));
    }
}

